/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.ServerTransactionExt;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.Expires;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import java.io.IOException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ObjectInUseException;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.header.Header;
import javax.sip.message.Response;

public class SIPServerTransaction
extends SIPTransaction
implements ServerRequestInterface,
ServerTransaction,
ServerTransactionExt {
    private int rseqNumber;
    private transient ServerRequestInterface requestOf;
    private SIPDialog dialog;
    private SIPResponse pendingReliableResponse;
    private ProvisionalResponseTask provisionalResponseTask;
    private boolean retransmissionAlertEnabled;
    private RetransmissionAlertTimerTask retransmissionAlertTimerTask;
    private ListenerExecutionMaxTimer listenerExecutionMaxTimer;
    protected boolean isAckSeen;
    private SIPClientTransaction pendingSubscribeTransaction;
    private SIPServerTransaction inviteTransaction;
    private static boolean interlockProvisionalResponses = true;
    private Semaphore provisionalResponseSem = new Semaphore(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(SIPResponse transactionResponse) throws IOException {
        block11: {
            try {
                if (this.isReliable()) {
                    this.getMessageChannel().sendMessage(transactionResponse);
                    break block11;
                }
                Via via = transactionResponse.getTopmostVia();
                String transport = via.getTransport();
                if (transport == null) {
                    throw new IOException("missing transport!");
                }
                int port = via.getRPort();
                if (port == -1) {
                    port = via.getPort();
                }
                if (port == -1) {
                    port = transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
                }
                String host = null;
                if (via.getMAddr() != null) {
                    host = via.getMAddr();
                } else {
                    host = via.getParameter("received");
                    if (host == null) {
                        host = via.getHost();
                    }
                }
                Hop hop = this.sipStack.addressResolver.resolveAddress(new HopImpl(host, port, transport));
                MessageChannel messageChannel = this.getSIPStack().createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.getPort(), hop);
                if (messageChannel != null) {
                    messageChannel.sendMessage(transactionResponse);
                    break block11;
                }
                throw new IOException("Could not create a message channel for " + hop + " with source IP:Port " + this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress() + ":" + this.getPort());
            }
            finally {
                this.startTransactionTimer();
            }
        }
    }

    protected SIPServerTransaction(SIPTransactionStack sipStack, MessageChannel newChannelToUse) {
        super(sipStack, newChannelToUse);
        if (sipStack.maxListenerResponseTime != -1) {
            this.listenerExecutionMaxTimer = new ListenerExecutionMaxTimer();
            sipStack.getTimer().schedule((TimerTask)this.listenerExecutionMaxTimer, sipStack.maxListenerResponseTime * 1000);
        }
        this.rseqNumber = (int)(Math.random() * 1000.0);
        if (sipStack.isLoggingEnabled(32)) {
            sipStack.getStackLogger().logDebug("Creating Server Transaction" + this.getBranchId());
            sipStack.getStackLogger().logStackTrace();
        }
    }

    public void setRequestInterface(ServerRequestInterface newRequestOf) {
        this.requestOf = newRequestOf;
    }

    public MessageChannel getResponseChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        ViaList viaHeaders;
        boolean transactionMatches = false;
        String method = messageToTest.getCSeq().getMethod();
        if ((method.equals("INVITE") || !this.isTerminated()) && (viaHeaders = messageToTest.getViaHeaders()) != null) {
            Via topViaHeader = (Via)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.toLowerCase().startsWith("z9hg4bk")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                transactionMatches = method.equals("CANCEL") ? this.getMethod().equals("CANCEL") && this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy()) : this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy());
            } else {
                String originalFromTag = this.fromTag;
                String thisFromTag = messageToTest.getFrom().getTag();
                boolean skipFrom = originalFromTag == null || thisFromTag == null;
                String originalToTag = this.toTag;
                String thisToTag = messageToTest.getTo().getTag();
                boolean skipTo = originalToTag == null || thisToTag == null;
                boolean isResponse = messageToTest instanceof SIPResponse;
                if (messageToTest.getCSeq().getMethod().equalsIgnoreCase("CANCEL") && !this.getOriginalRequest().getCSeq().getMethod().equalsIgnoreCase("CANCEL")) {
                    transactionMatches = false;
                } else if ((isResponse || this.getOriginalRequest().getRequestURI().equals(((SIPRequest)messageToTest).getRequestURI())) && (skipFrom || originalFromTag != null && originalFromTag.equalsIgnoreCase(thisFromTag)) && (skipTo || originalToTag != null && originalToTag.equalsIgnoreCase(thisToTag)) && this.getOriginalRequest().getCallId().getCallId().equalsIgnoreCase(messageToTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSeqNumber() == messageToTest.getCSeq().getSeqNumber() && (!messageToTest.getCSeq().getMethod().equals("CANCEL") || this.getOriginalRequest().getMethod().equals(messageToTest.getCSeq().getMethod())) && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    protected void map() {
        TransactionState realState = this.getRealState();
        if (realState == null || realState == TransactionState.TRYING) {
            if (this.isInviteTransaction() && !this.isMapped && this.sipStack.getTimer() != null) {
                this.isMapped = true;
                this.sipStack.getTimer().schedule((TimerTask)new SendTrying(), 200L);
            } else {
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction(this);
    }

    public boolean isTransactionMapped() {
        return this.isMapped;
    }

    public void processRequest(SIPRequest transactionRequest, MessageChannel sourceChannel) {
        block38: {
            boolean toTu = false;
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("processRequest: " + transactionRequest.getFirstLine());
                this.sipStack.getStackLogger().logDebug("tx state = " + this.getRealState());
            }
            try {
                if (this.getRealState() == null) {
                    this.setOriginalRequest(transactionRequest);
                    this.setState(TransactionState.TRYING);
                    toTu = true;
                    this.setPassToListener();
                    if (this.isInviteTransaction() && this.isMapped) {
                        this.sendMessage(transactionRequest.createResponse(100, "Trying"));
                    }
                } else {
                    if (this.isInviteTransaction() && TransactionState.COMPLETED == this.getRealState() && transactionRequest.getMethod().equals("ACK")) {
                        this.setState(TransactionState.CONFIRMED);
                        this.disableRetransmissionTimer();
                        if (!this.isReliable()) {
                            this.enableTimeoutTimer(this.TIMER_I);
                        } else {
                            this.setState(TransactionState.TERMINATED);
                        }
                        if (this.sipStack.isNon2XXAckPassedToListener()) {
                            this.requestOf.processRequest(transactionRequest, this);
                        } else {
                            if (this.sipStack.isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("ACK received for server Tx " + this.getTransactionId() + " not delivering to application!");
                            }
                            this.semRelease();
                        }
                        return;
                    }
                    if (transactionRequest.getMethod().equals(this.getOriginalRequest().getMethod())) {
                        if (TransactionState.PROCEEDING == this.getRealState() || TransactionState.COMPLETED == this.getRealState()) {
                            this.semRelease();
                            if (this.lastResponse != null) {
                                super.sendMessage(this.lastResponse);
                            }
                        } else if (transactionRequest.getMethod().equals("ACK")) {
                            if (this.requestOf != null) {
                                this.requestOf.processRequest(transactionRequest, this);
                            } else {
                                this.semRelease();
                            }
                        }
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("completed processing retransmitted request : " + transactionRequest.getFirstLine() + this + " txState = " + this.getState() + " lastResponse = " + this.getLastResponse());
                        }
                        return;
                    }
                }
                if (TransactionState.COMPLETED != this.getRealState() && TransactionState.TERMINATED != this.getRealState() && this.requestOf != null) {
                    if (this.getOriginalRequest().getMethod().equals(transactionRequest.getMethod())) {
                        if (toTu) {
                            this.requestOf.processRequest(transactionRequest, this);
                        } else {
                            this.semRelease();
                        }
                    } else if (this.requestOf != null) {
                        this.requestOf.processRequest(transactionRequest, this);
                    } else {
                        this.semRelease();
                    }
                    break block38;
                }
                this.getSIPStack();
                if (SIPTransactionStack.isDialogCreated(this.getOriginalRequest().getMethod()) && this.getRealState() == TransactionState.TERMINATED && transactionRequest.getMethod().equals("ACK") && this.requestOf != null) {
                    SIPDialog thisDialog = this.dialog;
                    if (thisDialog == null || !thisDialog.ackProcessed) {
                        if (thisDialog != null) {
                            thisDialog.ackReceived(transactionRequest);
                            thisDialog.ackProcessed = true;
                        }
                        this.requestOf.processRequest(transactionRequest, this);
                    } else {
                        this.semRelease();
                    }
                } else if (transactionRequest.getMethod().equals("CANCEL")) {
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Too late to cancel Transaction");
                    }
                    this.semRelease();
                    try {
                        this.sendMessage(transactionRequest.createResponse(200));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Dropping request " + this.getRealState());
                }
            }
            catch (IOException e) {
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logError("IOException ", e);
                }
                this.semRelease();
                this.raiseIOExceptionEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        try {
            SIPResponse transactionResponse = (SIPResponse)messageToSend;
            int statusCode = transactionResponse.getStatusCode();
            try {
                if (this.getOriginalRequest().getTopmostVia().getBranch() != null) {
                    transactionResponse.getTopmostVia().setBranch(this.getBranch());
                } else {
                    transactionResponse.getTopmostVia().removeParameter("branch");
                }
                if (!this.getOriginalRequest().getTopmostVia().hasPort()) {
                    transactionResponse.getTopmostVia().removePort();
                }
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            if (!transactionResponse.getCSeq().getMethod().equals(this.getOriginalRequest().getMethod())) {
                this.sendResponse(transactionResponse);
                return;
            }
            if (this.getRealState() == TransactionState.TRYING) {
                if (statusCode / 100 == 1) {
                    this.setState(TransactionState.PROCEEDING);
                } else if (200 <= statusCode && statusCode <= 699) {
                    if (!this.isInviteTransaction()) {
                        if (!this.isReliable()) {
                            this.setState(TransactionState.COMPLETED);
                            this.enableTimeoutTimer(64);
                        } else {
                            this.setState(TransactionState.TERMINATED);
                        }
                    } else if (statusCode / 100 == 2) {
                        this.disableRetransmissionTimer();
                        this.disableTimeoutTimer();
                        this.collectionTime = 64;
                        this.setState(TransactionState.TERMINATED);
                        if (this.dialog != null) {
                            this.dialog.setRetransmissionTicks();
                        }
                    } else {
                        this.setState(TransactionState.COMPLETED);
                        if (!this.isReliable()) {
                            this.enableRetransmissionTimer();
                        }
                        this.enableTimeoutTimer(64);
                    }
                }
            } else if (this.getRealState() == TransactionState.PROCEEDING) {
                if (this.isInviteTransaction()) {
                    if (statusCode / 100 == 2) {
                        this.disableRetransmissionTimer();
                        this.disableTimeoutTimer();
                        this.collectionTime = 64;
                        this.setState(TransactionState.TERMINATED);
                        if (this.dialog != null) {
                            this.dialog.setRetransmissionTicks();
                        }
                    } else if (300 <= statusCode && statusCode <= 699) {
                        this.setState(TransactionState.COMPLETED);
                        if (!this.isReliable()) {
                            this.enableRetransmissionTimer();
                        }
                        this.enableTimeoutTimer(64);
                    }
                } else if (200 <= statusCode && statusCode <= 699) {
                    this.setState(TransactionState.COMPLETED);
                    if (!this.isReliable()) {
                        this.disableRetransmissionTimer();
                        this.enableTimeoutTimer(64);
                    } else {
                        this.setState(TransactionState.TERMINATED);
                    }
                }
            } else if (TransactionState.COMPLETED == this.getRealState()) {
                return;
            }
            try {
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("sendMessage : tx = " + this + " getState = " + this.getState());
                }
                this.lastResponse = transactionResponse;
                this.sendResponse(transactionResponse);
            }
            catch (IOException e) {
                this.setState(TransactionState.TERMINATED);
                this.collectionTime = 0;
                throw e;
            }
        }
        finally {
            this.startTransactionTimer();
        }
    }

    public String getViaHost() {
        return this.getMessageChannel().getViaHost();
    }

    public int getViaPort() {
        return this.getMessageChannel().getViaPort();
    }

    protected void fireRetransmissionTimer() {
        try {
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("fireRetransmissionTimer() -- ");
            }
            if (this.isInviteTransaction() && this.lastResponse != null) {
                if (!this.retransmissionAlertEnabled || this.sipStack.isTransactionPendingAck(this)) {
                    if (this.lastResponse.getStatusCode() / 100 > 2 && !this.isAckSeen) {
                        super.sendMessage(this.lastResponse);
                    }
                } else {
                    SipProviderImpl sipProvider = this.getSipProvider();
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)sipProvider, (ServerTransaction)this, Timeout.RETRANSMIT);
                    sipProvider.handleEvent((EventObject)txTimeout, this);
                }
            }
        }
        catch (IOException e) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(e);
            }
            this.raiseErrorEvent(2);
        }
    }

    private void fireReliableResponseRetransmissionTimer() {
        try {
            super.sendMessage(this.pendingReliableResponse);
        }
        catch (IOException e) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(e);
            }
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    protected void fireTimeoutTimer() {
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("SIPServerTransaction.fireTimeoutTimer this = " + this + " current state = " + this.getRealState() + " method = " + this.getOriginalRequest().getMethod());
        }
        if (this.getMethod().equals("INVITE") && this.sipStack.removeTransactionPendingAck(this)) {
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Found tx pending ACK - returning");
            }
            return;
        }
        SIPDialog dialog = this.dialog;
        this.getSIPStack();
        if (SIPTransactionStack.isDialogCreated(this.getOriginalRequest().getMethod()) && (TransactionState.CALLING == this.getRealState() || TransactionState.TRYING == this.getRealState())) {
            dialog.setState(3);
        } else if (this.getOriginalRequest().getMethod().equals("BYE") && dialog != null && dialog.isTerminatedOnBye()) {
            dialog.setState(3);
        }
        if (TransactionState.COMPLETED == this.getRealState() && this.isInviteTransaction()) {
            this.raiseErrorEvent(1);
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (TransactionState.COMPLETED == this.getRealState() && !this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (TransactionState.CONFIRMED == this.getRealState() && this.isInviteTransaction()) {
            this.setState(TransactionState.TERMINATED);
            this.sipStack.removeTransaction(this);
        } else if (!(this.isInviteTransaction() || TransactionState.COMPLETED != this.getRealState() && TransactionState.CONFIRMED != this.getRealState())) {
            this.setState(TransactionState.TERMINATED);
        } else if (this.isInviteTransaction() && TransactionState.TERMINATED == this.getRealState()) {
            this.raiseErrorEvent(1);
            if (dialog != null) {
                dialog.setState(3);
            }
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public void setOriginalRequest(SIPRequest originalRequest) {
        super.setOriginalRequest(originalRequest);
    }

    public void sendResponse(Response response) throws SipException {
        SIPResponse sipResponse = (SIPResponse)response;
        SIPDialog dialog = this.dialog;
        if (response == null) {
            throw new NullPointerException("null response");
        }
        try {
            sipResponse.checkHeaders();
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        if (!sipResponse.getCSeq().getMethod().equals(this.getMethod())) {
            throw new SipException("CSeq method does not match Request method of request that created the tx.");
        }
        if (this.getMethod().equals("SUBSCRIBE") && response.getStatusCode() / 100 == 2) {
            if (response.getHeader("Expires") == null) {
                throw new SipException("Expires header is mandatory in 2xx response of SUBSCRIBE");
            }
            Expires requestExpires = (Expires)this.getOriginalRequest().getExpires();
            Expires responseExpires = (Expires)response.getExpires();
            if (requestExpires != null && responseExpires.getExpires() > requestExpires.getExpires()) {
                throw new SipException("Response Expires time exceeds request Expires time : See RFC 3265 3.1.1");
            }
        }
        if (sipResponse.getStatusCode() == 200 && sipResponse.getCSeq().getMethod().equals("INVITE") && sipResponse.getHeader("Contact") == null) {
            throw new SipException("Contact Header is mandatory for the OK to the INVITE");
        }
        if (!this.isMessagePartOfTransaction((SIPMessage)response)) {
            throw new SipException("Response does not belong to this transaction.");
        }
        try {
            String fromTag;
            block39: {
                if (this.pendingReliableResponse != null && this.getDialog() != null && this.getState() != TransactionState.TERMINATED && ((SIPResponse)response).getContentTypeHeader() != null && response.getStatusCode() / 100 == 2 && ((SIPResponse)response).getContentTypeHeader().getContentType().equalsIgnoreCase("application") && ((SIPResponse)response).getContentTypeHeader().getContentSubType().equalsIgnoreCase("sdp")) {
                    if (!interlockProvisionalResponses) {
                        throw new SipException("cannot send response -- unacked povisional");
                    }
                    try {
                        boolean acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS);
                        if (!acquired) {
                            throw new SipException("cannot send response -- unacked povisional");
                        }
                        break block39;
                    }
                    catch (InterruptedException ex) {
                        this.sipStack.getStackLogger().logError("Interrupted acuqiring PRACK sem");
                        throw new SipException("Cannot aquire PRACK sem");
                    }
                }
                if (this.pendingReliableResponse != null && sipResponse.isFinalResponse()) {
                    this.provisionalResponseTask.cancel();
                    this.provisionalResponseTask = null;
                }
            }
            if (dialog != null) {
                if (sipResponse.getStatusCode() / 100 == 2) {
                    if (SIPTransactionStack.isDialogCreated(sipResponse.getCSeq().getMethod())) {
                        if (dialog.getLocalTag() == null && sipResponse.getTo().getTag() == null) {
                            sipResponse.getTo().setTag(Utils.getInstance().generateTag());
                        } else if (dialog.getLocalTag() != null && sipResponse.getToTag() == null) {
                            if (this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                                this.sipStack.getStackLogger().logDebug("assigning toTag : serverTransaction = " + this + " dialog " + dialog + " tag = " + dialog.getLocalTag());
                            }
                            sipResponse.setToTag(dialog.getLocalTag());
                        } else if (dialog.getLocalTag() != null && sipResponse.getToTag() != null && !dialog.getLocalTag().equals(sipResponse.getToTag())) {
                            throw new SipException("Tag mismatch dialogTag is " + dialog.getLocalTag() + " responseTag is " + sipResponse.getToTag());
                        }
                    }
                }
                if (!sipResponse.getCallId().getCallId().equals(dialog.getCallId().getCallId())) {
                    throw new SipException("Dialog mismatch!");
                }
            }
            if ((fromTag = ((SIPRequest)this.getRequest()).getFrom().getTag()) != null && sipResponse.getFromTag() != null && !sipResponse.getFromTag().equals(fromTag)) {
                throw new SipException("From tag of request does not match response from tag");
            }
            if (fromTag != null) {
                sipResponse.getFrom().setTag(fromTag);
            } else if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("WARNING -- Null From tag in request!!");
            }
            if (dialog != null && response.getStatusCode() != 100) {
                dialog.setResponseTags(sipResponse);
                DialogState oldState = dialog.getState();
                dialog.setLastResponse(this, (SIPResponse)response);
                if (oldState == null && dialog.getState() == DialogState.TERMINATED) {
                    DialogTerminatedEvent event = new DialogTerminatedEvent((Object)dialog.getSipProvider(), (Dialog)dialog);
                    dialog.getSipProvider().handleEvent((EventObject)event, this);
                }
            } else if (dialog == null && this.getMethod().equals("INVITE") && this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask == null && response.getStatusCode() / 100 == 2) {
                String dialogId = ((SIPResponse)response).getDialogId(true);
                this.retransmissionAlertTimerTask = new RetransmissionAlertTimerTask(dialogId);
                this.sipStack.retransmissionAlertTransactions.put(dialogId, this);
                this.sipStack.getTimer().schedule((TimerTask)this.retransmissionAlertTimerTask, 0L, 500L);
            }
            this.sendMessage((SIPResponse)response);
            if (dialog != null) {
                dialog.startRetransmitTimer(this, (SIPResponse)response);
            }
        }
        catch (IOException ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(ex);
            }
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
            throw new SipException(ex.getMessage(), (Throwable)ex);
        }
        catch (ParseException ex1) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(ex1);
            }
            this.setState(TransactionState.TERMINATED);
            throw new SipException(ex1.getMessage(), (Throwable)ex1);
        }
    }

    private TransactionState getRealState() {
        return super.getState();
    }

    public TransactionState getState() {
        if (this.isInviteTransaction() && TransactionState.TRYING == super.getState()) {
            return TransactionState.PROCEEDING;
        }
        return super.getState();
    }

    public void setState(TransactionState newState) {
        if (newState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheServerConnections) {
            this.collectionTime = 64;
        }
        super.setState(newState);
    }

    protected void startTransactionTimer() {
        if (this.transactionTimerStarted.compareAndSet(false, true) && this.sipStack.getTimer() != null) {
            TransactionTimer myTimer = new TransactionTimer();
            this.sipStack.getTimer().schedule((TimerTask)myTimer, this.BASE_TIMER_INTERVAL, (long)this.BASE_TIMER_INTERVAL);
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPServerTransaction sst = (SIPServerTransaction)other;
        return this.getBranch().equalsIgnoreCase(sst.getBranch());
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(SIPDialog sipDialog, String dialogId) {
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("setDialog " + this + " dialog = " + sipDialog);
        }
        this.dialog = sipDialog;
        if (dialogId != null) {
            this.dialog.setAssigned();
        }
        if (this.retransmissionAlertEnabled && this.retransmissionAlertTimerTask != null) {
            this.retransmissionAlertTimerTask.cancel();
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        this.retransmissionAlertEnabled = false;
    }

    public void terminate() throws ObjectInUseException {
        this.setState(TransactionState.TERMINATED);
        if (this.retransmissionAlertTimerTask != null) {
            this.retransmissionAlertTimerTask.cancel();
            if (this.retransmissionAlertTimerTask.dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(this.retransmissionAlertTimerTask.dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
        if (!this.transactionTimerStarted.get()) {
            this.testAndSetTransactionTerminatedEvent();
            this.sipStack.removeTransaction(this);
        }
    }

    protected void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (this.pendingReliableResponse != null) {
            throw new SipException("Unacknowledged response");
        }
        this.pendingReliableResponse = (SIPResponse)relResponse;
        RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
        if (relResponse.getHeader("RSeq") == null) {
            rseq = new RSeq();
            relResponse.setHeader((Header)rseq);
        }
        try {
            boolean acquired;
            ++this.rseqNumber;
            rseq.setSeqNumber(this.rseqNumber);
            this.lastResponse = (SIPResponse)relResponse;
            if (this.getDialog() != null && interlockProvisionalResponses && !(acquired = this.provisionalResponseSem.tryAcquire(1L, TimeUnit.SECONDS))) {
                throw new SipException("Unacknowledged reliable response");
            }
            this.provisionalResponseTask = new ProvisionalResponseTask();
            this.sipStack.getTimer().schedule((TimerTask)this.provisionalResponseTask, 0L, 500L);
            this.sendMessage((SIPMessage)relResponse);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    public SIPResponse getReliableProvisionalResponse() {
        return this.pendingReliableResponse;
    }

    public boolean prackRecieved() {
        if (this.pendingReliableResponse == null) {
            return false;
        }
        if (this.provisionalResponseTask != null) {
            this.provisionalResponseTask.cancel();
            this.provisionalResponseTask = null;
        }
        this.pendingReliableResponse = null;
        if (interlockProvisionalResponses && this.dialog != null) {
            this.provisionalResponseSem.release();
        }
        return true;
    }

    public void enableRetransmissionAlerts() throws SipException {
        if (this.getDialog() != null) {
            throw new SipException("Dialog associated with tx");
        }
        if (!this.getMethod().equals("INVITE")) {
            throw new SipException("Request Method must be INVITE");
        }
        this.retransmissionAlertEnabled = true;
    }

    public boolean isRetransmissionAlertEnabled() {
        return this.retransmissionAlertEnabled;
    }

    public void disableRetransmissionAlerts() {
        if (this.retransmissionAlertTimerTask != null && this.retransmissionAlertEnabled) {
            this.retransmissionAlertTimerTask.cancel();
            this.retransmissionAlertEnabled = false;
            String dialogId = this.retransmissionAlertTimerTask.dialogId;
            if (dialogId != null) {
                this.sipStack.retransmissionAlertTransactions.remove(dialogId);
            }
            this.retransmissionAlertTimerTask = null;
        }
    }

    public void setAckSeen() {
        this.isAckSeen = true;
    }

    public boolean ackSeen() {
        return this.isAckSeen;
    }

    public void setMapped(boolean b) {
        this.isMapped = true;
    }

    public void setPendingSubscribe(SIPClientTransaction pendingSubscribeClientTx) {
        this.pendingSubscribeTransaction = pendingSubscribeClientTx;
    }

    public void releaseSem() {
        if (this.pendingSubscribeTransaction != null) {
            if (!this.sipStack.isDeliverUnsolicitedNotify()) {
                this.pendingSubscribeTransaction.releaseSem();
            }
        } else if (this.inviteTransaction != null && this.getMethod().equals("CANCEL")) {
            this.inviteTransaction.releaseSem();
        }
        super.releaseSem();
    }

    public void setInviteTransaction(SIPServerTransaction st) {
        this.inviteTransaction = st;
    }

    public SIPServerTransaction getCanceledInviteTransaction() {
        return this.inviteTransaction;
    }

    public void scheduleAckRemoval() throws IllegalStateException {
        if (this.getMethod() == null || !this.getMethod().equals("ACK")) {
            throw new IllegalStateException("Method is null[" + (this.getMethod() == null) + "] or method is not ACK[" + this.getMethod() + "]");
        }
        this.startTransactionTimer();
    }

    class TransactionTimer
    extends SIPStackTimerTask {
        public TransactionTimer() {
            if (SIPServerTransaction.this.sipStack.isLoggingEnabled(32)) {
                SIPServerTransaction.this.sipStack.getStackLogger().logDebug("TransactionTimer() : " + SIPServerTransaction.this.getTransactionId());
            }
        }

        protected void runTask() {
            if (SIPServerTransaction.this.isTerminated()) {
                block5: {
                    try {
                        this.cancel();
                        if (SIPServerTransaction.this.listenerExecutionMaxTimer != null) {
                            SIPServerTransaction.this.listenerExecutionMaxTimer.cancel();
                        }
                    }
                    catch (IllegalStateException ex) {
                        if (SIPServerTransaction.this.sipStack.isAlive()) break block5;
                        return;
                    }
                }
                SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer();
                SIPServerTransaction.this.sipStack.getTimer().schedule((TimerTask)myTimer, 8000L);
            } else {
                SIPServerTransaction.this.fireTimer();
            }
        }
    }

    class SendTrying
    extends SIPStackTimerTask {
        protected SendTrying() {
            if (SIPServerTransaction.this.sipStack.isLoggingEnabled(32)) {
                SIPServerTransaction.this.sipStack.getStackLogger().logDebug("scheduled timer for " + SIPServerTransaction.this);
            }
        }

        protected void runTask() {
            block5: {
                SIPServerTransaction serverTransaction = SIPServerTransaction.this;
                TransactionState realState = serverTransaction.getRealState();
                if (realState == null || TransactionState.TRYING == realState) {
                    if (SIPServerTransaction.this.sipStack.isLoggingEnabled(32)) {
                        SIPServerTransaction.this.sipStack.getStackLogger().logDebug(" sending Trying current state = " + serverTransaction.getRealState());
                    }
                    try {
                        serverTransaction.sendMessage(serverTransaction.getOriginalRequest().createResponse(100, "Trying"));
                        if (SIPServerTransaction.this.sipStack.isLoggingEnabled(32)) {
                            SIPServerTransaction.this.sipStack.getStackLogger().logDebug(" trying sent " + serverTransaction.getRealState());
                        }
                    }
                    catch (IOException ex) {
                        if (!SIPServerTransaction.this.sipStack.isLoggingEnabled()) break block5;
                        SIPServerTransaction.this.sipStack.getStackLogger().logError("IO error sending  TRYING");
                    }
                }
            }
        }
    }

    class ListenerExecutionMaxTimer
    extends SIPStackTimerTask {
        SIPServerTransaction serverTransaction;

        ListenerExecutionMaxTimer() {
            this.serverTransaction = SIPServerTransaction.this;
        }

        protected void runTask() {
            try {
                SIPServerTransaction.this.listenerExecutionMaxTimer = null;
                if (SIPServerTransaction.this.sipStack.isLoggingEnabled(32)) {
                    SIPServerTransaction.this.sipStack.getStackLogger().logDebug("Fired ListenerExecutionMaxTimer for stx " + this.serverTransaction.getTransactionId() + " state " + this.serverTransaction.getState());
                }
                if (this.serverTransaction.getState() == null || this.serverTransaction.getState().equals((Object)TransactionState.CALLING) || this.serverTransaction.getState().equals((Object)TransactionState.TRYING) || this.serverTransaction.getState().equals((Object)TransactionState.TERMINATED)) {
                    if (SIPServerTransaction.this.sipStack.isLoggingEnabled(32)) {
                        SIPServerTransaction.this.sipStack.getStackLogger().logDebug("ListenerExecutionMaxTimer : terminating and removing stx " + this.serverTransaction.getTransactionId());
                    }
                    this.serverTransaction.terminate();
                    SIPTransactionStack sipStack = this.serverTransaction.getSIPStack();
                    sipStack.removeTransaction(this.serverTransaction);
                }
            }
            catch (Exception ex) {
                SIPServerTransaction.this.sipStack.getStackLogger().logError("unexpected exception", ex);
            }
        }
    }

    class ProvisionalResponseTask
    extends SIPStackTimerTask {
        int ticks;
        int ticksLeft;

        public ProvisionalResponseTask() {
            this.ticksLeft = this.ticks = 1;
        }

        protected void runTask() {
            SIPServerTransaction serverTransaction = SIPServerTransaction.this;
            if (serverTransaction.isTerminated()) {
                this.cancel();
            } else {
                --this.ticksLeft;
                if (this.ticksLeft == -1) {
                    serverTransaction.fireReliableResponseRetransmissionTimer();
                    this.ticks = this.ticksLeft = 2 * this.ticks;
                    if (this.ticksLeft >= 64) {
                        this.cancel();
                        SIPServerTransaction.this.setState(SIPTransaction.TERMINATED_STATE);
                        SIPServerTransaction.this.fireTimeoutTimer();
                    }
                }
            }
        }
    }

    class RetransmissionAlertTimerTask
    extends SIPStackTimerTask {
        String dialogId;
        int ticks;
        int ticksLeft;

        public RetransmissionAlertTimerTask(String dialogId) {
            this.ticksLeft = this.ticks = 1;
        }

        protected void runTask() {
            SIPServerTransaction serverTransaction = SIPServerTransaction.this;
            --this.ticksLeft;
            if (this.ticksLeft == -1) {
                serverTransaction.fireRetransmissionTimer();
                this.ticksLeft = 2 * this.ticks;
            }
        }
    }
}

