/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PipelinedMsgParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.HandshakeCompletedListenerImpl;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.sip.address.Hop;

public final class TLSMessageChannel
extends MessageChannel
implements SIPMessageListener,
Runnable,
RawMessageChannel {
    private Socket mySock;
    private PipelinedMsgParser myParser;
    private InputStream myClientInputStream;
    private String key;
    protected boolean isCached;
    protected boolean isRunning = true;
    private Thread mythread;
    private String myAddress;
    private int myPort;
    private InetAddress peerAddress;
    private int peerPort;
    protected int peerPortAdvertisedInHeaders = -1;
    private String peerProtocol;
    private TLSMessageProcessor tlsMessageProcessor;
    private SIPTransactionStack sipStack;
    private HandshakeCompletedListener handshakeCompletedListener;

    protected TLSMessageChannel(Socket sock, SIPTransactionStack sipStack, TLSMessageProcessor msgProcessor) throws IOException {
        if (sipStack.isLoggingEnabled(32)) {
            sipStack.getStackLogger().logDebug("creating new TLSMessageChannel (incoming)");
            sipStack.getStackLogger().logStackTrace();
        }
        this.mySock = (SSLSocket)sock;
        if (sock instanceof SSLSocket) {
            try {
                SSLSocket sslSock = (SSLSocket)sock;
                sslSock.setNeedClientAuth(true);
                this.handshakeCompletedListener = new HandshakeCompletedListenerImpl(this);
                sslSock.addHandshakeCompletedListener(this.handshakeCompletedListener);
                sslSock.startHandshake();
            }
            catch (SSLHandshakeException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        this.peerAddress = this.mySock.getInetAddress();
        this.myAddress = msgProcessor.getIpAddress().getHostAddress();
        this.myClientInputStream = this.mySock.getInputStream();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.setName("TLSMessageChannelThread");
        this.sipStack = sipStack;
        this.tlsMessageProcessor = msgProcessor;
        this.myPort = this.tlsMessageProcessor.getPort();
        this.peerPort = this.mySock.getPort();
        this.messageProcessor = msgProcessor;
        this.mythread.start();
    }

    protected TLSMessageChannel(InetAddress inetAddr, int port, SIPTransactionStack sipStack, TLSMessageProcessor messageProcessor) throws IOException {
        if (sipStack.isLoggingEnabled(32)) {
            sipStack.getStackLogger().logDebug("creating new TLSMessageChannel (outgoing)");
            sipStack.getStackLogger().logStackTrace();
        }
        this.peerAddress = inetAddr;
        this.peerPort = port;
        this.myPort = messageProcessor.getPort();
        this.peerProtocol = "TLS";
        this.sipStack = sipStack;
        this.tlsMessageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        this.messageProcessor = messageProcessor;
    }

    public boolean isReliable() {
        return true;
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean removeSocket) {
        block11: {
            this.isRunning = false;
            if (this.mySock != null) {
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Closing socket " + this.key);
                }
                try {
                    this.mySock.close();
                }
                catch (IOException ex) {
                    if (!this.sipStack.isLoggingEnabled(32)) break block11;
                    this.sipStack.getStackLogger().logDebug("Error closing socket " + ex);
                }
            }
        }
        if (this.myParser != null) {
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Closing my parser " + this.myParser);
            }
            this.myParser.close();
        }
        if (removeSocket) {
            String ioHandlerKey = this.key.substring(4);
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Closing TLS socket " + ioHandlerKey);
            }
            this.sipStack.ioHandler.removeSocket(ioHandlerKey);
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Closing message Channel " + this);
            }
        } else if (this.sipStack.isLoggingEnabled(32)) {
            String ioHandlerKey = this.key.substring(4);
            this.sipStack.getStackLogger().logDebug("not removing socket key from the cached map since it has already been updated by the iohandler.sendBytes " + ioHandlerKey);
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "tls";
    }

    public String getPeerAddress() {
        if (this.peerAddress != null) {
            return this.peerAddress.getHostAddress();
        }
        return this.getHost();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    private void sendMessage(byte[] msg, boolean retry) throws IOException {
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.getMessageProcessor().getIpAddress(), this.peerAddress, this.peerPort, this.peerProtocol, msg, retry, this);
        }
        catch (IOException any) {
            problem = any;
            this.sipStack.getStackLogger().logWarning("Failed to connect " + this.peerAddress + ":" + this.peerPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
        }
        if (sock == null) {
            if (this.peerPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                this.sipStack.getStackLogger().logWarning("Couldn't connect to peerAddress = " + this.peerAddress + " peerPort = " + this.peerPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), this.peerAddress, this.peerPortAdvertisedInHeaders, this.peerProtocol, msg, retry, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
                this.sipStack.getStackLogger().logWarning("retry suceeded to peerAddress = " + this.peerAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (this.sipStack.isLoggingEnabled(8)) {
                    this.sipStack.getStackLogger().logWarning("Old socket different than new socket on channel " + this.key);
                    this.sipStack.getStackLogger().logStackTrace();
                    this.sipStack.getStackLogger().logWarning("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    this.sipStack.getStackLogger().logWarning("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    this.sipStack.getStackLogger().logWarning("New socket local ip address " + sock.getLocalSocketAddress());
                    this.sipStack.getStackLogger().logWarning("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.close(false);
            }
            if (problem == null) {
                if (this.mySock != null && this.sipStack.isLoggingEnabled(8)) {
                    this.sipStack.getStackLogger().logWarning("There was no exception for the retry mechanism so creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
                this.myClientInputStream = this.mySock.getInputStream();
                Thread thread = new Thread(this);
                thread.setDaemon(true);
                thread.setName("TLSMessageChannelThread");
                thread.start();
            } else {
                if (this.sipStack.isLoggingEnabled(8)) {
                    this.sipStack.getStackLogger().logWarning("There was an exception for the retry mechanism so not creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
            }
        }
    }

    public void sendMessage(final SIPMessage sipMessage) throws IOException {
        SIPResponse sipResponse;
        Via via;
        for (MessageProcessor messageProcessor : this.getSIPStack().getMessageProcessors()) {
            if (this.getSIPStack().getStackLogger().isLoggingEnabled(32)) {
                this.getSIPStack().getStackLogger().logDebug("messageProcessor=" + messageProcessor + ", addr=" + messageProcessor.getIpAddress().getHostAddress() + ", peeraddr= " + this.getPeerAddress() + ", mpTransport=" + messageProcessor.getTransport() + ", mpPort=" + messageProcessor.getPort() + ", peerport=" + this.getPeerPort() + ", peertrnsport=" + this.getPeerProtocol() + " EL\n");
            }
            if (!messageProcessor.getIpAddress().getHostAddress().equals(this.getPeerAddress()) || messageProcessor.getPort() != this.getPeerPort() || !messageProcessor.getTransport().equalsIgnoreCase(this.getPeerProtocol())) continue;
            Runnable processMessageTask = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            TLSMessageChannel.this.processMessage((SIPMessage)sipMessage.clone());
                        }
                        catch (Exception ex) {
                            if (!TLSMessageChannel.this.getSIPStack().getStackLogger().isLoggingEnabled(4)) break block2;
                            TLSMessageChannel.this.getSIPStack().getStackLogger().logError("Error self routing message cause by: ", ex);
                        }
                    }
                }
            };
            this.getSIPStack().getSelfRoutingThreadpoolExecutor().execute(processMessageTask);
            if (this.getSIPStack().getStackLogger().isLoggingEnabled(32)) {
                this.getSIPStack().getStackLogger().logDebug("Self routing message");
            }
            return;
        }
        byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
        long time = System.currentTimeMillis();
        if (this.peerPortAdvertisedInHeaders <= 0 && sipMessage instanceof SIPResponse && (via = (sipResponse = (SIPResponse)sipMessage).getTopmostVia()).getRPort() > 0) {
            this.peerPortAdvertisedInHeaders = via.getPort() <= 0 ? 5060 : via.getPort();
            if (this.sipStack.getStackLogger().isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("1.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for via port = " + via.getPort() + " via rport = " + via.getRPort() + " and peer port = " + this.peerPort + " for this channel " + this + " key " + this.key);
            }
        }
        this.sendMessage(msg, sipMessage instanceof SIPRequest);
        if (this.sipStack.getStackLogger().isLoggingEnabled(16)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    public void sendMessage(byte[] message, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        if (message == null || receiverAddress == null) {
            throw new IllegalArgumentException("Null argument");
        }
        if (this.peerPortAdvertisedInHeaders <= 0) {
            this.sipStack.getStackLogger().logWarning("receiver port = " + receiverPort + " for this channel " + this + " key " + this.key);
            this.peerPortAdvertisedInHeaders = receiverPort <= 0 ? 5060 : receiverPort;
            this.sipStack.getStackLogger().logWarning("2.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
        }
        Socket sock = null;
        IOException problem = null;
        try {
            sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, receiverPort, "TLS", message, retry, this);
        }
        catch (IOException any) {
            problem = any;
            this.sipStack.getStackLogger().logWarning("Failed to connect " + this.peerAddress + ":" + receiverPort + " but trying the advertised port=" + this.peerPortAdvertisedInHeaders + " if it's different than the port we just failed on");
        }
        if (sock == null) {
            if (receiverPort != this.peerPortAdvertisedInHeaders && this.peerPortAdvertisedInHeaders > 0) {
                this.sipStack.getStackLogger().logWarning("Couldn't connect to receiverAddress = " + receiverAddress + " receiverPort = " + receiverPort + " key = " + this.key + " retrying on peerPortAdvertisedInHeaders " + this.peerPortAdvertisedInHeaders);
                sock = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), receiverAddress, this.peerPortAdvertisedInHeaders, "TLS", message, retry, this);
                this.peerPort = this.peerPortAdvertisedInHeaders;
                this.key = MessageChannel.getKey(this.peerAddress, this.peerPortAdvertisedInHeaders, "TLS");
                this.sipStack.getStackLogger().logWarning("retry suceeded to receiverAddress = " + receiverAddress + " peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " key = " + this.key);
            } else {
                throw problem;
            }
        }
        if (sock != this.mySock && sock != null) {
            if (this.mySock != null) {
                if (this.sipStack.isLoggingEnabled(8)) {
                    this.sipStack.getStackLogger().logWarning("Old socket different than new socket on channel " + this.key);
                    this.sipStack.getStackLogger().logStackTrace();
                    this.sipStack.getStackLogger().logWarning("Old socket local ip address " + this.mySock.getLocalSocketAddress());
                    this.sipStack.getStackLogger().logWarning("Old socket remote ip address " + this.mySock.getRemoteSocketAddress());
                    this.sipStack.getStackLogger().logWarning("New socket local ip address " + sock.getLocalSocketAddress());
                    this.sipStack.getStackLogger().logWarning("New socket remote ip address " + sock.getRemoteSocketAddress());
                }
                this.close(false);
            }
            if (problem == null) {
                if (this.mySock != null && this.sipStack.isLoggingEnabled(8)) {
                    this.sipStack.getStackLogger().logWarning("There was no exception for the retry mechanism so creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
                this.myClientInputStream = this.mySock.getInputStream();
                Thread mythread = new Thread(this);
                mythread.setDaemon(true);
                mythread.setName("TLSMessageChannelThread");
                mythread.start();
            } else {
                if (this.sipStack.isLoggingEnabled(8)) {
                    this.sipStack.getStackLogger().logWarning("There was an exception for the retry mechanism so not creating a new thread based on the new socket for incoming " + this.key);
                }
                this.mySock = sock;
            }
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            String msgString;
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Encountered bad message \n" + message);
            }
            if (!(msgString = sipMessage.toString()).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Sending automatic 400 Bad Request:");
                        this.sipStack.getStackLogger().logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.getPeerInetAddress(), this.getPeerPort(), false);
                    }
                    catch (IOException e) {
                        this.sipStack.getStackLogger().logException(e);
                    }
                } else if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(SIPMessage sipMessage) throws Exception {
        try {
            if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = sipMessage.encode();
                if (!this.sipStack.isLoggingEnabled()) return;
                this.sipStack.getStackLogger().logError("bad message " + badmsg);
                this.sipStack.getStackLogger().logError(">>> Dropped Bad Msg");
                return;
            }
            ViaList viaList = sipMessage.getViaHeaders();
            if (sipMessage instanceof SIPRequest) {
                Via v = (Via)viaList.getFirst();
                Hop hop = this.sipStack.addressResolver.resolveAddress(v.getHop());
                this.peerProtocol = v.getTransport();
                if (this.peerPortAdvertisedInHeaders <= 0) {
                    int hopPort = v.getPort();
                    this.sipStack.getStackLogger().logWarning("hop port = " + hopPort + " for request " + sipMessage + " for this channel " + this + " key " + this.key);
                    this.peerPortAdvertisedInHeaders = hopPort <= 0 ? 5060 : hopPort;
                    this.sipStack.getStackLogger().logWarning("3.Storing peerPortAdvertisedInHeaders = " + this.peerPortAdvertisedInHeaders + " for this channel " + this + " key " + this.key);
                }
                try {
                    this.peerAddress = this.mySock.getInetAddress();
                    if (v.hasParameter("rport") || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                        v.setParameter("received", this.peerAddress.getHostAddress());
                    }
                    v.setParameter("rport", Integer.toString(this.peerPort));
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (!this.isCached) {
                    ((TLSMessageProcessor)this.messageProcessor).cacheMessageChannel(this);
                    this.isCached = true;
                    String key = IOHandler.makeKey(this.mySock.getInetAddress(), this.peerPort);
                    this.sipStack.ioHandler.putSocket(key, this.mySock);
                }
            }
            long receptionTime = System.currentTimeMillis();
            if (sipMessage instanceof SIPRequest) {
                SIPRequest sipRequest = (SIPRequest)sipMessage;
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("----Processing Message---");
                }
                if (this.sipStack.getStackLogger().isLoggingEnabled(16)) {
                    this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.messageProcessor.getIpAddress().getHostAddress() + ":" + this.messageProcessor.getPort(), false, receptionTime);
                }
                if (this.sipStack.getMaxMessageSize() > 0 && sipRequest.getSize() + (sipRequest.getContentLength() == null ? 0 : sipRequest.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                    SIPResponse sipResponse = sipRequest.createResponse(513);
                    byte[] resp = sipResponse.encodeAsBytes(this.getTransport());
                    this.sendMessage(resp, false);
                    throw new Exception("Message size exceeded");
                }
                ServerRequestInterface sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest != null) {
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        Object var9_24 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) return;
                        SIPServerTransaction sipServerTx = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx.passToListener()) return;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        return;
                    }
                    catch (Throwable throwable) {
                        Object var9_25 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) throw throwable;
                        SIPServerTransaction sipServerTx = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx.passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        throw throwable;
                    }
                }
                SIPResponse response = sipRequest.createResponse(503);
                RetryAfter retryAfter = new RetryAfter();
                try {
                    retryAfter.setRetryAfter((int)(10.0 * Math.random()));
                    response.setHeader(retryAfter);
                    this.sendMessage(response);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!this.sipStack.isLoggingEnabled()) return;
                this.sipStack.getStackLogger().logWarning("Dropping message -- could not acquire semaphore");
                return;
            }
            SIPResponse sipResponse = (SIPResponse)sipMessage;
            try {
                sipResponse.checkHeaders();
            }
            catch (ParseException ex) {
                if (!this.sipStack.isLoggingEnabled()) return;
                this.sipStack.getStackLogger().logError("Dropping Badly formatted response message >>> " + sipResponse);
                return;
            }
            if (this.sipStack.getMaxMessageSize() > 0 && sipResponse.getSize() + (sipResponse.getContentLength() == null ? 0 : sipResponse.getContentLength().getContentLength()) > this.sipStack.getMaxMessageSize()) {
                if (!this.sipStack.isLoggingEnabled(32)) return;
                this.sipStack.getStackLogger().logDebug("Message size exceeded");
                return;
            }
            ServerResponseInterface sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
            if (sipServerResponse != null) {
                block26: {
                    try {
                        if (!(sipServerResponse instanceof SIPClientTransaction) || ((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) break block26;
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        Object var12_31 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_33 = null;
                        if (!(sipServerResponse instanceof SIPTransaction)) throw throwable;
                        if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                        throw throwable;
                    }
                    if (!(sipServerResponse instanceof SIPTransaction)) return;
                    if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
                    ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    return;
                }
                sipServerResponse.processResponse(sipResponse, this);
                Object var12_32 = null;
                if (!(sipServerResponse instanceof SIPTransaction)) return;
                if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
                ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                return;
            }
            this.sipStack.getStackLogger().logWarning("Could not get semaphore... dropping response");
            return;
        }
        catch (Throwable throwable) {
            Object var14_9 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Pipeline hispipe = null;
        hispipe = new Pipeline(this.myClientInputStream, this.sipStack.readTimeout, this.sipStack.getTimer());
        this.myParser = new PipelinedMsgParser(this.sipStack, this, hispipe, this.sipStack.getMaxMessageSize());
        this.myParser.processInput();
        int bufferSize = 4096;
        ++this.tlsMessageProcessor.useCount;
        this.isRunning = true;
        try {
            while (true) {
                int nbytes;
                byte[] msg;
                try {
                    msg = new byte[bufferSize];
                    nbytes = this.myClientInputStream.read(msg, 0, bufferSize);
                    if (nbytes == -1) {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TLSMessageProcessor tLSMessageProcessor = this.tlsMessageProcessor;
                                synchronized (tLSMessageProcessor) {
                                    --this.tlsMessageProcessor.nConnections;
                                    this.tlsMessageProcessor.notify();
                                }
                            }
                            hispipe.close();
                            this.close();
                        }
                        catch (IOException ioex) {
                        }
                        Object var9_13 = null;
                        this.isRunning = false;
                        this.tlsMessageProcessor.remove(this);
                        --this.tlsMessageProcessor.useCount;
                        if (this.myParser == null) return;
                        this.myParser.close();
                        return;
                    }
                }
                catch (IOException ex) {
                    try {
                        hispipe.write("\r\n\r\n".getBytes("UTF-8"));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug("IOException  closing sock " + ex);
                        }
                        try {
                            if (this.sipStack.maxConnections != -1) {
                                TLSMessageProcessor e = this.tlsMessageProcessor;
                                synchronized (e) {
                                    --this.tlsMessageProcessor.nConnections;
                                    this.tlsMessageProcessor.notify();
                                }
                            }
                            this.close();
                            hispipe.close();
                        }
                        catch (IOException ioex) {}
                    }
                    catch (Exception ex1) {
                    }
                    Object var9_14 = null;
                    this.isRunning = false;
                    this.tlsMessageProcessor.remove(this);
                    --this.tlsMessageProcessor.useCount;
                    if (this.myParser == null) return;
                    this.myParser.close();
                    return;
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                    continue;
                }
                {
                    hispipe.write(msg, 0, nbytes);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            this.isRunning = false;
            this.tlsMessageProcessor.remove(this);
            --this.tlsMessageProcessor.useCount;
            if (this.myParser == null) throw throwable;
            this.myParser.close();
            throw throwable;
        }
    }

    protected void uncache() {
        if (this.isCached && !this.isRunning) {
            this.tlsMessageProcessor.remove(this);
        }
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        TLSMessageChannel that = (TLSMessageChannel)other;
        return this.mySock == that.mySock;
    }

    public String getKey() {
        if (this.key != null) {
            return this.key;
        }
        this.key = MessageChannel.getKey(this.peerAddress, this.peerPort, "TLS");
        return this.key;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerAddress;
    }

    public boolean isSecure() {
        return true;
    }

    public void setHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListenerImpl) {
        this.handshakeCompletedListener = handshakeCompletedListenerImpl;
    }

    public HandshakeCompletedListenerImpl getHandshakeCompletedListener() {
        return (HandshakeCompletedListenerImpl)this.handshakeCompletedListener;
    }
}

