/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.Map;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeNode;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.optimistic.WorkspaceNodeImpl;

public class NodeFactory {
    private static NodeFactory _singleton;
    public static final byte NODE_TYPE_TREENODE = 1;
    public static final byte NODE_TYPE_WORKSPACE_NODE = 2;
    public static final byte NODE_TYPE_OPTIMISTIC_NODE = 3;

    private NodeFactory() {
    }

    public static NodeFactory getInstance() {
        if (_singleton == null) {
            _singleton = new NodeFactory();
        }
        return _singleton;
    }

    public DataNode createRootDataNode(byte nodeType, TreeCache cache) {
        return this.createDataNode(nodeType, null, Fqn.ROOT, null, null, cache);
    }

    public DataNode createDataNode(byte nodeType, Object childName, Fqn fqn, DataNode parent, Map data, TreeCache cache, DataVersion version) {
        return this.createDataNode(nodeType, childName, fqn, parent, data, false, cache, version);
    }

    public DataNode createDataNode(byte nodeType, Object childName, Fqn fqn, DataNode parent, Map data, TreeCache cache) {
        return this.createDataNode(nodeType, childName, fqn, parent, data, false, cache, null);
    }

    public DataNode createDataNode(byte nodeType, Object childName, Fqn fqn, DataNode parent, Map data, boolean mapSafe, TreeCache cache) {
        return this.createDataNode(nodeType, childName, fqn, parent, data, mapSafe, cache, null);
    }

    public DataNode createDataNode(byte nodeType, Object childName, Fqn fqn, DataNode parent, Map data, boolean mapSafe, TreeCache cache, DataVersion version) {
        Node n = null;
        switch (nodeType) {
            case 1: {
                n = new Node(childName, fqn, (Node)parent, data, mapSafe, cache);
                break;
            }
            case 3: {
                n = new OptimisticTreeNode(childName, fqn, (Node)parent, data, mapSafe, cache, version);
            }
        }
        return n;
    }

    public TreeNode createNodeOfType(TreeNode template, Object childName, Fqn fqn, TreeNode parent, Map data, TreeCache cache) {
        return this.createNodeOfType(template, childName, fqn, parent, data, cache, null);
    }

    public TreeNode createNodeOfType(TreeNode template, Object childName, Fqn fqn, TreeNode parent, Map data, TreeCache cache, DataVersion version) {
        if (template instanceof WorkspaceNode) {
            DataNode dataNodeParent = ((WorkspaceNode)parent).getNode();
            TransactionWorkspace workspace = ((WorkspaceNode)template).getTransactionWorkspace();
            return this.createWorkspaceNode(dataNodeParent, workspace);
        }
        if (parent instanceof DataNode) {
            if (template instanceof OptimisticTreeNode) {
                return this.createDataNode((byte)3, childName, fqn, (DataNode)parent, data, cache, version);
            }
            if (template instanceof Node) {
                return this.createDataNode((byte)1, childName, fqn, (DataNode)parent, data, cache);
            }
        }
        return null;
    }

    public WorkspaceNode createWorkspaceNode(TreeNode dataNode, TransactionWorkspace workspace) {
        return new WorkspaceNodeImpl(dataNode, workspace);
    }
}

