package org.mobicents.mojo.ra;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.jar.Manifest.Attribute;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

/**
 * Package deployable unit.
 * 
 * @author La Porta
 * @goal mobicents-ra-plugin
 * @phase package
 */
public class RaPluginMojo extends AbstractMojo
{

    private static final String[] DEFAULT_EXCLUDES = new String[] { "**/package.html" };

    private static final String[] DEFAULT_INCLUDES = new String[] { "**/*.*" };

    private static final String DEPLOYABLE_UNIT_XML = "deployable-unit.xml";

    private static final String RA_JAR_XML = "resource-adaptor-jar.xml";

    private static final String RATYPE_JAR_XML = "resource-adaptor-type-jar.xml";

    private static final String EVENT_JAR_XML = "event-jar.xml";

    /**
     * Base directory.
     * 
     * @parameter expression="${basedir}"
     * @required
     * @readonly
     */
    private File basedir;

    /**
     * Directory containing the generated JAR.
     * 
     * @parameter expression="${project.build.directory}"
     * @required
     * @readonly
     */
    private File targetDirectory;

    /**
     * Name of the generated JAR.
     * 
     * @parameter expression="${project.build.finalName}"
     * @required
     */
    private String finalName;

    /**
     * 
     * 
     * @parameter default-value=""
     */
    private String classpathPrefix = "library";


    /**
     * The Jar archiver.
     * 
     * @parameter expression="${component.org.codehaus.plexus.archiver.Archiver#jar}"
     * @required
     */
    private JarArchiver jarArchiver;

    /**
     * The Jar archiver.
     * 
     * @parameter expression="${component.org.codehaus.plexus.archiver.Archiver#jar}"
     * @required
     */
    private JarArchiver duArchiver;

    /**
     * The maven project.
     * 
     * @parameter expression="${project}"
     * @required
     * @readonly
     */
    private MavenProject project;

    /**
     * @component
     * @todo Write Javadoc for this
     */
    private MavenProjectHelper projectHelper;

    /**
     * Directory that contains the compiled classes to include in the jar.
     * 
     * @parameter expression="${project.build.outputDirectory}"
     * @required
     */
    private File contentDirectory;
    

    /**
     * Used to look up Artifacts in the remote repository.
     * 
     * @parameter expression="${component.org.apache.maven.artifact.factory.ArtifactFactory}"
     * @required
     * @readonly
     */
    protected org.apache.maven.artifact.factory.ArtifactFactory factory;

    /**
     * Used to look up Artifacts in the remote repository.
     * 
     * @parameter expression="${component.org.apache.maven.artifact.resolver.ArtifactResolver}"
     * @required
     * @readonly
     */
    protected org.apache.maven.artifact.resolver.ArtifactResolver resolver;

    /**
     * Location of the local repository.
     * 
     * @parameter expression="${localRepository}"
     * @readonly
     * @required
     */
    protected org.apache.maven.artifact.repository.ArtifactRepository local;
    
    
    /**
     * @parameter expression="${component.org.apache.maven.artifact.deployer.ArtifactDeployer}"
     * @required
     * @readonly
     */
    private ArtifactDeployer deployer;


    /**
     * Default artifact handler.
     * 
     * @parameter expression="${component.org.apache.maven.artifact.handler.ArtifactHandler}"
     * @readonly
     * @required
     */
    org.apache.maven.artifact.handler.ArtifactHandler artifactHandler;

    
    /**
     * The location of the manifest file to be used within the deployable unit.
     * 
     * @parameter expression="${basedir}/src/main/resources/META-INF/MANIFEST.MF"
     */
    private File manifestFile;

    /**
     * Generates the JAR.
     * 
     * @todo Add license files in META-INF directory.
     */
    public File createArchive() throws MojoExecutionException
    {
        File jarFile = new File( targetDirectory, finalName + ".jar" );

        MavenArchiver archiver = new MavenArchiver();

        archiver.setArchiver( jarArchiver );

        archiver.setOutputFile( jarFile );

        getLog().info( "PROCESSING artifactID:" + project.getArtifactId());
        
        try
        {
            FileUtils.mkdir( contentDirectory.getAbsolutePath() );
            FileUtils.mkdir( contentDirectory + "/META-INF" );
            
            if ( project.getArtifactId().endsWith( "ratype" ) )
            {
                FileUtils.copyFileToDirectory( basedir + "/xml/" + RATYPE_JAR_XML, contentDirectory + "/META-INF" );
                archiver.getArchiver().addDirectory(new File( contentDirectory.getAbsolutePath() + "/" ), DEFAULT_INCLUDES,
                                                     FileUtils.getDefaultExcludes() );
                addDirectory( archiver, new File(contentDirectory + "/META-INF" ));
                
            }
            
            if ( project.getArtifactId().endsWith( "ra" ) )
            {
                FileUtils.copyFileToDirectory( basedir + "/xml/" + RA_JAR_XML, contentDirectory + "/META-INF" );
                archiver.getArchiver().addDirectory(new File( contentDirectory.getAbsolutePath() + "/" ), DEFAULT_INCLUDES,
                                                    FileUtils.getDefaultExcludes() );
                addDirectory(  archiver, new File(contentDirectory + "/META-INF") );

            }
            
            if ( project.getArtifactId().endsWith( "event" ) )
            {
                FileUtils.copyFileToDirectory( basedir + "/xml/" + EVENT_JAR_XML, contentDirectory + "/META-INF" );
                addDirectory( archiver, new File( contentDirectory + "/META-INF" ) );
            }

            archiver.createArchive( project, generateManifest(  archiver.getArchiver() ) );

//            archiver.createArchive( project, new MavenArchiveConfiguration() );

            //------------------------------------------------
            // DU for RATYPE
            //------------------------------------------------
            if ( project.getArtifactId().endsWith( "ratype" ) )
            {

                String duJarName = project.getArtifactId() + "-DU-" + project.getVersion() ;
                
                File duFile = new File( targetDirectory, duJarName + ".jar" );
                MavenArchiver archiverDu = new MavenArchiver();
                archiverDu.setArchiver( duArchiver );
                archiverDu.setOutputFile( duFile );
                
                // add ratype jar
                archiverDu.getArchiver().addFile( new File( targetDirectory, finalName + ".jar" ), finalName + ".jar" );
                
                // add event jar
                String eventsJarPath = basedir + "/events/target/";
                String eventsJarName = project.getParent().getArtifactId() + "-event" + "-" + project.getVersion() + ".jar";
                archiverDu.getArchiver().addFile( new File( eventsJarPath, eventsJarName ), eventsJarName );
                
                // add deployable unit xml
                FileUtils.copyFileToDirectory( basedir + "/xml/" + DEPLOYABLE_UNIT_XML, targetDirectory + "/META-INF" ); 
                addDirectory( archiverDu, new File(targetDirectory + "/META-INF") );
              
                // add dependencies
                Set artifacts = project.getDependencyArtifacts();
                for ( Iterator iter = artifacts.iterator(); iter.hasNext(); )
                {
                    Artifact artifact = (Artifact) iter.next();
                    ScopeArtifactFilter filter = new ScopeArtifactFilter( Artifact.SCOPE_RUNTIME );
                    if ( !artifact.isOptional() && filter.include( artifact ) )
                    {
                        if(!classpathPrefix.equals("")){
                            FileUtils.copyFileToDirectory( artifact.getFile(), new File( contentDirectory.getAbsolutePath()
                                    + "/" + classpathPrefix ) );
                        addDirectory( archiverDu, new File(contentDirectory.getAbsolutePath()+ "/" + classpathPrefix) );
                        }else{
                            FileUtils.copyFileToDirectory( artifact.getFile(), new File( contentDirectory.getAbsolutePath()) );
                            addDirectory( archiverDu, new File(contentDirectory.getAbsolutePath()) );
                        }
                        getLog().info("add dependencies " + artifact + " to "+project.getArtifactId());
                    }
                }

                ;
                
                // create archive
                archiverDu.createArchive( project, generateManifest(  archiverDu.getArchiver() ) );
//                archiverDu.createArchive( project, new MavenArchiveConfiguration() );
                
                getLog().info( "ratype deployable unit successfully created" );

                Artifact artifact =
                    new DefaultArtifact( project.getGroupId(), project.getArtifactId() + "-DU",
                                         VersionRange.createFromVersion( project.getVersion() ),
                                         Artifact.SCOPE_RUNTIME, "jar", "", artifactHandler );
                artifact.setFile( duFile );

                deployer.deploy( duFile, artifact, local, local );
                getLog().info( "ratype deployable unit successfully deployed on local repository" );

            }

            //------------------------------------------------
            // DU for RA
            //------------------------------------------------
            if ( project.getArtifactId().endsWith( "ra" ) )
            {
                String duJarName = project.getArtifactId() + "-DU-" + project.getVersion() ;
                
                File duFile = new File( targetDirectory, duJarName + ".jar" );
                MavenArchiver archiverDu = new MavenArchiver();
                archiverDu.setArchiver( duArchiver );
                archiverDu.setOutputFile( duFile );

                // add ra jar
                archiverDu.getArchiver().addFile( new File( targetDirectory, finalName + ".jar" ), finalName + ".jar" );
                
                // add deployable unit xml
                FileUtils.copyFileToDirectory( basedir + "/xml/" + DEPLOYABLE_UNIT_XML, targetDirectory + "/META-INF" );
                addDirectory( archiverDu, new File(targetDirectory + "/META-INF") );

                // add dependencies
                Set artifacts = project.getDependencyArtifacts();
                for ( Iterator iter = artifacts.iterator(); iter.hasNext(); )
                {
                    Artifact artifact = (Artifact) iter.next();
                    ScopeArtifactFilter filter = new ScopeArtifactFilter( Artifact.SCOPE_RUNTIME );
                    if ( !artifact.isOptional() && filter.include( artifact ) )
                    {
                        if(!classpathPrefix.equals("")){
                            FileUtils.copyFileToDirectory( artifact.getFile(), new File( contentDirectory.getAbsolutePath()
                                    + "/" + classpathPrefix ) );
                        addDirectory( archiverDu, new File(contentDirectory.getAbsolutePath()+ "/" + classpathPrefix) );
                        }else{
                            FileUtils.copyFileToDirectory( artifact.getFile(), new File( contentDirectory.getAbsolutePath()) );
                            addDirectory( archiverDu, new File(contentDirectory.getAbsolutePath()) );
                        }
                        getLog().info("add dependencies "+artifact);
                    }
                }
                
                //archiverDu.createArchive( project, new MavenArchiveConfiguration() );
                archiverDu.createArchive( project, generateManifest(  archiverDu.getArchiver() ) );

                getLog().info( "ra deployable unit successfully created" );
                
                Artifact artifact = new DefaultArtifact( project.getGroupId(), project.getArtifactId() + "-DU",
                                         VersionRange.createFromVersion( project.getVersion() ),
                                         Artifact.SCOPE_RUNTIME, "jar", "", artifactHandler );
                artifact.setFile( duFile );
                
                deployer.deploy(duFile, artifact, local, local);
                getLog().info( "ra deployable unit successfully deployed on local repository" );
            }
            return jarFile;
        }
        catch ( Exception e )
        {
            // TODO: improve error handling
            throw new MojoExecutionException( "Error assembling DU ", e );
        }
    }
     
    private static void addDirectory( MavenArchiver archiver, File file ) throws ArchiverException
    {
        if ( file.exists() )
        {
            archiver.getArchiver().addDirectory( file, file.getName() + "/", DEFAULT_INCLUDES,
                                                 FileUtils.getDefaultExcludes() );
        }
    }

    private static void addFile( MavenArchiver archiver, File file ) throws ArchiverException
    {
        if ( file.exists() )
        {
            archiver.getArchiver().addFile( file, file.getName() );
        }
    }

    private static void addFile( MavenArchiver archiver, File file, String destinationDir) throws ArchiverException
    {
        if ( file.exists() )
        {
            File destination = new File(destinationDir);
            archiver.getArchiver().addDirectory( destination );
            archiver.getArchiver().addFile( file, destinationDir + file.getName() );
        }
    }


    private MavenArchiveConfiguration generateManifest( JarArchiver anArchiver )
        throws MojoExecutionException, DependencyResolutionRequiredException
    {
        Manifest mf = null;
        MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

        File manifestDir = new File( targetDirectory, "META-INF" );
        if ( !manifestDir.exists() )
        {
            manifestDir.mkdirs();
        }
        File manifestFile = new File( manifestDir.getAbsolutePath(), "MANIFEST.MF" );
        MavenArchiver ma = new MavenArchiver();
        ma.setArchiver( anArchiver );
        ma.setOutputFile( manifestFile );

        PrintWriter printWriter = null;
        try
        {
            mf = ma.getManifest( project, archive.getManifest() );
            Attribute classpathAttrib = mf.getMainSection().getAttribute( "Class-Path" );
            if ( classpathAttrib == null )
            {
                getLog().info( "Class-Path Attribute to MANIFEST" );
                StringBuffer classpath = new StringBuffer();
                List artifacts = project.getRuntimeClasspathElements();

                for ( Iterator iter = artifacts.iterator(); iter.hasNext(); )
                {
                    File f = new File( (String) iter.next() );
                    if ( f.isFile() )
                    {
                        if ( classpath.length() > 0 )
                        {
                            classpath.append( " " );
                        }
                        if ( !classpathPrefix.equals( "" ) )
                            classpath.append( classpathPrefix + "/" );

                        classpath.append( f.getName() );
                    }
                }

                if ( classpath.length() > 0 )
                {
                    classpathAttrib = new Manifest.Attribute( "Class-Path", classpath.toString() );
                    mf.addConfiguredAttribute( classpathAttrib );
                }
            }

            getLog().info( "\n" + "Class-Path" + "\n" + classpathAttrib.getValue() + "\n" );

            printWriter = new PrintWriter( new FileWriter( manifestFile ) );
            mf.write( printWriter );

            anArchiver.addConfiguredManifest( mf );
            return archive;

        }
        catch ( ManifestException e )
        {
            throw new MojoExecutionException( "Error preparing the manifest: " + e.getMessage(), e );
        }
        catch ( DependencyResolutionRequiredException e )
        {
            throw new MojoExecutionException( "Error preparing the manifest: " + e.getMessage(), e );
        }
        catch ( IOException e )
        {
            throw new MojoExecutionException( "Error preparing the manifest: " + e.getMessage(), e );
        }
        finally
        {
            IOUtil.close( printWriter );
            this.manifestFile = manifestFile;

        }

}
    
    /**
     * Generates the JAR.
     *
     * @todo Add license files in META-INF directory.
     */
    public void execute() throws MojoExecutionException
    {

        File jarFile = createArchive();
        project.getArtifact().setFile( jarFile );
        
    }
}
