/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.nirima.jenkins.bridge.BridgeRepository;
import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.webdav.impl.MethodFactory;
import com.nirima.jenkins.webdav.impl.ServletContextMimeTypeResolver;
import com.nirima.jenkins.webdav.interfaces.IMethod;
import com.nirima.jenkins.webdav.interfaces.IMethodFactory;
import hudson.Extension;
import hudson.Plugin;
import hudson.model.Build;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.model.RootAction;
import hudson.plugins.git.util.BuildData;
import hudson.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class RepositoryPlugin
extends Plugin
implements RootAction,
Serializable {
    private ServletContext context;
    private IMethodFactory methodFactory = new MethodFactory();
    public static String DISPLAY_NAME = "Jenkins Maven Repository Server";
    public static String URL = "repository";

    public String getIconFileName() {
        return "/plugin/repository/static/icons/repository-32x32.png";
    }

    public String getDisplayName() {
        return "Maven Repository";
    }

    public String getUrlName() {
        return "plugin/repository";
    }

    public void start() {
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        String path = req.getRestOfPath();
        String fullPath = req.getPathInfo();
        if (path.length() == 0) {
            path = "/";
        }
        if (path.indexOf("..") != -1 || path.length() < 1) {
            rsp.sendError(400);
            return;
        }
        if (path.startsWith("/static")) {
            super.doDynamic(req, rsp);
            return;
        }
        try {
            BridgeRepository repo = new BridgeRepository(null);
            if (repo.getMimeTypeResolver() == null) {
                ServletContextMimeTypeResolver ctx = new ServletContextMimeTypeResolver();
                ctx.setServletContext(req.getSession().getServletContext());
                repo.setMimeTypeResolver(ctx);
            }
            IMethod method = this.methodFactory.createMethod((HttpServletRequest)req, (HttpServletResponse)rsp);
            method.init((HttpServletRequest)req, (HttpServletResponse)rsp, null, repo, "/plugin/repository");
            method.invoke();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void displayElement(StaplerRequest req, StaplerResponse rsp, RepositoryElement currentItem) throws Exception {
        ServletOutputStream os = rsp.getOutputStream();
        if (currentItem instanceof RepositoryDirectory) {
            rsp.setContentType("text/html;charset=UTF-8");
            this.printHeader((OutputStream)os, req, (RepositoryDirectory)currentItem);
            for (RepositoryElement repositoryElement : ((RepositoryDirectory)currentItem).getChildren()) {
                this.printDirEntry((OutputStream)os, repositoryElement);
            }
            this.printFooter((OutputStream)os);
        } else {
            RepositoryContent content = (RepositoryContent)currentItem;
            String string = content.getContentType();
            if (string != null) {
                rsp.setContentType(string);
            }
            InputStream is = content.getContent();
            IOUtils.copy((InputStream)is, (OutputStream)os);
            os.flush();
        }
    }

    private Build getBuild(Project theProject, String type, String ref) {
        if (type.equals("build")) {
            int nbr = Integer.parseInt(ref);
            for (Object object : theProject.getBuilds()) {
                Build r = (Build)object;
                if (r.getNumber() != nbr) continue;
                return r;
            }
        } else {
            for (Object object : theProject.getBuilds()) {
                Build r = (Build)object;
                BuildData bd = (BuildData)r.getAction(BuildData.class);
                if (bd == null || !bd.getLastBuiltRevision().getSha1String().equals(ref)) continue;
                return r;
            }
        }
        return null;
    }

    private void printHeader(OutputStream os, StaplerRequest req, RepositoryDirectory directory) throws IOException {
        String title = "<html>\n  <head>\n    <title>Index of " + directory.getPath() + "</title>\n" + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>\n" + "    <link rel=\"stylesheet\" href=\"" + req.getContextPath() + "/plugin/repository/css/repository-style.css\" type=\"text/css\" media=\"screen\" title=\"no title\" charset=\"utf-8\">\n" + "  </head>\n" + "  <body>\n" + "    <h1>Index of " + directory.getPath() + "</h1>\n" + "    <table cellspacing=\"10\">\n" + "      <tr>\n" + "        <th align=\"left\">Name</th>\n" + "        <th>Last Modified</th>\n" + "        <th>Size</th>\n" + "        <th>Description</th>\n" + "      </tr>";
        String parent = "<tr>\n        <td>\n          <a href=\"../\">Parent Directory</a>\n        </td>\n      </tr>";
        os.write(title.getBytes("UTF-8"));
        if (directory.getParent() != null) {
            os.write(parent.getBytes("UTF-8"));
        }
    }

    private void printFooter(OutputStream os) throws IOException {
        String footer = "            </table>\n  </body>\n</html>";
        os.write(footer.getBytes("UTF-8"));
    }

    private void printDirEntry(OutputStream os, RepositoryElement item) throws IOException {
        String name = item.getName();
        String lastModified = "";
        String size = "";
        String description = "";
        if (item instanceof RepositoryDirectory) {
            name = name + "/";
        }
        if (item instanceof RepositoryContent) {
            size = "" + ((RepositoryContent)item).getSize();
            description = ((RepositoryContent)item).getDescription();
        }
        String entry = "      <tr>\n            <td>\n                              <a href=\"" + name + "\">" + name + "</a>\n" + "                          </td>\n" + "            <td>\n" + "              " + lastModified + "\n" + "            </td>\n" + "            <td align=\"right\">\n" + "                   " + size + "\n" + "                          </td>\n" + "            <td>\n" + "              " + description + "\n" + "            </td>\n" + "          </tr>";
        os.write(entry.getBytes("UTF-8"));
    }

    private Project getProject(String pathElement) {
        for (Project project : Hudson.getInstance().getProjects()) {
            if (!project.getName().equals(pathElement)) continue;
            return project;
        }
        return null;
    }
}

