/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins;

import com.nirima.jenkins.SelectionType;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.RunParameterValue;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class SelectionTypeUpstream
extends SelectionType {
    public String build;

    @DataBoundConstructor
    public SelectionTypeUpstream(String build) {
        this.build = build;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String buildId) {
        this.build = this.build;
    }

    public URL getUrl(AbstractBuild b) throws MalformedURLException, SelectionType.RepositoryDoesNotExistException {
        String theProject;
        URL url = new URL(Jenkins.getInstance().getRootUrl());
        url = new URL(url, "plugin/repository/project/");
        Cause.UpstreamCause theCause = (Cause.UpstreamCause)b.getCause(Cause.UpstreamCause.class);
        if (theCause == null) {
            ParametersAction action = (ParametersAction)b.getAction(ParametersAction.class);
            if (action == null) {
                throw new SelectionType.RepositoryDoesNotExistException();
            }
            RunParameterValue value = (RunParameterValue)action.getParameter("Upstream");
            theProject = value.getJobName();
            String theBuild = value.getNumber();
        } else {
            theProject = theCause.getUpstreamProject();
            String theBuild = "" + theCause.getUpstreamBuild();
        }
        url = new URL(url, theProject + "/");
        url = this.addBuildId(url, this.build);
        return url;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SelectionType> {
        public String getDisplayName() {
            return "Upstream Project that triggered this build";
        }
    }
}

