/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.bridge;

import com.nirima.jenkins.bridge.BridgeRepositoryContent;
import com.nirima.jenkins.bridge.BridgeRepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.RepositoryElement;
import com.nirima.jenkins.repo.RootElement;
import com.nirima.jenkins.webdav.interfaces.IDavCollection;
import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavItem;
import com.nirima.jenkins.webdav.interfaces.IDavRepo;
import com.nirima.jenkins.webdav.interfaces.IMimeTypeResolver;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeRepository
implements IDavRepo {
    private static final Logger log = Logger.getLogger(BridgeRepository.class);
    IMimeTypeResolver mimeTypeResolver;
    RootElement rootElement = new RootElement();

    public BridgeRepository(IMimeTypeResolver mimeTypeResolver) {
        this.mimeTypeResolver = mimeTypeResolver;
    }

    @Override
    public IDavItem getItem(IDavContext ctxt, String path) {
        try {
            RepositoryElement currentItem = this.rootElement;
            String[] pathElements = path.substring(1).split("/");
            if (pathElements.length > 1 || pathElements[0].length() > 0) {
                for (String element : pathElements) {
                    if (!(currentItem instanceof RepositoryDirectory)) continue;
                    RepositoryDirectory currentDirectory = currentItem;
                    currentItem = currentDirectory.getChild(element);
                }
            }
            return this.bridge(currentItem);
        }
        catch (Exception ex) {
            log.error((Object)("No such repository path " + path));
            return null;
        }
    }

    protected IDavItem bridge(RepositoryElement item) {
        if (item instanceof RepositoryContent) {
            return new BridgeRepositoryContent((IDavRepo)this, (RepositoryContent)item);
        }
        return new BridgeRepositoryDirectory((IDavRepo)this, (RepositoryDirectory)item);
    }

    @Override
    public Collection<IDavItem> getItems(IDavContext ctxt, IDavItem item, int depth) {
        ArrayList<IDavItem> items = new ArrayList<IDavItem>();
        items.add(item);
        if (item instanceof IDavCollection) {
            BridgeRepository.addChildItems(ctxt, items, (IDavCollection)item, depth);
        }
        return items;
    }

    private static void addChildItems(IDavContext ctxt, ArrayList<IDavItem> collection, IDavCollection dirItem, int depth) {
        if (depth == 0) {
            return;
        }
        ArrayList<IDavItem> childItems = dirItem.getChildren(ctxt);
        collection.addAll(childItems);
        for (IDavItem item : childItems) {
            if (!(item instanceof IDavCollection)) continue;
            BridgeRepository.addChildItems(ctxt, collection, (IDavCollection)item, depth - 1);
        }
    }

    @Override
    public IDavItem getRepositoryRoot(IDavContext ctxt) {
        return new BridgeRepositoryDirectory((IDavRepo)this, this.rootElement);
    }

    @Override
    public boolean supportsLocking() {
        return false;
    }

    @Override
    public IMimeTypeResolver getMimeTypeResolver() {
        return this.mimeTypeResolver;
    }

    @Override
    public void setMimeTypeResolver(IMimeTypeResolver resolver) {
        this.mimeTypeResolver = resolver;
    }
}

