/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.repo.RepositoryContent;
import com.nirima.jenkins.repo.RepositoryDirectory;
import com.nirima.jenkins.repo.build.MetadataRepositoryItem;
import hudson.maven.MavenBuild;
import hudson.maven.reporters.MavenArtifact;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;

public class ArtifactRepositoryItem
implements RepositoryContent {
    private MavenArtifact artifact;
    private MavenBuild build;
    private boolean timestampedSnapshot;
    private RepositoryDirectory directory;

    public ArtifactRepositoryItem(MavenBuild build, MavenArtifact mavenArtifact, boolean timestampedSnapshot) {
        this.artifact = mavenArtifact;
        this.build = build;
        this.timestampedSnapshot = timestampedSnapshot;
    }

    public String getName() {
        if (this.timestampedSnapshot && this.artifact.version.endsWith("-SNAPSHOT")) {
            String vers = MetadataRepositoryItem.formatDateVersion(this.getLastModified(), this.build.getNumber());
            return this.artifact.canonicalName.replaceAll("SNAPSHOT", vers);
        }
        return this.artifact.canonicalName;
    }

    public RepositoryDirectory getParent() {
        return this.directory;
    }

    public void setParent(RepositoryDirectory parent) {
        this.directory = parent;
    }

    public String getPath() {
        return this.directory.getPath() + "/" + this.getName();
    }

    public InputStream getContent() throws Exception {
        return new FileInputStream(this.getFile());
    }

    public Date getLastModified() {
        return new Date(this.getFile().lastModified());
    }

    public Long getSize() {
        return this.getFile().length();
    }

    public String getDescription() {
        return "From Build #" + this.build.getNumber() + " of " + this.build.getParentBuild().getParent().getName();
    }

    public boolean fileExists() {
        try {
            this.getFile();
            return true;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    public File getFile() {
        File fPath = new File(new File(new File(this.build.getArtifactsDir(), this.artifact.groupId), this.artifact.artifactId), this.artifact.version);
        File fArtifact = new File(fPath, this.artifact.canonicalName);
        if (fArtifact.exists()) {
            return fArtifact;
        }
        fArtifact = new File(fPath, this.artifact.fileName);
        if (fArtifact.exists()) {
            return fArtifact;
        }
        throw new IllegalStateException("Maven artifact cannot be found with name or canonicalName - " + this.artifact);
    }

    public String getArtifactPath() {
        return this.artifact.groupId.replace('.', '/') + "/" + this.artifact.artifactId + '/' + this.artifact.version + "/" + this.getName();
    }

    public String getContentType() {
        return null;
    }
}

