/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.repo.build.MetadataRepositoryItem;
import com.nirima.jenkins.repo.build.TextRepositoryItem;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

public class MetadataChecksumRepositoryItem
extends TextRepositoryItem {
    private String algorithm;
    private MetadataRepositoryItem item;

    public MetadataChecksumRepositoryItem(String algorithm, MetadataRepositoryItem item) {
        this.algorithm = algorithm;
        this.item = item;
    }

    public String getName() {
        return "maven-metadata.xml." + this.algorithm.toLowerCase();
    }

    public Date getLastModified() {
        return this.item.getLastModified();
    }

    public String getDescription() {
        return this.item.getDescription();
    }

    protected String generateContent() {
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm.toUpperCase());
            byte[] digest = md.digest(this.item.generateContent().getBytes());
            String hex = new BigInteger(1, digest).toString(16);
            return hex.length() % 2 == 0 ? hex : "0" + hex;
        }
        catch (NoSuchAlgorithmException nsae) {
            return "";
        }
    }
}

