/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.build;

import com.nirima.jenkins.repo.build.ArtifactRepositoryItem;
import com.nirima.jenkins.repo.build.TextRepositoryItem;
import hudson.maven.MavenBuild;
import hudson.maven.reporters.MavenArtifact;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MetadataRepositoryItem
extends TextRepositoryItem {
    private MavenBuild build;
    private String groupId;
    private String artifactId;
    private String version;
    private Map<String, ArtifactRepositoryItem> items = new HashMap<String, ArtifactRepositoryItem>();
    protected static SimpleDateFormat _ufmt = new SimpleDateFormat("yyyyMMddHHmmss");
    protected static SimpleDateFormat _vfmt = new SimpleDateFormat("yyyyMMdd.HHmmss");

    public static String formatDateVersion(Date date, int buildNo) {
        return _vfmt.format(date) + "-" + buildNo;
    }

    public MetadataRepositoryItem(MavenBuild build, MavenArtifact artifact) {
        this.build = build;
        this.groupId = artifact.groupId;
        this.artifactId = artifact.artifactId;
        this.version = artifact.version;
    }

    public String getPath() {
        return this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.getName();
    }

    public void addArtifact(MavenArtifact artifact, ArtifactRepositoryItem item) {
        this.items.put(artifact.type, item);
    }

    public String getName() {
        return "maven-metadata.xml";
    }

    public Date getLastModified() {
        long lastModified = 0L;
        for (ArtifactRepositoryItem item : this.items.values()) {
            lastModified = Math.max(lastModified, item.getLastModified().getTime());
        }
        return new Date(lastModified);
    }

    public String getDescription() {
        return "From Build #" + this.build.getNumber() + " of " + this.build.getParentBuild().getParent().getName();
    }

    protected String generateContent() {
        StringBuilder buf = new StringBuilder();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<metadata modelVersion=\"1.1.0\">\n");
        buf.append("  <groupId>" + this.groupId + "</groupId>\n");
        buf.append("  <artifactId>" + this.artifactId + "</artifactId>\n");
        buf.append("  <version>" + this.version + "</version>\n");
        buf.append("  <versioning>\n");
        buf.append("    <snapshotVersions>\n");
        for (Map.Entry<String, ArtifactRepositoryItem> entry : this.items.entrySet()) {
            String dateVers = MetadataRepositoryItem.formatDateVersion(entry.getValue().getLastModified(), this.build.getNumber());
            String itemVersion = this.version.replaceAll("SNAPSHOT", dateVers);
            String lastMod = _ufmt.format(entry.getValue().getLastModified());
            buf.append("      <snapshotVersion>\n");
            buf.append("        <extension>").append(entry.getKey()).append("</extension>\n");
            buf.append("        <value>").append(itemVersion).append("</value>\n");
            buf.append("        <updated>").append(lastMod).append("</updated>\n");
            buf.append("      </snapshotVersion>\n");
        }
        buf.append("    </snapshotVersions>\n");
        buf.append("  </versioning>\n");
        buf.append("</metadata>\n");
        return buf.toString();
    }
}

