/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.util;

import com.nirima.jenkins.repo.build.ArtifactRepositoryItem;
import com.nirima.jenkins.repo.build.DirectoryRepositoryItem;
import com.nirima.jenkins.repo.build.MetadataChecksumRepositoryItem;
import com.nirima.jenkins.repo.build.MetadataRepositoryItem;
import com.nirima.jenkins.repo.util.HudsonVisitor;
import hudson.maven.MavenBuild;
import hudson.maven.reporters.MavenArtifact;
import java.util.HashMap;
import java.util.Map;

public class DirectoryPopulatorVisitor
extends HudsonVisitor {
    DirectoryRepositoryItem root;
    public boolean allowOverwrite;
    private Map<String, MetadataRepositoryItem> metadata = new HashMap<String, MetadataRepositoryItem>();

    public DirectoryPopulatorVisitor(DirectoryRepositoryItem root, boolean allowOverwrite) {
        this.root = root;
        this.allowOverwrite = allowOverwrite;
    }

    public void visitArtifact(MavenBuild build, MavenArtifact artifact) {
        ArtifactRepositoryItem repositoryItem = new ArtifactRepositoryItem(build, artifact, false);
        if (!repositoryItem.fileExists()) {
            return;
        }
        this.root.insert(repositoryItem, repositoryItem.getArtifactPath(), this.allowOverwrite);
        if (artifact.version.endsWith("-SNAPSHOT")) {
            ArtifactRepositoryItem item = new ArtifactRepositoryItem(build, artifact, true);
            this.root.insert(item, item.getArtifactPath(), this.allowOverwrite);
            String key = artifact.groupId + ":" + artifact.artifactId + ":" + artifact.version;
            MetadataRepositoryItem meta = this.metadata.get(key);
            if (meta == null) {
                meta = new MetadataRepositoryItem(build, artifact);
                this.metadata.put(key, meta);
                this.root.insert(meta, meta.getPath(), this.allowOverwrite);
                this.root.insert(new MetadataChecksumRepositoryItem("md5", meta), meta.getPath() + ".md5", this.allowOverwrite);
                this.root.insert(new MetadataChecksumRepositoryItem("sha1", meta), meta.getPath() + ".sha1", this.allowOverwrite);
            }
            meta.addArtifact(artifact, item);
        }
    }
}

