/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.repo.util;

import com.nirima.jenkins.repo.util.HudsonVisitor;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.reporters.MavenArtifact;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.util.RunList;
import java.util.List;
import java.util.Map;

public class HudsonWalker {
    public static void traverse(HudsonVisitor visitor) {
        for (BuildableItemWithBuildWrappers item : Hudson.getInstance().getAllItems(BuildableItemWithBuildWrappers.class)) {
            visitor.visitProject(item);
            RunList runs = item.asProject().getBuilds();
            for (Run run : runs) {
                HudsonWalker.traverse(visitor, run);
            }
        }
    }

    public static void traverseProjectsAndBuilds(HudsonVisitor visitor) {
        for (BuildableItemWithBuildWrappers item : Hudson.getInstance().getAllItems(BuildableItemWithBuildWrappers.class)) {
            visitor.visitProject(item);
            RunList runs = item.asProject().getBuilds();
            for (Run run : runs) {
                if (!(run instanceof MavenModuleSetBuild)) continue;
                MavenModuleSetBuild mmsb = (MavenModuleSetBuild)run;
                visitor.visitModuleSet(mmsb);
            }
        }
    }

    public static void traverseChain(HudsonVisitor visitor, Run run) {
        if (run == null) {
            return;
        }
        HudsonWalker.traverse(visitor, run);
        Cause.UpstreamCause upstream = (Cause.UpstreamCause)run.getCause(Cause.UpstreamCause.class);
        if (upstream != null) {
            String project = upstream.getUpstreamProject();
            int build = upstream.getUpstreamBuild();
            AbstractProject item = (AbstractProject)Hudson.getInstance().getItem(project);
            Run r = (Run)item.getBuilds().get(build);
            HudsonWalker.traverseChain(visitor, r);
        }
    }

    public static void traverse(HudsonVisitor visitor, Run run) {
        if (run instanceof MavenModuleSetBuild) {
            MavenModuleSetBuild item = (MavenModuleSetBuild)run;
            visitor.visitModuleSet(item);
            Map modulesMap = item.getModuleBuilds();
            for (List builds : modulesMap.values()) {
                for (MavenBuild build : builds) {
                    visitor.visitBuild(build);
                    MavenArtifactRecord artifacts = (MavenArtifactRecord)build.getAction(MavenArtifactRecord.class);
                    if (artifacts == null) continue;
                    visitor.visitArtifact(build, artifacts.pomArtifact);
                    if (artifacts.mainArtifact != artifacts.pomArtifact) {
                        visitor.visitArtifact(build, artifacts.mainArtifact);
                    }
                    for (MavenArtifact art : artifacts.attachedArtifacts) {
                        visitor.visitArtifact(build, art);
                    }
                }
            }
        }
    }
}

