/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.webdav.impl;

import com.nirima.jenkins.webdav.impl.DavProperty;
import com.nirima.jenkins.webdav.interfaces.IDavCollection;
import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavFile;
import com.nirima.jenkins.webdav.interfaces.IDavItem;
import com.nirima.jenkins.webdav.interfaces.IDavLock;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAVItemSerializer {
    private static final Logger log = Logger.getLogger(DAVItemSerializer.class);
    public static final String dateFormatString = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String createDateFormatString = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public void generateLockProperties(IDavItem item, XMLStreamWriter response) throws IOException {
    }

    public void generateNamedProperties(IDavContext ctxt, IDavItem item, XMLStreamWriter response, ArrayList<DavProperty> properties) throws IOException, XMLStreamException {
        ArrayList<DavProperty> missingProperties = new ArrayList<DavProperty>();
        response.writeStartElement("DAV:", "propstat");
        response.writeStartElement("DAV:", "prop");
        for (DavProperty prop : properties) {
            if (prop.getNamespace().equals("DAV:")) {
                if (prop.getProperty().equals("lockdiscovery") && item.isLocked(ctxt)) continue;
                if (prop.getProperty().equals("supportedlock")) {
                    this.printLockSupport(response, item);
                    continue;
                }
                if (prop.getProperty().equals("resourcetype")) {
                    this.printResourceType(response, item);
                    continue;
                }
                if (prop.getProperty().equals("displayname")) {
                    this.printDisplayName(response, item);
                    continue;
                }
                if (prop.getProperty().equals("source")) {
                    this.writeEmptyElement(response, "DAV:", "source");
                    continue;
                }
                if (prop.getProperty().equals("getlastmodified")) {
                    this.printLastModified(response, item);
                    continue;
                }
                if (prop.getProperty().equals("getcontentlanguage") && item instanceof IDavFile) {
                    this.printContentLanguage(response, (IDavFile)item);
                    continue;
                }
                if (prop.getProperty().equals("getcontenttype") && item instanceof IDavFile) {
                    this.printContentType(response, (IDavFile)item);
                    continue;
                }
                if (prop.getProperty().equals("getetag") && item instanceof IDavFile) {
                    this.printETag(response, (IDavFile)item);
                    continue;
                }
                if (prop.getProperty().equals("getcontentlength")) {
                    this.printContentLength(response, item);
                    continue;
                }
                if (prop.getProperty().equals("creationdate")) {
                    this.printCreationDate(response, item, new SimpleDateFormat(createDateFormatString));
                    continue;
                }
                missingProperties.add(prop);
                continue;
            }
            missingProperties.add(prop);
        }
        response.writeEndElement();
        this.writeSimpleElement(response, "DAV:", "status", "HTTP/1.1 200 OK");
        response.writeEndElement();
        if (missingProperties.size() == 0) {
            return;
        }
        response.writeStartElement("DAV:", "propstat");
        response.writeStartElement("DAV:", "prop");
        for (DavProperty prop : missingProperties) {
            this.writeEmptyElement(response, prop.getNamespace(), prop.getProperty());
        }
        response.writeEndElement();
        this.writeSimpleElement(response, "DAV:", "status", "HTTP/1.1 404 Not Found");
        response.writeEndElement();
    }

    private void printLockSupport(XMLStreamWriter response, IDavItem item) throws IOException, XMLStreamException {
        if (item.getRepo().supportsLocking()) {
            response.writeStartElement("DAV:", "supportedlock");
            response.writeStartElement("DAV:", "lockentry");
            response.writeStartElement("DAV:", "lockscope");
            response.writeStartElement("DAV:", "exclusive");
            response.writeEndElement();
            response.writeEndElement();
            response.writeStartElement("DAV:", "locktype");
            response.writeStartElement("DAV:", "write");
            response.writeEndElement();
            response.writeEndElement();
            response.writeEndElement();
            response.writeEndElement();
        }
    }

    private void printContentLength(XMLStreamWriter response, IDavItem item) throws IOException, XMLStreamException {
        response.writeStartElement("DAV:", "getcontentlength");
        if (item instanceof IDavCollection) {
            response.writeCharacters("0");
        } else {
            response.writeCharacters(Long.toString(((IDavFile)item).getContentLength()));
        }
        response.writeEndElement();
    }

    private void printResourceType(XMLStreamWriter response, IDavItem item) throws IOException, XMLStreamException {
        if (item instanceof IDavCollection) {
            response.writeStartElement("DAV:", "resourcetype");
            response.writeStartElement("DAV:", "collection");
            response.writeEndElement();
            response.writeEndElement();
        } else {
            response.writeStartElement("DAV:", "resourcetype");
            response.writeEndElement();
        }
    }

    public void generateLockXml(XMLStreamWriter response, IDavLock item) throws IOException, XMLStreamException {
        response.writeStartElement("DAV:", "lockdiscovery");
        response.writeStartElement("DAV:", "activelock");
        response.writeStartElement("DAV:", "locktype");
        this.writeEmptyElement(response, "DAV:", "write");
        response.writeEndElement();
        response.writeStartElement("DAV:", "lockscope");
        this.writeEmptyElement(response, "DAV:", "exclusive");
        response.writeEndElement();
        this.writeSimpleElement(response, "DAV:", "depth", Integer.toString(item.getDepth()));
        this.writeSimpleElement(response, "DAV:", "owner", item.getOwner());
        Date expires = item.getExpiration();
        if (expires == null) {
            this.writeSimpleElement(response, "DAV:", "timeout", "Infinite");
        } else {
            long now = new Date().getTime();
            long secsRemain = (expires.getTime() - now) / 1000L;
            this.writeSimpleElement(response, "DAV:", "timeout", "Second-" + secsRemain);
        }
        response.writeStartElement("DAV:", "locktoken");
        this.writeSimpleElement(response, "DAV:", "href", "opaquelocktoken:" + item.getToken());
        response.writeEndElement();
        response.writeEndElement();
        response.writeEndElement();
    }

    private void printContentLanguage(XMLStreamWriter response, IDavFile item) throws IOException, XMLStreamException {
        this.writeSimpleElement(response, "DAV:", "getcontentlanguage", item.getContentLanguage());
    }

    private void printContentType(XMLStreamWriter response, IDavFile item) throws IOException, XMLStreamException {
        this.writeSimpleElement(response, "DAV:", "getcontenttype", item.getContentType());
    }

    private void printDisplayName(XMLStreamWriter response, IDavItem item) throws IOException, XMLStreamException {
        log.debug((Object)"Trying to get");
        String itemName = item.getName();
        log.debug((Object)("got " + itemName));
        if (itemName == null) {
            itemName = "null";
        }
        this.writeSimpleElement(response, "DAV:", "displayname", itemName);
    }

    private void printETag(XMLStreamWriter response, IDavFile item) throws IOException, XMLStreamException {
        this.writeSimpleElement(response, "DAV:", "getetag", item.getETag());
    }

    private void printLastModified(XMLStreamWriter response, IDavItem item) throws IOException, XMLStreamException {
        this.writeSimpleElement(response, "DAV:", "getlastmodified", new SimpleDateFormat(dateFormatString).format(item.getLastModified()));
    }

    private void printCreationDate(XMLStreamWriter response, IDavItem item, SimpleDateFormat formatter) throws IOException, XMLStreamException {
        this.writeSimpleElement(response, "DAV:", "creationdate", formatter.format(item.getCreationDate()));
    }

    public void generateProperties(IDavContext ctxt, IDavItem item, XMLStreamWriter response, boolean created) throws IOException, XMLStreamException {
        response.writeStartElement("DAV:", "propstat");
        response.writeStartElement("DAV:", "prop");
        if (item.isLocked(ctxt)) {
            this.generateLockProperties(item, response);
        }
        this.printLockSupport(response, item);
        this.printResourceType(response, item);
        this.printDisplayName(response, item);
        this.writeEmptyElement(response, "DAV:", "source");
        this.printLastModified(response, item);
        if (item instanceof IDavFile) {
            this.printContentLanguage(response, (IDavFile)item);
            this.printContentType(response, (IDavFile)item);
            this.printETag(response, (IDavFile)item);
        }
        this.printContentLength(response, item);
        SimpleDateFormat creationDateFormat = new SimpleDateFormat(createDateFormatString);
        this.printCreationDate(response, item, creationDateFormat);
        this.writeSimpleElement(response, "DAV:", "creationdate", creationDateFormat.format(item.getCreationDate()));
        response.writeEndElement();
        if (created) {
            this.writeSimpleElement(response, "DAV:", "status", "HTTP/1.1 201 Created");
        } else {
            this.writeSimpleElement(response, "DAV:", "status", "HTTP/1.1 200 OK");
        }
        response.writeEndElement();
    }

    protected XMLStreamWriter writeSimpleElement(XMLStreamWriter response, String ns, String name, String value) throws IOException, XMLStreamException {
        response.writeStartElement(ns, name);
        response.writeCharacters(value);
        response.writeEndElement();
        return response;
    }

    protected XMLStreamWriter writeEmptyElement(XMLStreamWriter response, String ns, String name) throws IOException, XMLStreamException {
        response.writeStartElement(ns, name);
        response.writeEndElement();
        return response;
    }
}

