/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.webdav.impl.methods;

import com.nirima.jenkins.webdav.impl.methods.MethodBase;
import com.nirima.jenkins.webdav.interfaces.IDavCollection;
import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavFile;
import com.nirima.jenkins.webdav.interfaces.IDavItem;
import com.nirima.jenkins.webdav.interfaces.MethodException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class Head
extends MethodBase {
    private static Logger s_logger = Logger.getLogger(Head.class);

    public void invoke(IDavContext ctxt) throws MethodException {
        try {
            if (this.suppliedHeader("Range")) {
                s_logger.warn((Object)"Don't yet support RANGE");
            }
            ArrayList<String> ifMatchTags = this.getETags("If-Match");
            ArrayList<String> ifNoneMatchTags = this.getETags("If-None-Match");
            Date ifModifiedSince = this.getHeaderDate("If-Modified-Since");
            Date ifUnmodifiedSince = this.getHeaderDate("If-Unmodified-Since");
            IDavItem item = this.getRepo().getItem(this.getDavContext(), this.getPath());
            if (item == null) {
                this.getResponse().setStatus(404);
                return;
            }
            if (item instanceof IDavCollection) {
                if (!this.getPath().endsWith("/")) {
                    this.getResponse().setHeader("Location", this.getUrl() + "/");
                    this.getResponse().setStatus(302);
                    return;
                }
                this.generateDirectoryListing(ctxt, (IDavCollection)item);
                return;
            }
            IDavFile fileItem = (IDavFile)item;
            this.getResponse().setHeader("ETag", "\"" + fileItem.getETag() + "\"");
            this.getResponse().setHeader("Last-Modified", new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(fileItem.getLastModified()));
            String contentType = fileItem.getContentType();
            this.getResponse().setHeader("Content-Type", contentType);
            this.getResponse().setHeader("Content-Length", Long.toString(fileItem.getContentLength()));
            this.writeContent(fileItem);
        }
        catch (Exception e) {
            throw new MethodException("Exception", e);
        }
    }

    protected void writeContent(IDavFile fileItem) throws IOException {
    }

    protected void generateDirectoryListing(IDavContext ctxt, IDavCollection item) throws IOException {
        PrintWriter writer = this.getResponse().getWriter();
        String name = item.getName();
        if (name == null) {
            name = "Repository";
        }
        writer.write("<H1>" + name + "</H1>");
        writer.write("<TABLE>");
        for (IDavItem cItem : item.getChildren(ctxt)) {
            writer.write("<TR>");
            writer.write("<TD>" + cItem.getLastModified().toString() + "</TD>");
            if (cItem instanceof IDavFile) {
                IDavFile file = (IDavFile)cItem;
                writer.write("<TD>" + Long.toString(file.getContentLength()) + "</TD>");
                writer.write("<TD><A href='" + file.getName() + "'>" + file.getName() + "</A></TD>");
                if (file.isLocked(ctxt)) {
                    writer.write("<TD>(Locked)</TD>");
                } else {
                    writer.write("<TD></TD>");
                }
            } else {
                IDavCollection dir = (IDavCollection)cItem;
                writer.write("<TD>DIR</TD>");
                writer.write("<TD><A href='" + dir.getName() + "/'>" + dir.getName() + "</A></TD>");
                writer.write("<TD></TD>");
            }
            writer.write("</TR>");
        }
        writer.write("</TABLE>");
    }
}

