/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.webdav.impl.methods;

import com.nirima.jenkins.webdav.impl.DAVItemSerializer;
import com.nirima.jenkins.webdav.impl.DavProperty;
import com.nirima.jenkins.webdav.impl.methods.MethodBase;
import com.nirima.jenkins.webdav.interfaces.IDavContext;
import com.nirima.jenkins.webdav.interfaces.IDavFile;
import com.nirima.jenkins.webdav.interfaces.IDavItem;
import com.nirima.jenkins.webdav.interfaces.MethodException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Propfind
extends MethodBase {
    private static Logger s_logger = Logger.getLogger(Propfind.class);
    private ArrayList<DavProperty> m_properties;
    private int m_depth = 0;

    @Override
    public void invoke(IDavContext ctxt) throws MethodException {
        try {
            s_logger.info((Object)"propfind invoke");
            this.m_depth = this.getHeaderInt("Depth", 0);
            s_logger.info((Object)("Depth = " + this.m_depth));
            XMLStreamReader xpp = this.getDocument();
            if (xpp == null) {
                this.invokeInternal(ctxt);
                return;
            }
            int eventType = xpp.getEventType();
            while (eventType != 8) {
                if (eventType == 1) {
                    String name = xpp.getName().getLocalPart();
                    s_logger.info((Object)("rcvd " + name + " " + xpp.getName().getNamespaceURI()));
                    if (name.equals("propfind")) {
                        // empty if block
                    }
                    if (name.equals("prop")) {
                        this.m_properties = this.getRequiredProperties(xpp);
                        this.invokeInternal(ctxt);
                    } else if (name.equals("allprop")) {
                        this.invokeInternal(ctxt);
                    } else if (name.equals("propname")) {
                        s_logger.info((Object)("*** TODO propname " + name + " " + xpp.getName().getNamespaceURI()));
                    }
                }
                eventType = xpp.next();
            }
        }
        catch (Exception e) {
            throw new MethodException("Error", e);
        }
    }

    protected void invokeInternal(IDavContext ctxt) throws IOException, MethodException, XMLStreamException {
        IDavItem topLevelItem = this.getRepo().getItem(this.getDavContext(), this.getPath());
        if (topLevelItem == null) {
            this.getResponse().setStatus(404);
            return;
        }
        this.getResponse().setStatus(207);
        this.getResponse().setContentType("text/xml; charset=UTF-8");
        XMLStreamWriter response = this.createXmlResponse();
        response.setPrefix("a", "DAV:");
        response.writeStartElement("DAV:", "multistatus");
        if (topLevelItem instanceof IDavFile) {
            this.printItem(ctxt, response, topLevelItem);
        } else if (this.m_depth == 0) {
            this.printItem(ctxt, response, topLevelItem);
        } else {
            Collection<IDavItem> items = this.getRepo().getItems(this.getDavContext(), topLevelItem, this.m_depth);
            for (IDavItem di : items) {
                this.printItem(ctxt, response, di);
            }
        }
        response.writeEndElement();
        response.writeEndDocument();
        response.flush();
        response.close();
    }

    protected void printItem(IDavContext ctxt, XMLStreamWriter response, IDavItem di) throws IOException, MethodException, XMLStreamException {
        DAVItemSerializer dis = new DAVItemSerializer();
        response.writeStartElement("DAV:", "response");
        response.writeStartElement("DAV:", "href");
        String href = this.getBaseUrl();
        if (!di.equals(this.getRepo().getRepositoryRoot(this.getDavContext()))) {
            href = href + di.getPath(ctxt);
        }
        URL url = new URL(href);
        href = url.getPath();
        s_logger.info((Object)("PATH href " + href));
        response.writeCharacters(href);
        response.writeEndElement();
        if (this.m_properties != null) {
            dis.generateNamedProperties(ctxt, di, response, this.m_properties);
        } else {
            dis.generateProperties(ctxt, di, response, false);
        }
        response.writeEndElement();
    }

    protected ArrayList<DavProperty> getRequiredProperties(XMLStreamReader xpp) throws IOException, XMLStreamException {
        ArrayList<DavProperty> properties = new ArrayList<DavProperty>();
        String name = xpp.getName().getLocalPart();
        int eventType = xpp.next();
        while (!(eventType == 2 && xpp.getName().getLocalPart().equals(name) || eventType == 8)) {
            if (eventType == 1) {
                String ns = xpp.getName().getNamespaceURI();
                String prop = xpp.getName().getLocalPart();
                s_logger.info((Object)("Asking for property " + ns + ", " + prop));
                properties.add(new DavProperty(ns, prop));
            }
            eventType = xpp.next();
        }
        return properties;
    }
}

