/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import edu.umd.cs.findbugs.OpcodeStack;
import jp.skypencil.findbugs.slf4j.ArrayData;
import jp.skypencil.findbugs.slf4j.ThrowableHandler;

class ArrayDataHandler {
    private final ThrowableHandler throwableHandler;

    ArrayDataHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }

    void sawOpcode(OpcodeStack stack, int seen) {
        if (seen == 83) {
            this.checkStoredInstance(stack);
        }
    }

    ArrayData afterOpcode(OpcodeStack stack, int seen) {
        if (seen != 189) {
            return null;
        }
        return this.tryToDetectArraySize(stack);
    }

    private void checkStoredInstance(OpcodeStack stack) {
        OpcodeStack.Item storedValue = stack.getStackItem(0);
        OpcodeStack.Item arrayIndexItem = stack.getStackItem(1);
        OpcodeStack.Item targetArray = stack.getStackItem(2);
        Object arrayIndex = arrayIndexItem.getConstant();
        if (arrayIndex instanceof Number) {
            ArrayData data = (ArrayData)targetArray.getUserValue();
            Number index = (Number)arrayIndex;
            if (data != null && data.getSize() - 1 == index.intValue()) {
                data.setThrowableAtLast(this.throwableHandler.checkThrowable(storedValue));
            }
        }
    }

    private ArrayData tryToDetectArraySize(OpcodeStack stack) {
        OpcodeStack.Item arraySizeItem = stack.getStackItem(0);
        int arraySize = arraySizeItem != null && arraySizeItem.getConstant() instanceof Number ? ((Number)arraySizeItem.getConstant()).intValue() : -1;
        return new ArrayData(arraySize);
    }
}

