/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

class ThrowableHandler {
    private static final String IS_THROWABLE = "IS_THROWABLE";
    private final JavaClass throwable;

    ThrowableHandler() {
        try {
            this.throwable = Repository.lookupClass((String)"java/lang/Throwable");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    void sawOpcode(OpcodeStackDetector detector, int seen) {
        if (detector.atCatchBlock()) {
            detector.getStack().getStackItem(0).setUserValue((Object)IS_THROWABLE);
        }
    }

    void afterOpcode(OpcodeStackDetector detector, int seen) {
        try {
            OpcodeStack stack = detector.getStack();
            if (seen == 187 && Repository.lookupClass((String)detector.getClassConstantOperand()).instanceOf(this.throwable)) {
                OpcodeStack.Item createdThrowable = stack.getStackItem(0);
                createdThrowable.setUserValue((Object)IS_THROWABLE);
            } else if (seen == 185 || seen == 182) {
                String signature = detector.getMethodDescriptorOperand().getSignature();
                String returnType = signature.substring(1 + signature.lastIndexOf(41));
                if (!returnType.startsWith("L")) {
                    return;
                }
                JavaClass returnClass = Repository.lookupClass((String)(returnType = returnType.substring(1, returnType.length() - 1).replaceAll("/", ".")));
                if (returnClass.instanceOf(this.throwable)) {
                    OpcodeStack.Item returnedThrowable = stack.getStackItem(0);
                    returnedThrowable.setUserValue((Object)IS_THROWABLE);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("class not found", e);
        }
    }

    boolean checkThrowable(OpcodeStack.Item stackItem) {
        return IS_THROWABLE.equals(stackItem.getUserValue());
    }
}

