/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.skypencil.findbugs.slf4j.ArrayData;
import jp.skypencil.findbugs.slf4j.ArrayDataHandler;
import jp.skypencil.findbugs.slf4j.ThrowableHandler;

public class WrongPlaceholderDetector
extends OpcodeStackDetector {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(.?)(\\\\\\\\)*\\{\\}");
    private final BugReporter bugReporter;
    private final ArrayDataHandler arrayDataHandler;
    private final ThrowableHandler throwableHandler;
    private static final Set<String> TARGET_METHOD_NAMES = new HashSet<String>(Arrays.asList("trace", "debug", "info", "warn", "error"));
    private static final Set<String> SIGS_WITHOUT_FORMAT = new HashSet<String>(Arrays.asList("(Ljava/lang/String;)V", "(Lorg/slf4j/Maker;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "(Lorg/slf4j/Maker;Ljava/lang/String;Ljava/lang/Throwable;)V"));
    private static final Pattern SIGNATURE_PATTERN = Pattern.compile("^\\((.*)\\).*$");

    public WrongPlaceholderDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.throwableHandler = new ThrowableHandler();
        this.arrayDataHandler = new ArrayDataHandler(this.throwableHandler);
    }

    public void sawOpcode(int seen) {
        this.throwableHandler.sawOpcode(this, seen);
        if (seen == 185) {
            this.checkLogger();
        }
        this.arrayDataHandler.sawOpcode(this.stack, seen);
    }

    public void afterOpcode(int seen) {
        ArrayData newUserValueToSet = this.arrayDataHandler.afterOpcode(this.stack, seen);
        super.afterOpcode(seen);
        if (newUserValueToSet != null) {
            OpcodeStack.Item createdArray = this.stack.getStackItem(0);
            createdArray.setUserValue((Object)newUserValueToSet);
        }
        this.throwableHandler.afterOpcode(this, seen);
    }

    private void checkLogger() {
        int parameterCount;
        String signature = this.getSigConstantOperand();
        if (!"org/slf4j/Logger".equals(this.getClassConstantOperand()) || !TARGET_METHOD_NAMES.contains(this.getNameConstantOperand())) {
            return;
        }
        boolean withoutFormat = SIGS_WITHOUT_FORMAT.contains(signature);
        String formatString = this.getFormatString(this.stack, signature);
        if (formatString == null || withoutFormat) {
            return;
        }
        int placeholderCount = this.countPlaceholder(formatString);
        try {
            parameterCount = this.countParameter(this.stack, signature);
        }
        catch (IllegalStateException e) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_UNKNOWN_ARRAY", 1).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            this.bugReporter.reportBug(bug);
            return;
        }
        if (placeholderCount != parameterCount) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_PLACE_HOLDER_MISMATCH", 1).addInt(placeholderCount).addInt(parameterCount).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            this.bugReporter.reportBug(bug);
        }
    }

    int countParameter(OpcodeStack stack, String methodSignature) {
        OpcodeStack.Item lastItem;
        String[] signatures = this.splitSignature(methodSignature);
        if (signatures[signatures.length - 1].equals("[Ljava/lang/Object;")) {
            ArrayData arrayData = (ArrayData)stack.getStackItem(0).getUserValue();
            if (arrayData == null || arrayData.getSize() < 0) {
                throw new IllegalStateException("no array initializer found");
            }
            int parameterCount = arrayData.getSize();
            if (arrayData.hasThrowableAtLast()) {
                --parameterCount;
            }
            return parameterCount;
        }
        int parameterCount = signatures.length - 1;
        if (signatures[0].equals("Lorg/slf4j/Maker;")) {
            --parameterCount;
        }
        if (this.throwableHandler.checkThrowable(lastItem = stack.getStackItem(0))) {
            --parameterCount;
        }
        return parameterCount;
    }

    int countPlaceholder(String format) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(format);
        int count = 0;
        while (matcher.find()) {
            if ("\\".equals(matcher.group(1))) continue;
            ++count;
        }
        return count;
    }

    private String getFormatString(OpcodeStack stack, String signature) {
        int stackIndex = this.indexOf(signature, "Ljava/lang/String;");
        Object constant = stack.getStackItem(stackIndex).getConstant();
        if (constant == null) {
            BugInstance bug = new BugInstance((Detector)this, "SLF4J_FORMAT_SHOULD_BE_CONST", 1).addSourceLine((BytecodeScanningDetector)this).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this);
            this.bugReporter.reportBug(bug);
            return null;
        }
        return constant.toString();
    }

    int indexOf(String methodSignature, String targetType) {
        String[] arguments = this.splitSignature(methodSignature);
        int index = arguments.length;
        for (String type : arguments) {
            --index;
            if (!type.equals(targetType)) continue;
            return index;
        }
        return -1;
    }

    private String[] splitSignature(String methodSignature) {
        Matcher matcher = SIGNATURE_PATTERN.matcher(methodSignature);
        if (matcher.find()) {
            String[] arguments = matcher.group(1).split(";");
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = arguments[i] + ';';
            }
            return arguments;
        }
        throw new IllegalArgumentException();
    }
}

