/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.LinkedList;
import jp.skypencil.findbugs.slf4j.JavaType;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.generic.Type;

public class IllegalPassedClassDetector
extends OpcodeStackDetector {
    private final BugReporter bugReporter;

    public IllegalPassedClassDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void afterOpcode(int code) {
        if (code == 182 && Objects.equal("getClass", this.getNameConstantOperand()) && Objects.equal("java/lang/Object", this.getClassConstantOperand())) {
            this.memorizeResultOfGetClassMethod(code);
        } else if (code == 18 || code == 19) {
            this.memorizeResultOfClassLiteral(code);
        } else {
            super.afterOpcode(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memorizeResultOfClassLiteral(int code) {
        JavaType storedClass;
        Constant constant = this.getConstantRefOperand();
        if (constant.getTag() != 7) {
            super.afterOpcode(code);
            return;
        }
        try {
            String storedClassName = this.getClassConstantOperand();
            storedClass = this.findClass(storedClassName);
        }
        finally {
            super.afterOpcode(code);
        }
        OpcodeStack.Item returnedClass = this.getStack().getStackItem(0);
        returnedClass.setUserValue((Object)storedClass);
    }

    private void memorizeResultOfGetClassMethod(int code) {
        JavaType classOfCaller;
        OpcodeStack.Item caller = this.getStack().getStackItem(0);
        try {
            classOfCaller = JavaType.from(caller.getJavaClass());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            super.afterOpcode(code);
        }
        OpcodeStack.Item returnedClass = this.getStack().getStackItem(0);
        returnedClass.setUserValue((Object)classOfCaller);
    }

    private JavaType findClass(String storedClassName) {
        try {
            return JavaType.from(Repository.lookupClass((String)storedClassName));
        }
        catch (ClassNotFoundException e) {
            Type type = Type.getType((String)storedClassName);
            return JavaType.from(type);
        }
    }

    public void sawOpcode(int code) {
        OpcodeStack.Item passedItem;
        Object userValue;
        if (code == 184 && Objects.equal("org/slf4j/LoggerFactory", this.getClassConstantOperand()) && Objects.equal("getLogger", this.getNameConstantOperand()) && Objects.equal("(Ljava/lang/Class;)Lorg/slf4j/Logger;", this.getSigConstantOperand()) && (userValue = (passedItem = this.getStack().getStackItem(0)).getUserValue()) instanceof JavaType) {
            this.verifyPassedClassToGetLoggerMethod((JavaType)userValue);
        }
    }

    private void verifyPassedClassToGetLoggerMethod(JavaType passedClass) {
        String passedClassName = passedClass.toString();
        LinkedList<String> acceptableClasses = new LinkedList<String>();
        String callerClassName = this.getDottedClassName();
        while (!callerClassName.isEmpty()) {
            if (callerClassName.equals(passedClassName)) {
                return;
            }
            acceptableClasses.push(callerClassName);
            int index = callerClassName.lastIndexOf(36);
            if (index == -1) break;
            callerClassName = callerClassName.substring(0, index);
        }
        BugInstance bug = new BugInstance((Detector)this, "SLF4J_ILLEGAL_PASSED_CLASS", 1).addString(((Object)acceptableClasses).toString()).addSourceLine((BytecodeScanningDetector)this).addClass((PreorderVisitor)this);
        this.bugReporter.reportBug(bug);
    }
}

