/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j.parameter;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import java.util.BitSet;
import jp.skypencil.findbugs.slf4j.JavaType;
import org.apache.bcel.generic.Type;

public class ThrowableHandler {
    private static final String IS_THROWABLE = "IS_THROWABLE";
    private final BitSet isThrowable = new BitSet();

    void sawOpcode(OpcodeStackDetector detector, int seen) {
        OpcodeStack stack = detector.getStack();
        if (detector.atCatchBlock()) {
            stack.getStackItem(0).setUserValue((Object)IS_THROWABLE);
        }
        if (seen == 58 || seen == 75 || seen == 76 || seen == 77 || seen == 78) {
            int index = this.indexOfLocalVariable(detector, seen);
            this.isThrowable.set(index, this.checkThrowable(stack.getStackItem(0)));
        }
    }

    void afterOpcode(OpcodeStackDetector detector, int seen) {
        JavaType javaType;
        FieldDescriptor targetField;
        Type type;
        OpcodeStack stack = detector.getStack();
        if (stack.isTop()) {
            System.err.printf("ThrowableHandler: stack is TOP, cannot be analyzed. %s:%d%n", detector.getClassName(), detector.getPC());
            return;
        }
        if (seen == 187 && JavaType.from(detector.getClassConstantOperand()).isThrowable()) {
            OpcodeStack.Item createdThrowable = stack.getStackItem(0);
            createdThrowable.setUserValue((Object)IS_THROWABLE);
        } else if (seen == 185 || seen == 182 || seen == 183 || seen == 184) {
            String signature = detector.getMethodDescriptorOperand().getSignature();
            String returnType = signature.substring(1 + signature.lastIndexOf(41));
            if (!returnType.startsWith("L")) {
                return;
            }
            if (JavaType.from(returnType = returnType.substring(1, returnType.length() - 1).replaceAll("/", ".")).isThrowable()) {
                OpcodeStack.Item returnedThrowable = stack.getStackItem(0);
                returnedThrowable.setUserValue((Object)IS_THROWABLE);
            }
        } else if (seen == 25 || seen == 42 || seen == 43 || seen == 44 || seen == 45) {
            JavaType typeOfLocalVar = this.loadLocalVar(detector);
            if (typeOfLocalVar != null && typeOfLocalVar.isThrowable() || this.isThrowable.get(this.indexOfLocalVariable(detector, seen))) {
                OpcodeStack.Item localThrowable = stack.getStackItem(0);
                localThrowable.setUserValue((Object)IS_THROWABLE);
            }
        } else if ((seen == 180 || seen == 178) && (type = Type.getType((String)(targetField = detector.getFieldDescriptorOperand()).getSignature())) != null && (javaType = JavaType.from(type)) != null && javaType.isThrowable()) {
            OpcodeStack.Item localThrowable = stack.getStackItem(0);
            localThrowable.setUserValue((Object)IS_THROWABLE);
        }
    }

    private int indexOfLocalVariable(OpcodeStackDetector detector, int seen) {
        switch (seen) {
            case 42: 
            case 75: {
                return 0;
            }
            case 43: 
            case 76: {
                return 1;
            }
            case 44: 
            case 77: {
                return 2;
            }
            case 45: 
            case 78: {
                return 3;
            }
            case 25: 
            case 58: {
                return detector.getIntConstant();
            }
        }
        throw new IllegalArgumentException("Unknown opcode to load data from local variable" + seen);
    }

    private JavaType loadLocalVar(OpcodeStackDetector detector) {
        Type[] arguments;
        int index = detector.getRegisterOperand();
        boolean isStaticMethod = detector.getMethodDescriptor().isStatic();
        if (!isStaticMethod) {
            if (index == 0) {
                return JavaType.from(detector.getThisClass());
            }
            --index;
        }
        if (index >= (arguments = detector.getMethod().getArgumentTypes()).length) {
            return null;
        }
        if (index < 0) {
            String dump = detector.getMethod().getCode().toString();
            int pc = detector.getPC();
            throw new IllegalArgumentException(String.format("Illegal index %d at PC %d. Please report this dump:%n%s", index, pc, dump));
        }
        return JavaType.from(arguments[index]);
    }

    public boolean checkThrowable(OpcodeStack.Item stackItem) {
        return IS_THROWABLE.equals(stackItem.getUserValue());
    }

    public void visitMethod() {
        this.isThrowable.clear();
    }
}

