/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.findbugs.slf4j.parameter;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import javax.annotation.Nonnull;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class ThrowableHandler {
    @Nonnull
    private static final JavaClass THROWABLE;

    public boolean checkThrowable(OpcodeStack.Item stackItem) {
        try {
            JavaClass typeOfStack = stackItem.getJavaClass();
            if (typeOfStack == null) {
                return false;
            }
            return typeOfStack.instanceOf(THROWABLE);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            return false;
        }
    }

    static {
        try {
            THROWABLE = Repository.lookupClass(Throwable.class);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)"Unreachable");
        }
    }
}

