/*
 * Decompiled with CFR 0.152.
 */
package me.paulschwarz.springdotenv;

import java.util.Objects;
import java.util.Optional;
import me.paulschwarz.springdotenv.DotenvConfig;
import me.paulschwarz.springdotenv.DotenvConfigProperties;
import me.paulschwarz.springdotenv.DotenvPropertyLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.log.LogMessage;

public class DotenvPropertySource
extends PropertySource<DotenvPropertyLoader> {
    private static final Log log = LogFactory.getLog(DotenvPropertySource.class);
    public static final String DOTENV_PROPERTY_SOURCE_NAME = "env";
    private static final String DEFAULT_PREFIX = "";
    private String prefix;

    public DotenvPropertySource(String name, DotenvConfig dotenvConfig) {
        super(name, (Object)new DotenvPropertyLoader(dotenvConfig));
    }

    public DotenvPropertySource(DotenvConfig dotenvConfig) {
        this(DOTENV_PROPERTY_SOURCE_NAME, dotenvConfig);
        this.prefix = Optional.ofNullable(dotenvConfig.getPrefix()).orElse(DEFAULT_PREFIX);
        if (!DEFAULT_PREFIX.equals(this.prefix)) {
            LogMessage warning = LogMessage.format((String)"spring-dotenv: Using a prefix is DEPRECATED as of spring-dotenv version 3.%nspring-dotenv: You are using the prefix \"%1$s\".%nspring-dotenv: Please convert all usages of ${%1$sEXAMPLE} to ${EXAMPLE} and remove prefix=%1$s from your .env.properties file.", (Object)this.prefix);
            if (dotenvConfig.suppressPrefixDeprecationWarning()) {
                log.warn((Object)warning);
            } else {
                System.err.println(warning);
            }
        }
    }

    public Object getProperty(String name) {
        if (!name.startsWith(this.prefix)) {
            return null;
        }
        Object value = ((DotenvPropertyLoader)this.getSource()).getValue(name.substring(this.prefix.length()));
        if (Objects.nonNull(value)) {
            log.trace((Object)LogMessage.format((String)"Got env property for \"%s\"", (Object)name));
        }
        return value;
    }

    public static void addToEnvironment(ConfigurableEnvironment environment) {
        DotenvConfig dotenvConfig = new DotenvConfig(DotenvConfigProperties.loadProperties());
        DotenvPropertySource dotenvPropertySource = new DotenvPropertySource(dotenvConfig);
        log.info((Object)LogMessage.format((String)"Initialized Dotenv with %s", (Object)dotenvConfig));
        if (dotenvConfig.systemProperties()) {
            log.trace((Object)"Dotenv environment available as system properties");
        } else {
            environment.getPropertySources().addAfter("systemEnvironment", (PropertySource)dotenvPropertySource);
            log.trace((Object)"DotenvPropertySource added to Environment");
        }
    }
}

