/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.BunchOfResourcesType;

public class BunchOfResourcesEntry {
    private List<String> resourcesPaths = new ArrayList<String>();
    private BunchOfResourcesType type = BunchOfResourcesType.CONVENTIONALLY_NAMED_FILES;
    private Long version;
    private String description;
    private Boolean splitByLine;
    private Boolean transactional;
    private Boolean premigration;
    private Boolean substitute;

    public List<String> getResourcesPaths() {
        return this.resourcesPaths;
    }

    public void setResourcesPaths(List<String> resourcesPaths) {
        this.resourcesPaths = resourcesPaths;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcesPaths = Collections.singletonList(resourcePath);
    }

    public String getResourcePath() {
        return this.resourcesPaths.get(0);
    }

    public BunchOfResourcesType getType() {
        return this.type;
    }

    public void setType(BunchOfResourcesType type) {
        this.type = type;
    }

    public Boolean getSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(Boolean substitute) {
        this.substitute = substitute;
    }

    public String toString() {
        return "BunchOfResourcesEntry{resourcesPaths=" + this.resourcesPaths + ", type=" + this.type + "}";
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
        this.type = BunchOfResourcesType.JUST_FILE;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getSplitByLine() {
        return this.splitByLine;
    }

    public void setSplitByLine(Boolean splitByLine) {
        this.splitByLine = splitByLine;
    }

    public Boolean getTransactional() {
        return this.transactional;
    }

    public void setTransactional(Boolean transactional) {
        this.transactional = transactional;
    }

    public Boolean getPremigration() {
        return this.premigration;
    }

    public void setPremigration(Boolean premigration) {
        this.premigration = premigration;
    }

    public static BunchOfResourcesEntry ofConventionallyNamedFiles(String ... resourcesPaths) {
        BunchOfResourcesEntry e = new BunchOfResourcesEntry();
        e.setType(BunchOfResourcesType.CONVENTIONALLY_NAMED_FILES);
        e.setResourcesPaths(Arrays.stream(resourcesPaths).toList());
        return e;
    }

    public static BunchOfResourcesEntry ofJustFile(long version, String description, String resourcePath, boolean substitute) {
        BunchOfResourcesEntry e = new BunchOfResourcesEntry();
        e.setVersion(version);
        e.setResourcePath(resourcePath);
        e.setDescription(description);
        e.setSubstitute(substitute);
        return e;
    }
}

