/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import name.nkonev.r2dbc.migrate.reader.MigrateResource;
import reactor.core.publisher.Flux;

public abstract class FileReader {
    public static Flux<String> readChunked(MigrateResource resource, Charset fileCharset) {
        return Flux.using(() -> new BufferedReader(new InputStreamReader(resource.getInputStream(), fileCharset)), bufferedReader -> Flux.fromStream(bufferedReader.lines()), bufferedReader -> {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static String read(MigrateResource resource, Charset fileCharset) {
        String string;
        block8: {
            InputStream inputStream = resource.getInputStream();
            try {
                string = new String(inputStream.readAllBytes(), fileCharset);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error during reading file '" + resource.getFilename() + "'", e);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

