/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Statement;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.MigrationMetadata;
import name.nkonev.r2dbc.migrate.core.SqlQueries;
import name.nkonev.r2dbc.migrate.core.StringUtils;

public class MSSqlQueries
implements SqlQueries {
    private final String migrationsSchema;
    private final String migrationsTable;

    public MSSqlQueries(String migrationsSchema, String migrationsTable) {
        this.migrationsSchema = migrationsSchema;
        this.migrationsTable = migrationsTable;
    }

    private boolean schemaIsDefined() {
        return !StringUtils.isEmpty(this.migrationsSchema);
    }

    private String quoteAsString(String input) {
        return "'" + input + "'";
    }

    private String quoteAsObject(String input) {
        return "\"" + input + "\"";
    }

    private String withMigrationsTable(String template) {
        if (this.schemaIsDefined()) {
            return String.format(template, this.quoteAsObject(this.migrationsSchema) + "." + this.quoteAsObject(this.migrationsTable));
        }
        return String.format(template, this.quoteAsObject(this.migrationsTable));
    }

    @Override
    public List<String> createInternalTables() {
        if (this.schemaIsDefined()) {
            return List.of(String.format("if not exists (select * from sys.tables t join sys.schemas s on (t.schema_id = s.schema_id) where s.name = %s and t.name = %s) ", this.quoteAsString(this.migrationsSchema), this.quoteAsString(this.migrationsTable)) + String.format("create table %s.%s (id bigint primary key, description text)", this.quoteAsObject(this.migrationsSchema), this.quoteAsObject(this.migrationsTable)));
        }
        return List.of(String.format("if not exists (SELECT 1 FROM sys.Tables WHERE Name = N%s AND Type = N'U') ", this.quoteAsString(this.migrationsTable)) + String.format("create table %s (id bigint primary key, description text)", this.quoteAsObject(this.migrationsTable)));
    }

    @Override
    public String getMaxMigration() {
        return this.withMigrationsTable("select max(id) from %s");
    }

    public String insertMigration() {
        return this.withMigrationsTable("insert into %s(id, description) values (@id, @descr)");
    }

    @Override
    public Statement createInsertMigrationStatement(Connection connection, MigrationMetadata migrationInfo) {
        return connection.createStatement(this.insertMigration()).bind("@id", (Object)migrationInfo.getVersion()).bind("@descr", (Object)migrationInfo.getDescription());
    }
}

