/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Statement;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.AbstractTableLocker;
import name.nkonev.r2dbc.migrate.core.Locker;
import name.nkonev.r2dbc.migrate.core.StringUtils;

public class MSSqlTableLocker
extends AbstractTableLocker
implements Locker {
    private final String migrationsSchema;
    private final String migrationsLockTable;

    public MSSqlTableLocker(String migrationsSchema, String migrationsLockTable) {
        this.migrationsSchema = migrationsSchema;
        this.migrationsLockTable = migrationsLockTable;
    }

    private boolean schemaIsDefined() {
        return !StringUtils.isEmpty(this.migrationsSchema);
    }

    private String quoteAsString(String input) {
        return "'" + input + "'";
    }

    private String quoteAsObject(String input) {
        return "\"" + input + "\"";
    }

    private String withMigrationsLockTable(String template) {
        if (this.schemaIsDefined()) {
            return String.format(template, this.quoteAsObject(this.migrationsSchema) + "." + this.quoteAsObject(this.migrationsLockTable));
        }
        return String.format(template, this.quoteAsObject(this.migrationsLockTable));
    }

    @Override
    public List<String> createInternalTables() {
        if (this.schemaIsDefined()) {
            return List.of(String.format("if not exists (select * from sys.tables t join sys.schemas s on (t.schema_id = s.schema_id) where s.name = %s and t.name = %s) ", this.quoteAsString(this.migrationsSchema), this.quoteAsString(this.migrationsLockTable)) + String.format("create table %s.%s (id int primary key, locked bit not null)", this.quoteAsObject(this.migrationsSchema), this.quoteAsObject(this.migrationsLockTable)), String.format("if not exists (select * from %s.%s where id = 1) ", this.quoteAsObject(this.migrationsSchema), this.quoteAsObject(this.migrationsLockTable)) + String.format("insert into %s.%s(id, locked) values (1, 'false')", this.quoteAsObject(this.migrationsSchema), this.quoteAsObject(this.migrationsLockTable)));
        }
        return List.of(String.format("if not exists (SELECT 1 FROM sys.Tables WHERE Name = N%s AND Type = N'U') ", this.quoteAsString(this.migrationsLockTable)) + String.format("create table %s (id int primary key, locked bit not null)", this.quoteAsObject(this.migrationsLockTable)), String.format("if not exists (select * from %s where id = 1) ", this.quoteAsObject(this.migrationsLockTable)) + String.format("insert into %s (id, locked) values (1, 'false')", this.quoteAsObject(this.migrationsLockTable)));
    }

    @Override
    public Statement tryAcquireLock(Connection connection) {
        return connection.createStatement(this.withMigrationsLockTable("update %s set locked = 'true' where id = 1 and locked = 'false'"));
    }

    @Override
    public Statement releaseLock(Connection connection) {
        return connection.createStatement(this.withMigrationsLockTable("update %s set locked = 'false' where id = 1"));
    }
}

