/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Statement;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.AbstractTableLocker;
import name.nkonev.r2dbc.migrate.core.Locker;
import name.nkonev.r2dbc.migrate.core.StringUtils;

public class MariadbTableLocker
extends AbstractTableLocker
implements Locker {
    private final String migrationsSchema;
    private final String migrationsLockTable;

    public MariadbTableLocker(String migrationsSchema, String migrationsLockTable) {
        this.migrationsSchema = migrationsSchema;
        this.migrationsLockTable = migrationsLockTable;
    }

    private boolean schemaIsDefined() {
        return !StringUtils.isEmpty(this.migrationsSchema);
    }

    private String quoteAsObject(String input) {
        return "`" + input + "`";
    }

    private String withMigrationsLockTable(String template) {
        if (this.schemaIsDefined()) {
            return String.format(template, this.quoteAsObject(this.migrationsSchema) + "." + this.quoteAsObject(this.migrationsLockTable));
        }
        return String.format(template, this.quoteAsObject(this.migrationsLockTable));
    }

    @Override
    public List<String> createInternalTables() {
        return List.of(this.withMigrationsLockTable("create table if not exists %s(id int primary key, locked boolean not null)"), this.withMigrationsLockTable("insert ignore into %s(id, locked) values (1, false)"));
    }

    @Override
    public Statement tryAcquireLock(Connection connection) {
        return connection.createStatement(this.withMigrationsLockTable("update %s set locked = true where id = 1 and locked = false"));
    }

    @Override
    public Statement releaseLock(Connection connection) {
        return connection.createStatement(this.withMigrationsLockTable("update %s set locked = false where id = 1"));
    }
}

