/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Statement;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.MigrationMetadata;
import name.nkonev.r2dbc.migrate.core.SqlQueries;
import name.nkonev.r2dbc.migrate.core.StringUtils;

public class MySqlQueries
implements SqlQueries {
    private final String migrationsSchema;
    private final String migrationsTable;

    public MySqlQueries(String migrationsSchema, String migrationsTable) {
        this.migrationsSchema = migrationsSchema;
        this.migrationsTable = migrationsTable;
    }

    private boolean schemaIsDefined() {
        return !StringUtils.isEmpty(this.migrationsSchema);
    }

    private String quoteAsObject(String input) {
        return "`" + input + "`";
    }

    private String withMigrationsTable(String template) {
        if (this.schemaIsDefined()) {
            return String.format(template, this.quoteAsObject(this.migrationsSchema) + "." + this.quoteAsObject(this.migrationsTable));
        }
        return String.format(template, this.quoteAsObject(this.migrationsTable));
    }

    @Override
    public List<String> createInternalTables() {
        return List.of(this.withMigrationsTable("create table if not exists %s(id bigint primary key, description text)"));
    }

    @Override
    public String getMaxMigration() {
        return this.withMigrationsTable("select max(id) as max from %s");
    }

    public String insertMigration() {
        return this.withMigrationsTable("insert into %s(id, description) values (?id, ?descr)");
    }

    @Override
    public Statement createInsertMigrationStatement(Connection connection, MigrationMetadata migrationInfo) {
        return connection.createStatement(this.insertMigration()).bind("id", (Object)migrationInfo.getVersion()).bind("descr", (Object)migrationInfo.getDescription());
    }
}

