/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.Locker;
import name.nkonev.r2dbc.migrate.core.R2dbcMigrate;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class MySqlSessionLocker
implements Locker {
    private static final Logger LOGGER = Loggers.getLogger(MySqlSessionLocker.class);
    private final String lockname;
    private final int timeout;

    public MySqlSessionLocker(String migrationsSchema, String migrationsLockTable) {
        this.lockname = migrationsSchema + "." + migrationsLockTable;
        this.timeout = 5;
    }

    public MySqlSessionLocker(String migrationsSchema, String migrationsLockTable, int timeoutSec) {
        this.lockname = migrationsSchema + "." + migrationsLockTable;
        this.timeout = timeoutSec;
    }

    @Override
    public List<String> createInternalTables() {
        return List.of();
    }

    @Override
    public Statement tryAcquireLock(Connection connection) {
        return connection.createStatement("select get_lock(?lockname, ?timeout) as lock_result").bind("lockname", (Object)this.lockname).bind("timeout", (Object)this.timeout);
    }

    @Override
    public Statement releaseLock(Connection connection) {
        return connection.createStatement("select release_lock(?lockname)").bind("lockname", (Object)this.lockname);
    }

    @Override
    public Mono<? extends Object> extractResultOrError(Mono<? extends Result> lockStatement) {
        return lockStatement.flatMap(o -> Mono.from((Publisher)o.map(R2dbcMigrate.getResultSafely("lock_result", Integer.class, 0)))).flatMap(anInteger -> {
            if (anInteger == 0) {
                return Mono.error((Throwable)new RuntimeException("False result"));
            }
            return Mono.just((Object)anInteger);
        }).doOnSuccess(aBoolean -> LOGGER.info("Acquiring database-specific lock {}", new Object[]{aBoolean}));
    }
}

