/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Statement;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.Locker;
import name.nkonev.r2dbc.migrate.core.R2dbcMigrate;
import name.nkonev.r2dbc.migrate.core.StringUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class PostgreSqlAdvisoryLocker
implements Locker {
    private static final Logger LOGGER = Loggers.getLogger(PostgreSqlAdvisoryLocker.class);
    private final int migrationsSchemaHashCode;
    private final int migrationsLockTableHashCode;

    public PostgreSqlAdvisoryLocker(String migrationsSchema, String migrationsLockTable) {
        this.migrationsSchemaHashCode = (StringUtils.isEmpty(migrationsSchema) ? "42" : migrationsSchema).hashCode();
        this.migrationsLockTableHashCode = (StringUtils.isEmpty(migrationsLockTable) ? "43" : migrationsLockTable).hashCode();
    }

    @Override
    public List<String> createInternalTables() {
        return List.of();
    }

    @Override
    public Statement tryAcquireLock(Connection connection) {
        return connection.createStatement("select pg_try_advisory_lock($1, $2) as lock_result").bind("$1", (Object)this.migrationsSchemaHashCode).bind("$2", (Object)this.migrationsLockTableHashCode);
    }

    @Override
    public Statement releaseLock(Connection connection) {
        return connection.createStatement("select pg_advisory_unlock($1, $2)").bind("$1", (Object)this.migrationsSchemaHashCode).bind("$2", (Object)this.migrationsLockTableHashCode);
    }

    @Override
    public Mono<? extends Object> extractResultOrError(Mono<? extends Result> lockStatement) {
        return lockStatement.flatMap(o -> Mono.from((Publisher)o.map(R2dbcMigrate.getResultSafely("lock_result", Boolean.class, false)))).flatMap(aBoolean -> {
            if (!aBoolean.booleanValue()) {
                return Mono.error((Throwable)new RuntimeException("False result"));
            }
            return Mono.just((Object)aBoolean);
        }).doOnSuccess(aBoolean -> LOGGER.info("Acquiring database-specific lock {}", new Object[]{aBoolean}));
    }
}

