/*
 * Decompiled with CFR 0.152.
 */
package name.nkonev.r2dbc.migrate.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.nkonev.r2dbc.migrate.core.BunchOfResourcesEntry;
import name.nkonev.r2dbc.migrate.core.BunchOfResourcesType;
import name.nkonev.r2dbc.migrate.core.Dialect;

public class R2dbcMigrateProperties {
    private boolean enable = true;
    private long connectionMaxRetries = 500L;
    private List<BunchOfResourcesEntry> resources = new ArrayList<BunchOfResourcesEntry>();
    private int chunkSize = 1000;
    private Dialect dialect;
    private String validationQuery = "select '42' as validation_result";
    private String validationQueryExpectedResultValue = "42";
    private Duration validationQueryTimeout = Duration.ofSeconds(5L);
    private Duration validationRetryDelay = Duration.ofSeconds(1L);
    private Duration acquireLockRetryDelay = Duration.ofSeconds(1L);
    private long acquireLockMaxRetries = 100L;
    private Charset fileCharset = StandardCharsets.UTF_8;
    private boolean waitForDatabase = true;
    private String migrationsSchema;
    private String migrationsTable = "migrations";
    private String migrationsLockTable = "migrations_lock";
    private boolean preferDbSpecificLock = true;
    private boolean useEnvironmentSubstitutor = true;
    private boolean useSystemPropertiesSubstitutor = true;

    public List<BunchOfResourcesEntry> getResources() {
        return this.resources;
    }

    public void setResources(List<BunchOfResourcesEntry> resources) {
        this.resources = resources;
    }

    public void setResourcesPath(String resourcesPath) {
        BunchOfResourcesEntry entry = new BunchOfResourcesEntry();
        entry.setType(BunchOfResourcesType.CONVENTIONALLY_NAMED_FILES);
        entry.setResourcesPaths(Collections.singletonList(resourcesPath));
        this.resources = Collections.singletonList(entry);
    }

    public long getConnectionMaxRetries() {
        return this.connectionMaxRetries;
    }

    public void setConnectionMaxRetries(long connectionMaxRetries) {
        this.connectionMaxRetries = connectionMaxRetries;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public Duration getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(Duration validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    public Duration getValidationRetryDelay() {
        return this.validationRetryDelay;
    }

    public void setValidationRetryDelay(Duration validationRetryDelay) {
        this.validationRetryDelay = validationRetryDelay;
    }

    public Duration getAcquireLockRetryDelay() {
        return this.acquireLockRetryDelay;
    }

    public void setAcquireLockRetryDelay(Duration acquireLockRetryDelay) {
        this.acquireLockRetryDelay = acquireLockRetryDelay;
    }

    public long getAcquireLockMaxRetries() {
        return this.acquireLockMaxRetries;
    }

    public void setAcquireLockMaxRetries(long acquireLockMaxRetries) {
        this.acquireLockMaxRetries = acquireLockMaxRetries;
    }

    public Charset getFileCharset() {
        return this.fileCharset;
    }

    public void setFileCharset(Charset fileCharset) {
        this.fileCharset = fileCharset;
    }

    public String getValidationQueryExpectedResultValue() {
        return this.validationQueryExpectedResultValue;
    }

    public void setValidationQueryExpectedResultValue(String validationQueryExpectedResultValue) {
        this.validationQueryExpectedResultValue = validationQueryExpectedResultValue;
    }

    public boolean isWaitForDatabase() {
        return this.waitForDatabase;
    }

    public void setWaitForDatabase(boolean waitForDatabase) {
        this.waitForDatabase = waitForDatabase;
    }

    public String getMigrationsTable() {
        return this.migrationsTable;
    }

    public void setMigrationsTable(String migrationsTable) {
        this.migrationsTable = migrationsTable;
    }

    public String getMigrationsLockTable() {
        return this.migrationsLockTable;
    }

    public void setMigrationsLockTable(String migrationsLockTable) {
        this.migrationsLockTable = migrationsLockTable;
    }

    public String getMigrationsSchema() {
        return this.migrationsSchema;
    }

    public void setMigrationsSchema(String migrationsSchema) {
        this.migrationsSchema = migrationsSchema;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isPreferDbSpecificLock() {
        return this.preferDbSpecificLock;
    }

    public void setPreferDbSpecificLock(boolean preferDbSpecificLock) {
        this.preferDbSpecificLock = preferDbSpecificLock;
    }

    public boolean isUseEnvironmentSubstitutor() {
        return this.useEnvironmentSubstitutor;
    }

    public void setUseEnvironmentSubstitutor(boolean useEnvironmentSubstitutor) {
        this.useEnvironmentSubstitutor = useEnvironmentSubstitutor;
    }

    public boolean isUseSystemPropertiesSubstitutor() {
        return this.useSystemPropertiesSubstitutor;
    }

    public void setUseSystemPropertiesSubstitutor(boolean useSystemPropertiesSubstitutor) {
        this.useSystemPropertiesSubstitutor = useSystemPropertiesSubstitutor;
    }

    public String toString() {
        return "R2dbcMigrateProperties{enable=" + this.enable + ", connectionMaxRetries=" + this.connectionMaxRetries + ", resources.size=" + this.resources.size() + ", chunkSize=" + this.chunkSize + ", dialect=" + this.dialect + ", validationQuery='" + this.validationQuery + "', validationQueryExpectedResultValue='" + this.validationQueryExpectedResultValue + "', validationQueryTimeout=" + this.validationQueryTimeout + ", validationRetryDelay=" + this.validationRetryDelay + ", acquireLockRetryDelay=" + this.acquireLockRetryDelay + ", acquireLockMaxRetries=" + this.acquireLockMaxRetries + ", fileCharset=" + this.fileCharset + ", waitForDatabase=" + this.waitForDatabase + ", migrationsSchema='" + this.migrationsSchema + "', migrationsTable='" + this.migrationsTable + "', migrationsLockTable='" + this.migrationsLockTable + "', preferDbSpecificLock='" + this.preferDbSpecificLock + "', useEnvironmentSubstitutor='" + this.useEnvironmentSubstitutor + "', useSystemPropertiesSubstitutor='" + this.useSystemPropertiesSubstitutor + "'}";
    }
}

