/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes;

import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import java.util.Random;
import org.apache.spark.graphx.Graph;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SQLContext$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.InvalidPatternException;
import org.graphframes.Logging;
import org.graphframes.Logging$class;
import org.graphframes.lib.GraphXConversions$;
import org.graphframes.pattern.AnonymousEdge;
import org.graphframes.pattern.AnonymousVertex$;
import org.graphframes.pattern.Edge;
import org.graphframes.pattern.NamedEdge;
import org.graphframes.pattern.NamedVertex;
import org.graphframes.pattern.Negation;
import org.graphframes.pattern.Pattern;
import org.graphframes.pattern.Vertex;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GraphFrame$
implements Serializable,
Logging {
    public static final GraphFrame$ MODULE$;
    private final String ID;
    private final String SRC;
    private final String DST;
    private final String EDGE;
    private final String ATTR;
    private final String LONG_ID;
    private final String LONG_SRC;
    private final String LONG_DST;
    private final String GX_ATTR;
    private final Random random;
    private int _broadcastThreshold;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new GraphFrame$();
    }

    @Override
    public void logDebug(String s) {
        Logging$class.logDebug(this, s);
    }

    @Override
    public void logInfo(String s) {
        Logging$class.logInfo(this, s);
    }

    @Override
    public void logTrace(String s) {
        Logging$class.logTrace(this, s);
    }

    private Logger logger$lzycompute() {
        GraphFrame$ graphFrame$ = this;
        synchronized (graphFrame$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> Dataset<Row> skewedJoin(Dataset<Row> a, Dataset<Row> b, String joinCol, Set<T> hubs, String logPrefix, TypeTags.TypeTag<T> evidence$1) {
        Dataset dataset;
        SQLContext sqlContext = a.sqlContext();
        if (hubs.isEmpty()) {
            dataset = a.join(b, joinCol);
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Skewed join with ", " high-degree keys."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logPrefix, BoxesRunTime.boxToInteger((int)hubs.size())})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            UserDefinedFunction isHub = functions$.MODULE$.udf((Function1)new Serializable(hubs){
                public static final long serialVersionUID = 0L;
                private final Set hubs$1;

                public final boolean apply(T id) {
                    return this.hubs$1.contains(id);
                }
                {
                    this.hubs$1 = hubs$1;
                }
            }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean(), evidence$1);
            Dataset hashJoined = a.filter(isHub.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(joinCol)})).unary_$bang()).join(b.filter(isHub.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(joinCol)})).unary_$bang()), joinCol);
            Dataset broadcastJoined = a.filter(isHub.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(joinCol)}))).join(functions$.MODULE$.broadcast(b.filter(isHub.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(joinCol)})))), joinCol);
            dataset = hashJoined.unionAll(broadcastJoined);
        }
        return dataset;
    }

    public String ID() {
        return this.ID;
    }

    public String SRC() {
        return this.SRC;
    }

    public String DST() {
        return this.DST;
    }

    public String EDGE() {
        return this.EDGE;
    }

    public GraphFrame apply(Dataset<Row> vertices, Dataset<Row> edges) {
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])vertices.columns()).contains((Object)this.ID()), (Function0)new Serializable(vertices){
            public static final long serialVersionUID = 0L;
            private final Dataset vertices$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vertex ID column '", "' missing from vertex DataFrame, which has columns: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GraphFrame$.MODULE$.ID()}))).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.vertices$1.columns()).mkString(",")).toString();
            }
            {
                this.vertices$1 = vertices$1;
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])edges.columns()).contains((Object)this.SRC()), (Function0)new Serializable(edges){
            public static final long serialVersionUID = 0L;
            private final Dataset edges$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source vertex ID column '", "' missing from edge DataFrame, which has columns: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GraphFrame$.MODULE$.SRC()}))).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.edges$1.columns()).mkString(",")).toString();
            }
            {
                this.edges$1 = edges$1;
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])edges.columns()).contains((Object)this.DST()), (Function0)new Serializable(edges){
            public static final long serialVersionUID = 0L;
            private final Dataset edges$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Destination vertex ID column '", "' missing from edge DataFrame, which has columns: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GraphFrame$.MODULE$.DST()}))).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.edges$1.columns()).mkString(",")).toString();
            }
            {
                this.edges$1 = edges$1;
            }
        });
        return new GraphFrame(vertices, edges);
    }

    public GraphFrame fromEdges(Dataset<Row> e) {
        Dataset srcs = e.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{e.apply("src").as("id")}));
        Dataset dsts = e.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{e.apply("dst").as("id")}));
        Dataset v = srcs.unionAll(dsts).distinct();
        v.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        return this.apply((Dataset<Row>)v, e);
    }

    public <VD, ED> GraphFrame fromGraphX(Graph<VD, ED> graph, TypeTags.TypeTag<VD> evidence$2, TypeTags.TypeTag<ED> evidence$3) {
        SQLContext sqlContext = SQLContext$.MODULE$.getOrCreate(graph.vertices().context());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_GraphFrame$$typecreator1$1
        extends TypeCreator {
            private final TypeTags.TypeTag evidence$2$1;

            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.graphx").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.graphx.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("org.apache.spark.graphx.package").asModule().moduleClass(), "VertexId"), (List)Nil$.MODULE$), this.evidence$2$1.in($m).tpe()})));
            }

            public Org_graphframes_GraphFrame$$typecreator1$1(TypeTags.TypeTag evidence$2$1) {
                this.evidence$2$1 = evidence$2$1;
            }
        }
        Dataset vv = sqlContext.createDataFrame((RDD)graph.vertices(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_graphframes_GraphFrame$$typecreator1$1(evidence$2))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ID(), this.ATTR()}));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_GraphFrame$$typecreator2$1
        extends TypeCreator {
            private final TypeTags.TypeTag evidence$3$1;

            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.graphx").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.graphx.Edge"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{this.evidence$3$1.in($m).tpe()})));
            }

            public Org_graphframes_GraphFrame$$typecreator2$1(TypeTags.TypeTag evidence$3$1) {
                this.evidence$3$1 = evidence$3$1;
            }
        }
        Dataset ee = sqlContext.createDataFrame((RDD)graph.edges(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_graphframes_GraphFrame$$typecreator2$1(evidence$3))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SRC(), this.DST(), this.ATTR()}));
        return this.apply((Dataset<Row>)vv, (Dataset<Row>)ee);
    }

    public <V, E> GraphFrame fromGraphX(GraphFrame originalGraph, Graph<V, E> graph, Seq<String> vertexNames, Seq<String> edgeNames2, TypeTags.TypeTag<V> evidence$4, TypeTags.TypeTag<E> evidence$5) {
        return GraphXConversions$.MODULE$.fromGraphX(originalGraph, graph, vertexNames, edgeNames2, evidence$4, evidence$5);
    }

    public <V, E> Seq<String> fromGraphX$default$3() {
        return Nil$.MODULE$;
    }

    public <V, E> Seq<String> fromGraphX$default$4() {
        return Nil$.MODULE$;
    }

    public String ATTR() {
        return this.ATTR;
    }

    public String LONG_ID() {
        return this.LONG_ID;
    }

    public String LONG_SRC() {
        return this.LONG_SRC;
    }

    public String LONG_DST() {
        return this.LONG_DST;
    }

    public String GX_ATTR() {
        return this.GX_ATTR;
    }

    public Seq<String> colStar(Dataset<Row> df, String col) {
        DataType dataType = df.schema().apply(col).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])structType.fieldNames()).map((Function1)new Serializable(col){
                public static final long serialVersionUID = 0L;
                private final String col$1;

                public final String apply(String f) {
                    return new StringBuilder().append((Object)this.col$1).append((Object)".").append((Object)f).toString();
                }
                {
                    this.col$1 = col$1;
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            return seq;
        }
        throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown error in GraphFrame. Expected column ", " to be"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" StructType, but found type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType}))).toString());
    }

    public Column nestAsCol(Dataset<Row> df, String name) {
        return functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])df.columns()).map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;

            public final Column apply(String c) {
                return this.df$1.apply(c);
            }
            {
                this.df$1 = df$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).as(name);
    }

    private Random random() {
        return this.random;
    }

    private String prefixWithName(String name, String col) {
        return new StringBuilder().append((Object)name).append((Object)".").append((Object)col).toString();
    }

    public String org$graphframes$GraphFrame$$vId(String name) {
        return this.prefixWithName(name, this.ID());
    }

    public String org$graphframes$GraphFrame$$eSrcId(String name) {
        return this.prefixWithName(name, this.SRC());
    }

    public String org$graphframes$GraphFrame$$eDstId(String name) {
        return this.prefixWithName(name, this.DST());
    }

    private Dataset<Row> maybeJoin(Option<Dataset<Row>> aOpt, Dataset<Row> b) {
        Option<Dataset<Row>> option;
        block4: {
            Dataset dataset;
            block3: {
                block2: {
                    option = aOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Dataset a = (Dataset)some.x();
                    dataset = a.join(b);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                dataset = b;
            }
            return dataset;
        }
        throw new MatchError(option);
    }

    private Dataset<Row> maybeJoin(Option<Dataset<Row>> aOpt, Dataset<Row> b, Function1<Dataset<Row>, Column> joinExprs) {
        Option<Dataset<Row>> option;
        block4: {
            Dataset dataset;
            block3: {
                block2: {
                    option = aOpt;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Dataset a = (Dataset)some.x();
                    dataset = a.join(b, (Column)joinExprs.apply((Object)a));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                dataset = b;
            }
            return dataset;
        }
        throw new MatchError(option);
    }

    private boolean seen(NamedVertex v, Seq<Pattern> patterns) {
        return patterns.exists((Function1)new Serializable(v){
            public static final long serialVersionUID = 0L;
            private final NamedVertex v$1;

            public final boolean apply(Pattern p) {
                return GraphFrame$.MODULE$.org$graphframes$GraphFrame$$seen1(this.v$1, p);
            }
            {
                this.v$1 = v$1;
            }
        });
    }

    public boolean org$graphframes$GraphFrame$$seen1(NamedVertex v, Pattern pattern) {
        Pattern pattern2;
        block11: {
            boolean bl;
            block9: {
                block10: {
                    NamedVertex namedVertex;
                    while (true) {
                        if ((pattern2 = pattern) instanceof Negation) {
                            Negation negation = (Negation)pattern2;
                            Edge edge = negation.child();
                            pattern = edge;
                            continue;
                        }
                        if (pattern2 instanceof AnonymousEdge) {
                            AnonymousEdge anonymousEdge = (AnonymousEdge)pattern2;
                            Vertex src = anonymousEdge.src();
                            Vertex dst = anonymousEdge.dst();
                            if (this.org$graphframes$GraphFrame$$seen1(v, src)) {
                                bl = true;
                                break block9;
                            }
                            pattern = dst;
                            continue;
                        }
                        if (!(pattern2 instanceof NamedEdge)) break;
                        NamedEdge namedEdge = (NamedEdge)pattern2;
                        Vertex src = namedEdge.src();
                        Vertex dst = namedEdge.dst();
                        if (this.org$graphframes$GraphFrame$$seen1(v, src)) {
                            bl = true;
                            break block9;
                        }
                        pattern = dst;
                    }
                    if (!(pattern2 instanceof NamedVertex)) break block10;
                    NamedVertex namedVertex2 = namedVertex = (NamedVertex)pattern2;
                    NamedVertex namedVertex3 = v;
                    bl = !(namedVertex2 != null ? !((Object)namedVertex2).equals(namedVertex3) : namedVertex3 != null);
                    break block9;
                }
                if (!AnonymousVertex$.MODULE$.equals(pattern2)) break block11;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)pattern2);
    }

    public Tuple2<Option<Dataset<Row>>, Seq<String>> org$graphframes$GraphFrame$$findIncremental(GraphFrame gf, Seq<Pattern> prevPatterns, Option<Dataset<Row>> prev, Seq<String> prevNames, Pattern pattern) {
        Pattern pattern2;
        block24: {
            Option<Dataset<Row>> option;
            block25: {
                Tuple2<Option<Dataset<Row>>, Seq<String>> tuple2;
                block26: {
                    Tuple2 tuple22;
                    block11: {
                        Tuple2 tuple23;
                        Tuple2 tuple24;
                        block22: {
                            Tuple2<Option<Dataset<Row>>, Seq<String>> tuple25;
                            block23: {
                                Tuple2 tuple26;
                                block16: {
                                    Tuple2.mcZZ.sp sp2;
                                    block21: {
                                        Tuple2 tuple27;
                                        block18: {
                                            String dstName;
                                            String srcName;
                                            String name;
                                            block20: {
                                                block19: {
                                                    block17: {
                                                        NamedEdge namedEdge;
                                                        boolean bl;
                                                        block15: {
                                                            Tuple2 tuple28;
                                                            block14: {
                                                                Tuple2 tuple29;
                                                                block13: {
                                                                    block12: {
                                                                        Tuple2 tuple210;
                                                                        block10: {
                                                                            bl = false;
                                                                            namedEdge = null;
                                                                            pattern2 = pattern;
                                                                            if (!AnonymousVertex$.MODULE$.equals(pattern2)) break block10;
                                                                            tuple22 = new Tuple2(prev, prevNames);
                                                                            break block11;
                                                                        }
                                                                        if (!(pattern2 instanceof NamedVertex)) break block12;
                                                                        NamedVertex namedVertex = (NamedVertex)pattern2;
                                                                        String name2 = namedVertex.name();
                                                                        if (this.seen(namedVertex, prevPatterns)) {
                                                                            prev.foreach((Function1)new Serializable(name2){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final String name$1;

                                                                                public final void apply(Dataset<Row> prev) {
                                                                                    Predef$.MODULE$.assert(Predef$.MODULE$.refArrayOps((Object[])prev.columns()).toSet().contains((Object)this.name$1));
                                                                                }
                                                                                {
                                                                                    this.name$1 = name$1;
                                                                                }
                                                                            });
                                                                            tuple210 = new Tuple2(prev, prevNames);
                                                                        } else {
                                                                            tuple210 = new Tuple2((Object)new Some(this.maybeJoin(prev, (Dataset<Row>)this.nestV$1(name2, gf))), prevNames.$colon$plus((Object)name2, Seq$.MODULE$.canBuildFrom()));
                                                                        }
                                                                        tuple22 = tuple210;
                                                                        break block11;
                                                                    }
                                                                    if (!(pattern2 instanceof NamedEdge)) break block13;
                                                                    bl = true;
                                                                    namedEdge = (NamedEdge)pattern2;
                                                                    String name3 = namedEdge.name();
                                                                    Vertex vertex = namedEdge.src();
                                                                    Vertex vertex2 = namedEdge.dst();
                                                                    if (!AnonymousVertex$.MODULE$.equals(vertex) || !AnonymousVertex$.MODULE$.equals(vertex2)) break block13;
                                                                    Dataset eRen = this.nestE$1(name3, gf);
                                                                    tuple22 = new Tuple2((Object)new Some(this.maybeJoin(prev, (Dataset<Row>)eRen)), prevNames.$colon$plus((Object)name3, Seq$.MODULE$.canBuildFrom()));
                                                                    break block11;
                                                                }
                                                                if (!bl) break block14;
                                                                String name4 = namedEdge.name();
                                                                Vertex vertex = namedEdge.src();
                                                                Vertex dst = namedEdge.dst();
                                                                if (!AnonymousVertex$.MODULE$.equals(vertex) || !(dst instanceof NamedVertex)) break block14;
                                                                NamedVertex namedVertex = (NamedVertex)dst;
                                                                String dstName2 = namedVertex.name();
                                                                if (this.seen(namedVertex, prevPatterns)) {
                                                                    Dataset eRen = this.nestE$1(name4, gf);
                                                                    tuple29 = new Tuple2((Object)new Some(this.maybeJoin(prev, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)new Serializable(name4, dstName2, eRen){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final String name$2;
                                                                        private final String dstName$1;
                                                                        private final Dataset eRen$1;

                                                                        public final Column apply(Dataset<Row> prev) {
                                                                            return this.eRen$1.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$eDstId(this.name$2)).$eq$eq$eq((Object)prev.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$vId(this.dstName$1)));
                                                                        }
                                                                        {
                                                                            this.name$2 = name$2;
                                                                            this.dstName$1 = dstName$1;
                                                                            this.eRen$1 = eRen$1;
                                                                        }
                                                                    })), prevNames.$colon$plus((Object)name4, Seq$.MODULE$.canBuildFrom()));
                                                                } else {
                                                                    Dataset eRen = this.nestE$1(name4, gf);
                                                                    Dataset dstV = this.nestV$1(dstName2, gf);
                                                                    tuple29 = new Tuple2((Object)new Some((Object)this.maybeJoin(prev, (Dataset<Row>)eRen).join(dstV, eRen.apply(this.org$graphframes$GraphFrame$$eDstId(name4)).$eq$eq$eq((Object)dstV.apply(this.org$graphframes$GraphFrame$$vId(dstName2))), "left_outer")), ((SeqLike)prevNames.$colon$plus((Object)name4, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)dstName2, Seq$.MODULE$.canBuildFrom()));
                                                                }
                                                                tuple22 = tuple29;
                                                                break block11;
                                                            }
                                                            if (!bl) break block15;
                                                            String name5 = namedEdge.name();
                                                            Vertex src = namedEdge.src();
                                                            Vertex vertex = namedEdge.dst();
                                                            if (!(src instanceof NamedVertex)) break block15;
                                                            NamedVertex namedVertex = (NamedVertex)src;
                                                            String srcName2 = namedVertex.name();
                                                            if (!AnonymousVertex$.MODULE$.equals(vertex)) break block15;
                                                            if (this.seen(namedVertex, prevPatterns)) {
                                                                Dataset eRen = this.nestE$1(name5, gf);
                                                                tuple28 = new Tuple2((Object)new Some(this.maybeJoin(prev, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)new Serializable(name5, srcName2, eRen){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final String name$3;
                                                                    private final String srcName$1;
                                                                    private final Dataset eRen$2;

                                                                    public final Column apply(Dataset<Row> prev) {
                                                                        return this.eRen$2.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$eSrcId(this.name$3)).$eq$eq$eq((Object)prev.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$vId(this.srcName$1)));
                                                                    }
                                                                    {
                                                                        this.name$3 = name$3;
                                                                        this.srcName$1 = srcName$1;
                                                                        this.eRen$2 = eRen$2;
                                                                    }
                                                                })), prevNames.$colon$plus((Object)name5, Seq$.MODULE$.canBuildFrom()));
                                                            } else {
                                                                Dataset eRen = this.nestE$1(name5, gf);
                                                                Dataset srcV = this.nestV$1(srcName2, gf);
                                                                tuple28 = new Tuple2((Object)new Some((Object)this.maybeJoin(prev, (Dataset<Row>)eRen).join(srcV, eRen.apply(this.org$graphframes$GraphFrame$$eSrcId(name5)).$eq$eq$eq((Object)srcV.apply(this.org$graphframes$GraphFrame$$vId(srcName2))))), ((SeqLike)prevNames.$colon$plus((Object)srcName2, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)name5, Seq$.MODULE$.canBuildFrom()));
                                                            }
                                                            tuple22 = tuple28;
                                                            break block11;
                                                        }
                                                        if (!bl) break block16;
                                                        name = namedEdge.name();
                                                        Vertex src = namedEdge.src();
                                                        Vertex dst = namedEdge.dst();
                                                        if (!(src instanceof NamedVertex)) break block16;
                                                        NamedVertex namedVertex = (NamedVertex)src;
                                                        srcName = namedVertex.name();
                                                        if (!(dst instanceof NamedVertex)) break block16;
                                                        NamedVertex namedVertex2 = (NamedVertex)dst;
                                                        dstName = namedVertex2.name();
                                                        sp2 = new Tuple2.mcZZ.sp(this.seen(namedVertex, prevPatterns), this.seen(namedVertex2, prevPatterns));
                                                        if (sp2 == null) break block17;
                                                        boolean bl2 = sp2._1$mcZ$sp();
                                                        boolean bl3 = sp2._2$mcZ$sp();
                                                        if (!bl2 || !bl3) break block17;
                                                        Dataset eRen = this.nestE$1(name, gf);
                                                        tuple27 = new Tuple2((Object)new Some(this.maybeJoin(prev, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)new Serializable(name, srcName, dstName, eRen){
                                                            public static final long serialVersionUID = 0L;
                                                            private final String name$4;
                                                            private final String srcName$2;
                                                            private final String dstName$2;
                                                            private final Dataset eRen$3;

                                                            public final Column apply(Dataset<Row> prev) {
                                                                return this.eRen$3.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$eSrcId(this.name$4)).$eq$eq$eq((Object)prev.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$vId(this.srcName$2))).$amp$amp((Object)this.eRen$3.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$eDstId(this.name$4)).$eq$eq$eq((Object)prev.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$vId(this.dstName$2))));
                                                            }
                                                            {
                                                                this.name$4 = name$4;
                                                                this.srcName$2 = srcName$2;
                                                                this.dstName$2 = dstName$2;
                                                                this.eRen$3 = eRen$3;
                                                            }
                                                        })), prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                                                        break block18;
                                                    }
                                                    if (sp2 == null) break block19;
                                                    boolean bl = sp2._1$mcZ$sp();
                                                    boolean bl4 = sp2._2$mcZ$sp();
                                                    if (!bl || bl4) break block19;
                                                    Dataset eRen = this.nestE$1(name, gf);
                                                    Dataset dstV = this.nestV$1(dstName, gf);
                                                    tuple27 = new Tuple2((Object)new Some((Object)this.maybeJoin(prev, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)new Serializable(name, srcName, eRen){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String name$4;
                                                        private final String srcName$2;
                                                        private final Dataset eRen$4;

                                                        public final Column apply(Dataset<Row> prev) {
                                                            return this.eRen$4.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$eSrcId(this.name$4)).$eq$eq$eq((Object)prev.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$vId(this.srcName$2)));
                                                        }
                                                        {
                                                            this.name$4 = name$4;
                                                            this.srcName$2 = srcName$2;
                                                            this.eRen$4 = eRen$4;
                                                        }
                                                    }).join(dstV, eRen.apply(this.org$graphframes$GraphFrame$$eDstId(name)).$eq$eq$eq((Object)dstV.apply(this.org$graphframes$GraphFrame$$vId(dstName))))), ((SeqLike)prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)dstName, Seq$.MODULE$.canBuildFrom()));
                                                    break block18;
                                                }
                                                if (sp2 == null) break block20;
                                                boolean bl = sp2._1$mcZ$sp();
                                                boolean bl5 = sp2._2$mcZ$sp();
                                                if (bl || !bl5) break block20;
                                                Dataset eRen = this.nestE$1(name, gf);
                                                Dataset srcV = this.nestV$1(srcName, gf);
                                                tuple27 = new Tuple2((Object)new Some((Object)this.maybeJoin(prev, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)new Serializable(name, dstName, eRen){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String name$4;
                                                    private final String dstName$2;
                                                    private final Dataset eRen$5;

                                                    public final Column apply(Dataset<Row> prev) {
                                                        return this.eRen$5.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$eDstId(this.name$4)).$eq$eq$eq((Object)prev.apply(GraphFrame$.MODULE$.org$graphframes$GraphFrame$$vId(this.dstName$2)));
                                                    }
                                                    {
                                                        this.name$4 = name$4;
                                                        this.dstName$2 = dstName$2;
                                                        this.eRen$5 = eRen$5;
                                                    }
                                                }).join(srcV, eRen.apply(this.org$graphframes$GraphFrame$$eSrcId(name)).$eq$eq$eq((Object)srcV.apply(this.org$graphframes$GraphFrame$$vId(srcName))))), ((SeqLike)prevNames.$colon$plus((Object)srcName, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                                                break block18;
                                            }
                                            if (sp2 == null) break block21;
                                            boolean bl = sp2._1$mcZ$sp();
                                            boolean bl6 = sp2._2$mcZ$sp();
                                            if (bl || bl6) break block21;
                                            Dataset eRen = this.nestE$1(name, gf);
                                            Dataset srcV = this.nestV$1(srcName, gf);
                                            Dataset dstV = this.nestV$1(dstName, gf);
                                            tuple27 = new Tuple2((Object)new Some((Object)this.maybeJoin(prev, (Dataset<Row>)eRen).join(srcV, eRen.apply(this.org$graphframes$GraphFrame$$eSrcId(name)).$eq$eq$eq((Object)srcV.apply(this.org$graphframes$GraphFrame$$vId(srcName)))).join(dstV, eRen.apply(this.org$graphframes$GraphFrame$$eDstId(name)).$eq$eq$eq((Object)dstV.apply(this.org$graphframes$GraphFrame$$vId(dstName))))), ((SeqLike)((SeqLike)prevNames.$colon$plus((Object)srcName, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)dstName, Seq$.MODULE$.canBuildFrom()));
                                        }
                                        tuple22 = tuple27;
                                        break block11;
                                    }
                                    throw new MatchError((Object)sp2);
                                }
                                if (!(pattern2 instanceof AnonymousEdge)) break block22;
                                AnonymousEdge anonymousEdge = (AnonymousEdge)pattern2;
                                Vertex src = anonymousEdge.src();
                                Vertex dst = anonymousEdge.dst();
                                String tmpName = new StringBuilder().append((Object)"__tmp").append((Object)((Object)BoxesRunTime.boxToLong((long)this.random().nextLong())).toString()).toString();
                                tuple25 = this.org$graphframes$GraphFrame$$findIncremental(gf, prevPatterns, prev, prevNames, new NamedEdge(tmpName, src, dst));
                                if (tuple25 == null) break block23;
                                Option df = (Option)tuple25._1();
                                Seq names = (Seq)tuple25._2();
                                Tuple2 tuple211 = tuple26 = new Tuple2((Object)df, (Object)names);
                                Option df2 = (Option)tuple211._1();
                                Seq names2 = (Seq)tuple211._2();
                                tuple22 = new Tuple2((Object)df2.map((Function1)new Serializable(tmpName){
                                    public static final long serialVersionUID = 0L;
                                    private final String tmpName$1;

                                    public final Dataset<Row> apply(Dataset<Row> x$9) {
                                        return x$9.drop(this.tmpName$1);
                                    }
                                    {
                                        this.tmpName$1 = tmpName$1;
                                    }
                                }), names2.filter((Function1)new Serializable(tmpName){
                                    public static final long serialVersionUID = 0L;
                                    private final String tmpName$1;

                                    public final boolean apply(String x$10) {
                                        String string = x$10;
                                        String string2 = this.tmpName$1;
                                        return string != null ? !string.equals(string2) : string2 != null;
                                    }
                                    {
                                        this.tmpName$1 = tmpName$1;
                                    }
                                }));
                                break block11;
                            }
                            throw new MatchError(tuple25);
                        }
                        if (!(pattern2 instanceof Negation)) break block24;
                        Negation negation = (Negation)pattern2;
                        Edge edge = negation.child();
                        option = prev;
                        if (!(option instanceof Some)) break block25;
                        Some some = (Some)option;
                        Dataset p = (Dataset)some.x();
                        tuple2 = this.org$graphframes$GraphFrame$$findIncremental(gf, prevPatterns, (Option<Dataset<Row>>)new Some((Object)p), prevNames, edge);
                        if (tuple2 == null) break block26;
                        Option df = (Option)tuple2._1();
                        Seq names = (Seq)tuple2._2();
                        Tuple2 tuple212 = tuple24 = new Tuple2((Object)df, (Object)names);
                        Option df3 = (Option)tuple212._1();
                        Seq names3 = (Seq)tuple212._2();
                        tuple22 = tuple23 = new Tuple2((Object)df3.map((Function1)new Serializable(p){
                            public static final long serialVersionUID = 0L;
                            private final Dataset p$1;

                            public final Dataset<Row> apply(Dataset<Row> result) {
                                return this.p$1.except(result);
                            }
                            {
                                this.p$1 = p$1;
                            }
                        }), (Object)names3);
                    }
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            if (None$.MODULE$.equals(option)) {
                throw new InvalidPatternException();
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)pattern2);
    }

    public int broadcastThreshold() {
        return this._broadcastThreshold;
    }

    public GraphFrame$ setBroadcastThreshold(int value) {
        Predef$.MODULE$.require(value >= 0);
        this._broadcastThreshold = value;
        return this;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Dataset nestE$1(String name, GraphFrame gf$1) {
        return gf$1.edges().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.nestAsCol(gf$1.edges(), name)}));
    }

    private final Dataset nestV$1(String name, GraphFrame gf$1) {
        return gf$1.vertices().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.nestAsCol(gf$1.vertices(), name)}));
    }

    private GraphFrame$() {
        MODULE$ = this;
        LazyLogging$class.$init$(this);
        Logging$class.$init$(this);
        this.ID = "id";
        this.SRC = "src";
        this.DST = "dst";
        this.EDGE = "edge";
        this.ATTR = "attr";
        this.LONG_ID = "new_id";
        this.LONG_SRC = "new_src";
        this.LONG_DST = "new_dst";
        this.GX_ATTR = "graphx_attr";
        this.random = new Random(ScalaRunTime$.MODULE$.hash((Object)GraphFrame.class.getName()));
        this._broadcastThreshold = 1000000;
    }
}

