/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.graphframes.GraphFrame;
import org.graphframes.Logging;
import org.graphframes.Logging$class;
import org.graphframes.lib.Arguments;
import org.graphframes.lib.Arguments$class;
import org.graphframes.lib.ConnectedComponents$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0001\u0003\u0001%\u00111cQ8o]\u0016\u001cG/\u001a3D_6\u0004xN\\3oiNT!a\u0001\u0003\u0002\u00071L'M\u0003\u0002\u0006\r\u0005YqM]1qQ\u001a\u0014\u0018-\\3t\u0015\u00059\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000b!Q\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005%\t%oZ;nK:$8\u000f\u0005\u0002\u0016-5\tA!\u0003\u0002\u0018\t\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0002\u000e\u0002\u000b\u001d\u0014\u0018\r\u001d5\u0016\u0003m\u0001\"!\u0006\u000f\n\u0005u!!AC$sCBDgI]1nK\"Aq\u0004\u0001B\u0001B\u0003%1$\u0001\u0004he\u0006\u0004\b\u000e\t\u0005\u0007C\u0001!\t\u0001\u0002\u0012\u0002\rqJg.\u001b;?)\t\u0019C\u0005\u0005\u0002\u0012\u0001!)\u0011\u0004\ta\u00017!9a\u0005\u0001a\u0001\n\u00139\u0013A\u00052s_\u0006$7-Y:u)\"\u0014Xm\u001d5pY\u0012,\u0012\u0001\u000b\t\u0003\u0017%J!A\u000b\u0007\u0003\u0007%sG\u000fC\u0004-\u0001\u0001\u0007I\u0011B\u0017\u0002-\t\u0014x.\u00193dCN$H\u000b\u001b:fg\"|G\u000eZ0%KF$\"AL\u0019\u0011\u0005-y\u0013B\u0001\u0019\r\u0005\u0011)f.\u001b;\t\u000fIZ\u0013\u0011!a\u0001Q\u0005\u0019\u0001\u0010J\u0019\t\rQ\u0002\u0001\u0015)\u0003)\u0003M\u0011'o\\1eG\u0006\u001cH\u000f\u00165sKNDw\u000e\u001c3!\u0011\u00151\u0004\u0001\"\u00018\u0003U\u0019X\r\u001e\"s_\u0006$7-Y:u)\"\u0014Xm\u001d5pY\u0012$\"\u0001O\u001d\u000e\u0003\u0001AQAO\u001bA\u0002!\nQA^1mk\u0016DaA\u000e\u0001\u0005\u0002\u0011aDC\u0001\u001d>\u0011\u0015Q4\b1\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013q!\u00138uK\u001e,'\u000fC\u0003H\u0001\u0011\u0005q%A\u000bhKR\u0014%o\\1eG\u0006\u001cH\u000f\u00165sKNDw\u000e\u001c3\t\u000f%\u0003\u0001\u0019!C\u0005\u0015\u0006I\u0011\r\\4pe&$\b.\\\u000b\u0002\u0017B\u0011Aj\u0014\b\u0003\u00175K!A\u0014\u0007\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0016K\u0001\u0004TiJLgn\u001a\u0006\u0003\u001d2Aqa\u0015\u0001A\u0002\u0013%A+A\u0007bY\u001e|'/\u001b;i[~#S-\u001d\u000b\u0003]UCqA\r*\u0002\u0002\u0003\u00071\n\u0003\u0004X\u0001\u0001\u0006KaS\u0001\u000bC2<wN]5uQ6\u0004\u0003\"B-\u0001\t\u0003Q\u0016\u0001D:fi\u0006cwm\u001c:ji\"lGC\u0001\u001d\\\u0011\u0015Q\u0004\f1\u0001L\u0011\u0015i\u0006\u0001\"\u0001K\u000319W\r^!mO>\u0014\u0018\u000e\u001e5n\u0011\u001dy\u0006\u00011A\u0005\n\u001d\n!c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\"9\u0011\r\u0001a\u0001\n\u0013\u0011\u0017AF2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2|F%Z9\u0015\u00059\u001a\u0007b\u0002\u001aa\u0003\u0003\u0005\r\u0001\u000b\u0005\u0007K\u0002\u0001\u000b\u0015\u0002\u0015\u0002'\rDWmY6q_&tG/\u00138uKJ4\u0018\r\u001c\u0011\t\u000b\u001d\u0004A\u0011\u00015\u0002+M,Go\u00115fG.\u0004x.\u001b8u\u0013:$XM\u001d<bYR\u0011\u0001(\u001b\u0005\u0006u\u0019\u0004\r\u0001\u000b\u0005\u0007O\u0002!\t\u0001B6\u0015\u0005ab\u0007\"\u0002\u001ek\u0001\u0004q\u0004\"\u00028\u0001\t\u00039\u0013!F4fi\u000eCWmY6q_&tG/\u00138uKJ4\u0018\r\u001c\u0005\u0006a\u0002!\t!]\u0001\u0004eVtG#\u0001:\u0011\u0007M\fyAD\u0002u\u0003\u0013q1!^A\u0002\u001d\t1hP\u0004\u0002xy:\u0011\u0001p_\u0007\u0002s*\u0011!\u0010C\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!! \u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0013\ry\u0018\u0011A\u0001\u0006gB\f'o\u001b\u0006\u0003{\u001aIA!!\u0002\u0002\b\u0005\u00191/\u001d7\u000b\u0007}\f\t!\u0003\u0003\u0002\f\u00055\u0011a\u00029bG.\fw-\u001a\u0006\u0005\u0003\u000b\t9!\u0003\u0003\u0002\u0012\u0005M!!\u0003#bi\u00064%/Y7f\u0015\u0011\tY!!\u0004\b\u000f\u0005]!\u0001#\u0001\u0002\u001a\u0005\u00192i\u001c8oK\u000e$X\rZ\"p[B|g.\u001a8ugB\u0019\u0011#a\u0007\u0007\r\u0005\u0011\u0001\u0012AA\u000f'\u0011\tYB\u0003\u000b\t\u000f\u0005\nY\u0002\"\u0001\u0002\"Q\u0011\u0011\u0011\u0004\u0005\u000b\u0003K\tYB1A\u0005\n\u0005\u001d\u0012!C\"P\u001bB{e*\u0012(U+\t\tI\u0003E\u0002@\u0003WI!\u0001\u0015!\t\u0013\u0005=\u00121\u0004Q\u0001\n\u0005%\u0012AC\"P\u001bB{e*\u0012(UA!Q\u00111GA\u000e\u0005\u0004%I!a\n\u0002\u000f=\u0013\u0016jR0J\t\"I\u0011qGA\u000eA\u0003%\u0011\u0011F\u0001\t\u001fJKuiX%EA!Q\u00111HA\u000e\u0005\u0004%I!a\n\u0002\u000f5Kej\u0018(C%\"I\u0011qHA\u000eA\u0003%\u0011\u0011F\u0001\t\u001b&suL\u0014\"SA!Q\u00111IA\u000e\u0005\u0004%I!a\n\u0002\u0007\rsE\u000bC\u0005\u0002H\u0005m\u0001\u0015!\u0003\u0002*\u0005!1I\u0014+!\u0011)\tY%a\u0007C\u0002\u0013%\u0011qE\u0001\u0017\u0007\"+5i\u0013)P\u0013:#vLT!N\u000b~\u0003&+\u0012$J1\"I\u0011qJA\u000eA\u0003%\u0011\u0011F\u0001\u0018\u0007\"+5i\u0013)P\u0013:#vLT!N\u000b~\u0003&+\u0012$J1\u0002B!\"a\u0015\u0002\u001c\t\u0007I\u0011BA\u0014\u0003-\tEjR(`\u000fJ\u000b\u0005\u000b\u0013-\t\u0013\u0005]\u00131\u0004Q\u0001\n\u0005%\u0012\u0001D!M\u000f>{vIU!Q\u0011b\u0003\u0003BCA.\u00037\u0011\r\u0011\"\u0003\u0002(\u0005\u0001\u0012\tT$P?\u001e\u0013\u0016\t\u0015%G%\u0006kUi\u0015\u0005\n\u0003?\nY\u0002)A\u0005\u0003S\t\u0011#\u0011'H\u001f~;%+\u0011)I\rJ\u000bU*R*!\u0011)\t\u0019'a\u0007C\u0002\u0013\u0005\u0011QM\u0001\u0014gV\u0004\bo\u001c:uK\u0012\fEnZ8sSRDWn]\u000b\u0003\u0003O\u0002BaCA5\u0017&\u0019\u00111\u000e\u0007\u0003\u000b\u0005\u0013(/Y=\t\u0013\u0005=\u00141\u0004Q\u0001\n\u0005\u001d\u0014\u0001F:vaB|'\u000f^3e\u00032<wN]5uQ6\u001c\b\u0005\u0003\u0005\u0002t\u0005mA\u0011BA;\u0003)\u0019\u00180\\7fiJL'0\u001a\u000b\u0004e\u0006]\u0004bBA=\u0003c\u0002\rA]\u0001\u0003K\u0016D\u0001\"! \u0002\u001c\u0011%\u0011qP\u0001\baJ,\u0007/\u0019:f)\rY\u0012\u0011\u0011\u0005\u00073\u0005m\u0004\u0019A\u000e\t\u0011\u0005\u0015\u00151\u0004C\u0005\u0003\u000f\u000bq!\\5o\u001d\n\u00148\u000fF\u0002s\u0003\u0013Cq!!\u001f\u0002\u0004\u0002\u0007!\u000f\u0003\u0005\u0002\u000e\u0006mA\u0011BAH\u0003!i\u0017N\u001c,bYV,GCBAI\u00033\u000bi\n\u0005\u0003\u0002\u0014\u0006UUBAA\u0007\u0013\u0011\t9*!\u0004\u0003\r\r{G.^7o\u0011!\tY*a#A\u0002\u0005E\u0015!\u0001=\t\u0011\u0005}\u00151\u0012a\u0001\u0003#\u000b\u0011!\u001f\u0005\t\u0003G\u000bY\u0002\"\u0003\u0002&\u0006AQ.\u0019=WC2,X\r\u0006\u0004\u0002\u0012\u0006\u001d\u0016\u0011\u0016\u0005\t\u00037\u000b\t\u000b1\u0001\u0002\u0012\"A\u0011qTAQ\u0001\u0004\t\t\n\u0003\u0005\u0002.\u0006mA\u0011BAX\u0003)\u00198.Z<fI*{\u0017N\u001c\u000b\ne\u0006E\u0016QWA\\\u0003sCq!a-\u0002,\u0002\u0007!/A\u0003fI\u001e,7\u000fC\u0004\u0002\u0006\u0006-\u0006\u0019\u0001:\t\r\u0019\nY\u000b1\u0001)\u0011\u001d\tY,a+A\u0002-\u000b\u0011\u0002\\8h!J,g-\u001b=\t\u000fA\fY\u0002\"\u0001\u0002@R\u0019!/!1\t\re\ti\f1\u0001\u001c\u0011!\t)-a\u0007\u0005\n\u0005\u001d\u0017!\u0003:v]\u001e\u0013\u0018\r\u001d5Y)\r\u0011\u0018\u0011\u001a\u0005\u00073\u0005\r\u0007\u0019A\u000e\t\u000fA\fY\u0002\"\u0003\u0002NRI!/a4\u0002R\u0006M\u0017Q\u001b\u0005\u00073\u0005-\u0007\u0019A\u000e\t\r%\u000bY\r1\u0001L\u0011\u00191\u00131\u001aa\u0001Q!1q,a3A\u0002!\u0002")
public class ConnectedComponents
implements Arguments,
Logging {
    private final GraphFrame graph;
    private int broadcastThreshold;
    private String algorithm;
    private int checkpointInterval;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static String[] supportedAlgorithms() {
        return ConnectedComponents$.MODULE$.supportedAlgorithms();
    }

    @Override
    public void logDebug(String s) {
        Logging$class.logDebug(this, s);
    }

    @Override
    public void logInfo(String s) {
        Logging$class.logInfo(this, s);
    }

    @Override
    public void logTrace(String s) {
        Logging$class.logTrace(this, s);
    }

    private Logger logger$lzycompute() {
        ConnectedComponents connectedComponents = this;
        synchronized (connectedComponents) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public <A> A check(Option<A> a, String name) {
        return (A)Arguments$class.check(this, a, name);
    }

    private GraphFrame graph() {
        return this.graph;
    }

    private int broadcastThreshold() {
        return this.broadcastThreshold;
    }

    private void broadcastThreshold_$eq(int x$1) {
        this.broadcastThreshold = x$1;
    }

    public ConnectedComponents setBroadcastThreshold(int value) {
        Predef$.MODULE$.require(value >= 0, (Function0)new Serializable(this, value){
            public static final long serialVersionUID = 0L;
            private final int value$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broadcast threshold must be non-negative but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.value$1)}));
            }
            {
                this.value$1 = value$1;
            }
        });
        this.broadcastThreshold_$eq(value);
        return this;
    }

    public ConnectedComponents setBroadcastThreshold(Integer value) {
        return this.setBroadcastThreshold(Predef$.MODULE$.Integer2int(value));
    }

    public int getBroadcastThreshold() {
        return this.broadcastThreshold();
    }

    private String algorithm() {
        return this.algorithm;
    }

    private void algorithm_$eq(String x$1) {
        this.algorithm = x$1;
    }

    public ConnectedComponents setAlgorithm(String value) {
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])ConnectedComponents$.MODULE$.supportedAlgorithms()).contains((Object)value), (Function0)new Serializable(this, value){
            public static final long serialVersionUID = 0L;
            private final String value$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported algorithms are {", "}, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])ConnectedComponents$.MODULE$.supportedAlgorithms()).mkString(", "), this.value$2}));
            }
            {
                this.value$2 = value$2;
            }
        });
        this.algorithm_$eq(value);
        return this;
    }

    public String getAlgorithm() {
        return this.algorithm();
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    public ConnectedComponents setCheckpointInterval(int value) {
        BoxedUnit boxedUnit;
        if (value <= 0 || value > 2) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Set checkpointInterval to ", ". This would blow up the query plan and hang the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)value)}))).append((Object)"driver for large graphs.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.checkpointInterval_$eq(value);
        return this;
    }

    public ConnectedComponents setCheckpointInterval(Integer value) {
        return this.setCheckpointInterval(Predef$.MODULE$.Integer2int(value));
    }

    public int getCheckpointInterval() {
        return this.checkpointInterval();
    }

    public Dataset<Row> run() {
        return ConnectedComponents$.MODULE$.org$graphframes$lib$ConnectedComponents$$run(this.graph(), this.algorithm(), this.broadcastThreshold(), this.checkpointInterval());
    }

    public ConnectedComponents(GraphFrame graph) {
        this.graph = graph;
        Arguments$class.$init$(this);
        LazyLogging$class.$init$(this);
        Logging$class.$init$(this);
        this.broadcastThreshold = 1000000;
        this.algorithm = ConnectedComponents$.MODULE$.org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES();
        this.checkpointInterval = 2;
    }
}

