/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.driver.internal.cluster.HostNameResolver;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.v1.Logger;

public class DnsResolver
implements HostNameResolver {
    private final Logger logger;

    public DnsResolver(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Set<BoltServerAddress> resolve(BoltServerAddress initialRouter) {
        HashSet<BoltServerAddress> addresses = new HashSet<BoltServerAddress>();
        try {
            InetAddress[] ipAddresses;
            for (InetAddress ipAddress : ipAddresses = InetAddress.getAllByName(initialRouter.host())) {
                addresses.add(new BoltServerAddress(ipAddress.getHostAddress(), initialRouter.port()));
            }
            return addresses;
        }
        catch (UnknownHostException e) {
            this.logger.error("Failed to resolve URI `" + initialRouter + "` to IPs due to error: " + e.getMessage(), e);
            addresses.add(initialRouter);
            return addresses;
        }
    }
}

