/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.spark;

import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.neo4j.driver.v1.Driver;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.summary.ResultSummary;
import org.neo4j.driver.v1.types.Type;
import org.neo4j.spark.CypherTypes$;
import org.neo4j.spark.Neo4jConfig;
import org.neo4j.spark.Neo4jConfig$;
import org.neo4j.spark.Neo4jDataFrame;
import org.neo4j.spark.Neo4jDataFrame$;
import org.neo4j.spark.Neo4jRowRDD;
import org.neo4j.spark.Neo4jRowRDD$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;

public final class Neo4jDataFrame$ {
    public static final Neo4jDataFrame$ MODULE$;

    static {
        new Neo4jDataFrame$();
    }

    public void mergeEdgeList(SparkContext sc, Dataset<Row> dataFrame, Tuple2<String, Seq<String>> source, Tuple2<String, Seq<String>> relationship, Tuple2<String, Seq<String>> target) {
        String mergeStatement = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      UNWIND {rows} as row\n      MERGE (source:`", "` {`", "` : row.source.`", "`}) ON CREATE SET source += row.source\n      MERGE (target:`", "` {`", "` : row.target.`", "`}) ON CREATE SET target += row.target\n      MERGE (source)-[rel:`", "`]->(target) ON CREATE SET rel += row.relationship\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source._1(), ((IterableLike)source._2()).head(), ((IterableLike)source._2()).head(), target._1(), ((IterableLike)target._2()).head(), ((IterableLike)target._2()).head(), relationship._1()}));
        int partitions = Math.max(1, (int)(dataFrame.count() / 10000L));
        Neo4jConfig config = Neo4jConfig$.MODULE$.apply(sc.getConf());
        dataFrame.repartition(partitions).foreachPartition((Function1)new Serializable(source, relationship, target, mergeStatement, config){
            public static final long serialVersionUID = 0L;
            public final Tuple2 source$1;
            public final Tuple2 relationship$1;
            public final Tuple2 target$1;
            private final String mergeStatement$1;
            private final Neo4jConfig config$1;

            public final void apply(Iterator<Row> rows) {
                Object params = JavaConverters$.MODULE$.asJavaIteratorConverter(rows.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.mergeEdgeList.1 $outer;

                    public final java.util.Map<String, java.util.Map<String, Object>> apply(Row r) {
                        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)this.$outer.source$1._2()).map((Function1)new Serializable(this, r){
                            public static final long serialVersionUID = 0L;
                            private final Row r$1;

                            public final Tuple2<String, Object> apply(String c) {
                                return new Tuple2((Object)c, this.r$1.getAs(c));
                            }
                            {
                                this.r$1 = r$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"target"), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)this.$outer.target$1._2()).map((Function1)new Serializable(this, r){
                            public static final long serialVersionUID = 0L;
                            private final Row r$1;

                            public final Tuple2<String, Object> apply(String c) {
                                return new Tuple2((Object)c, this.r$1.getAs(c));
                            }
                            {
                                this.r$1 = r$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationship"), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)this.$outer.relationship$1._2()).map((Function1)new Serializable(this, r){
                            public static final long serialVersionUID = 0L;
                            private final Row r$1;

                            public final Tuple2<String, Object> apply(String c) {
                                return new Tuple2((Object)c, this.r$1.getAs(c));
                            }
                            {
                                this.r$1 = r$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())}))).asJava();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).asJava();
                Neo4jDataFrame$.MODULE$.execute(this.config$1, this.mergeStatement$1, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rows"), params)}))).asJava());
            }
            {
                this.source$1 = source$1;
                this.relationship$1 = relationship$1;
                this.target$1 = target$1;
                this.mergeStatement$1 = mergeStatement$1;
                this.config$1 = config$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public ResultSummary execute(Neo4jConfig config, String query, java.util.Map<String, Object> parameters) {
        ResultSummary resultSummary;
        Driver driver = config.driver();
        Session session = driver.session();
        try {
            resultSummary = session.run(query, parameters).consume();
        }
        catch (Throwable throwable) {
            void var4_4;
            void var5_5;
            if (var5_5.isOpen()) {
                var5_5.close();
            }
            var4_4.close();
            throw throwable;
        }
        if (session.isOpen()) {
            session.close();
        }
        driver.close();
        return resultSummary;
    }

    public Dataset<Row> withDataType(SQLContext sqlContext, String query, Seq<Tuple2<String, Object>> parameters, Seq<Tuple2<String, DataType>> schema) {
        Neo4jRowRDD rowRdd = Neo4jRowRDD$.MODULE$.apply(sqlContext.sparkContext(), query, parameters);
        return sqlContext.createDataFrame((RDD)rowRdd, CypherTypes$.MODULE$.schemaFromDataType(schema));
    }

    public Dataset<Row> apply(SQLContext sqlContext, String query, Seq<Tuple2<String, Object>> parameters, Seq<Tuple2<String, String>> schema) {
        Neo4jRowRDD rowRdd = Neo4jRowRDD$.MODULE$.apply(sqlContext.sparkContext(), query, parameters);
        return sqlContext.createDataFrame((RDD)rowRdd, CypherTypes$.MODULE$.schemaFromNamedType(schema));
    }

    /*
     * WARNING - void declaration
     */
    public Dataset<Row> apply(SQLContext sqlContext, String query, java.util.Map<String, Object> parameters) {
        block5: {
            Dataset dataset;
            Neo4jConfig config = Neo4jConfig$.MODULE$.apply(sqlContext.sparkContext().getConf());
            Driver driver = config.driver();
            Session session = driver.session();
            try {
                StatementResult result = session.run(query, parameters);
                if (!result.hasNext()) break block5;
                Record peek = result.peek();
                Buffer fields = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(peek.keys()).asScala()).map((Function1)new Serializable(peek){
                    public static final long serialVersionUID = 0L;
                    private final Record peek$1;

                    public final Tuple2<String, Type> apply(String k) {
                        return new Tuple2((Object)k, (Object)this.peek$1.get(k).type());
                    }
                    {
                        this.peek$1 = peek$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final StructField apply(Tuple2<String, Type> keyType) {
                        return CypherTypes$.MODULE$.field(keyType);
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                StructType schema = StructType$.MODULE$.apply((Seq)fields);
                Neo4jDataFrame.Neo4jResultRdd rowRdd = new Neo4jDataFrame.Neo4jResultRdd(sqlContext.sparkContext(), (Iterator<Record>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)result).asScala()), peek.size(), session, driver);
                dataset = sqlContext.createDataFrame((RDD)rowRdd, schema);
            }
            catch (Throwable throwable) {
                void var5_5;
                void var6_6;
                if (var6_6.isOpen()) {
                    var6_6.close();
                }
                var5_5.close();
                throw throwable;
            }
            if (session.isOpen()) {
                session.close();
            }
            driver.close();
            return dataset;
        }
        throw new RuntimeException("Can't determine schema from empty result");
    }

    private Neo4jDataFrame$() {
        MODULE$ = this;
    }
}

