/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.retry.MaxRetriesExceeded;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.event.RetryOnErrorEvent;
import io.github.resilience4j.retry.event.RetryOnIgnoredErrorEvent;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.github.resilience4j.retry.event.RetryOnSuccessEvent;
import io.vavr.CheckedConsumer;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class RetryImpl<T>
implements Retry {
    static CheckedConsumer<Long> sleepFunction = Thread::sleep;
    private final Retry.Metrics metrics;
    private final RetryEventProcessor eventProcessor;
    @Nullable
    private final Predicate<T> resultPredicate;
    private final String name;
    private final RetryConfig config;
    private final Map<String, String> tags;
    private final int maxAttempts;
    private final Function<Integer, Long> intervalFunction;
    private final Predicate<Throwable> exceptionPredicate;
    private final LongAdder succeededAfterRetryCounter;
    private final LongAdder failedAfterRetryCounter;
    private final LongAdder succeededWithoutRetryCounter;
    private final LongAdder failedWithoutRetryCounter;

    public RetryImpl(String name, RetryConfig config) {
        this(name, config, HashMap.empty());
    }

    public RetryImpl(String name, RetryConfig config, Map<String, String> tags) {
        this.name = name;
        this.config = config;
        this.tags = tags;
        this.maxAttempts = config.getMaxAttempts();
        this.intervalFunction = config.getIntervalFunction();
        this.exceptionPredicate = config.getExceptionPredicate();
        this.resultPredicate = config.getResultPredicate();
        this.metrics = new RetryMetrics();
        this.eventProcessor = new RetryEventProcessor();
        this.succeededAfterRetryCounter = new LongAdder();
        this.failedAfterRetryCounter = new LongAdder();
        this.succeededWithoutRetryCounter = new LongAdder();
        this.failedWithoutRetryCounter = new LongAdder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Retry.Context context() {
        return new ContextImpl();
    }

    public Retry.AsyncContext asyncContext() {
        return new AsyncContextImpl();
    }

    @Override
    public RetryConfig getRetryConfig() {
        return this.config;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    private void publishRetryEvent(Supplier<RetryEvent> event) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.consumeEvent(event.get());
        }
    }

    @Override
    public Retry.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    @Override
    public Retry.Metrics getMetrics() {
        return this.metrics;
    }

    private class RetryEventProcessor
    extends EventProcessor<RetryEvent>
    implements EventConsumer<RetryEvent>,
    Retry.EventPublisher {
        private RetryEventProcessor() {
        }

        @Override
        public void consumeEvent(RetryEvent event) {
            super.processEvent(event);
        }

        @Override
        public Retry.EventPublisher onRetry(EventConsumer<RetryOnRetryEvent> onRetryEventConsumer) {
            this.registerConsumer(RetryOnRetryEvent.class.getSimpleName(), onRetryEventConsumer);
            return this;
        }

        @Override
        public Retry.EventPublisher onSuccess(EventConsumer<RetryOnSuccessEvent> onSuccessEventConsumer) {
            this.registerConsumer(RetryOnSuccessEvent.class.getSimpleName(), onSuccessEventConsumer);
            return this;
        }

        @Override
        public Retry.EventPublisher onError(EventConsumer<RetryOnErrorEvent> onErrorEventConsumer) {
            this.registerConsumer(RetryOnErrorEvent.class.getSimpleName(), onErrorEventConsumer);
            return this;
        }

        @Override
        public Retry.EventPublisher onIgnoredError(EventConsumer<RetryOnIgnoredErrorEvent> onIgnoredErrorEventConsumer) {
            this.registerConsumer(RetryOnIgnoredErrorEvent.class.getSimpleName(), onIgnoredErrorEventConsumer);
            return this;
        }
    }

    public final class RetryMetrics
    implements Retry.Metrics {
        private RetryMetrics() {
        }

        @Override
        public long getNumberOfSuccessfulCallsWithoutRetryAttempt() {
            return RetryImpl.this.succeededWithoutRetryCounter.longValue();
        }

        @Override
        public long getNumberOfFailedCallsWithoutRetryAttempt() {
            return RetryImpl.this.failedWithoutRetryCounter.longValue();
        }

        @Override
        public long getNumberOfSuccessfulCallsWithRetryAttempt() {
            return RetryImpl.this.succeededAfterRetryCounter.longValue();
        }

        @Override
        public long getNumberOfFailedCallsWithRetryAttempt() {
            return RetryImpl.this.failedAfterRetryCounter.longValue();
        }
    }

    public final class AsyncContextImpl
    implements Retry.AsyncContext<T> {
        private final AtomicInteger numOfAttempts = new AtomicInteger(0);
        private final AtomicReference<Throwable> lastException = new AtomicReference();

        @Override
        @Deprecated
        public void onSuccess() {
            this.onComplete();
        }

        @Override
        public void onComplete() {
            int currentNumOfAttempts = this.numOfAttempts.get();
            if (currentNumOfAttempts > 0 && currentNumOfAttempts < RetryImpl.this.maxAttempts) {
                RetryImpl.this.succeededAfterRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnSuccessEvent(RetryImpl.this.name, currentNumOfAttempts, this.lastException.get()));
            } else if (currentNumOfAttempts >= RetryImpl.this.maxAttempts) {
                RetryImpl.this.failedAfterRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(RetryImpl.this.name, currentNumOfAttempts, this.lastException.get() != null ? this.lastException.get() : new MaxRetriesExceeded("max retries is reached out for the result predicate check")));
            } else {
                RetryImpl.this.succeededWithoutRetryCounter.increment();
            }
        }

        @Override
        public long onError(Throwable throwable) {
            if (throwable instanceof CompletionException) {
                Throwable cause = throwable.getCause();
                return this.handleThrowable(cause);
            }
            return this.handleThrowable(throwable);
        }

        private long handleThrowable(Throwable throwable) {
            if (!RetryImpl.this.exceptionPredicate.test(throwable)) {
                RetryImpl.this.failedWithoutRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnIgnoredErrorEvent(RetryImpl.this.getName(), throwable));
                return -1L;
            }
            return this.handleOnError(throwable);
        }

        private long handleOnError(Throwable throwable) {
            this.lastException.set(throwable);
            int attempt = this.numOfAttempts.incrementAndGet();
            if (attempt >= RetryImpl.this.maxAttempts) {
                RetryImpl.this.failedAfterRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(RetryImpl.this.name, attempt, throwable));
                return -1L;
            }
            long interval = (Long)RetryImpl.this.intervalFunction.apply(attempt);
            RetryImpl.this.publishRetryEvent(() -> new RetryOnRetryEvent(RetryImpl.this.getName(), attempt, throwable, interval));
            return interval;
        }

        @Override
        public long onResult(T result) {
            if (null != RetryImpl.this.resultPredicate && RetryImpl.this.resultPredicate.test(result)) {
                int attempt = this.numOfAttempts.incrementAndGet();
                if (attempt >= RetryImpl.this.maxAttempts) {
                    return -1L;
                }
                return (Long)RetryImpl.this.intervalFunction.apply(attempt);
            }
            return -1L;
        }
    }

    public final class ContextImpl
    implements Retry.Context<T> {
        private final AtomicInteger numOfAttempts = new AtomicInteger(0);
        private final AtomicReference<Exception> lastException = new AtomicReference();
        private final AtomicReference<RuntimeException> lastRuntimeException = new AtomicReference();

        private ContextImpl() {
        }

        @Override
        @Deprecated
        public void onSuccess() {
            this.onComplete();
        }

        @Override
        public void onComplete() {
            int currentNumOfAttempts = this.numOfAttempts.get();
            if (currentNumOfAttempts > 0 && currentNumOfAttempts < RetryImpl.this.maxAttempts) {
                RetryImpl.this.succeededAfterRetryCounter.increment();
                Throwable throwable = Option.of(this.lastException.get()).getOrElse(this.lastRuntimeException.get());
                RetryImpl.this.publishRetryEvent(() -> new RetryOnSuccessEvent(RetryImpl.this.getName(), currentNumOfAttempts, throwable));
            } else if (currentNumOfAttempts >= RetryImpl.this.maxAttempts) {
                RetryImpl.this.failedAfterRetryCounter.increment();
                Throwable throwable = Option.of(this.lastException.get()).getOrElse(this.lastRuntimeException.get());
                RetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(RetryImpl.this.name, currentNumOfAttempts, throwable != null ? throwable : new MaxRetriesExceeded("max retries is reached out for the result predicate check")));
            } else {
                RetryImpl.this.succeededWithoutRetryCounter.increment();
            }
        }

        @Override
        public boolean onResult(T result) {
            if (null != RetryImpl.this.resultPredicate && RetryImpl.this.resultPredicate.test(result)) {
                int currentNumOfAttempts = this.numOfAttempts.incrementAndGet();
                if (currentNumOfAttempts >= RetryImpl.this.maxAttempts) {
                    return false;
                }
                this.waitIntervalAfterFailure(currentNumOfAttempts, null);
                return true;
            }
            return false;
        }

        @Override
        public void onError(Exception exception) throws Exception {
            if (!RetryImpl.this.exceptionPredicate.test(exception)) {
                RetryImpl.this.failedWithoutRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnIgnoredErrorEvent(RetryImpl.this.getName(), exception));
                throw exception;
            }
            this.lastException.set(exception);
            this.throwOrSleepAfterException();
        }

        @Override
        public void onRuntimeError(RuntimeException runtimeException) {
            if (!RetryImpl.this.exceptionPredicate.test(runtimeException)) {
                RetryImpl.this.failedWithoutRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnIgnoredErrorEvent(RetryImpl.this.getName(), runtimeException));
                throw runtimeException;
            }
            this.lastRuntimeException.set(runtimeException);
            this.throwOrSleepAfterRuntimeException();
        }

        private void throwOrSleepAfterException() throws Exception {
            int currentNumOfAttempts = this.numOfAttempts.incrementAndGet();
            Exception throwable = this.lastException.get();
            if (currentNumOfAttempts >= RetryImpl.this.maxAttempts) {
                RetryImpl.this.failedAfterRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(RetryImpl.this.getName(), currentNumOfAttempts, throwable));
                throw throwable;
            }
            this.waitIntervalAfterFailure(currentNumOfAttempts, throwable);
        }

        private void throwOrSleepAfterRuntimeException() {
            int currentNumOfAttempts = this.numOfAttempts.incrementAndGet();
            RuntimeException throwable = this.lastRuntimeException.get();
            if (currentNumOfAttempts >= RetryImpl.this.maxAttempts) {
                RetryImpl.this.failedAfterRetryCounter.increment();
                RetryImpl.this.publishRetryEvent(() -> new RetryOnErrorEvent(RetryImpl.this.getName(), currentNumOfAttempts, throwable));
                throw throwable;
            }
            this.waitIntervalAfterFailure(currentNumOfAttempts, throwable);
        }

        private void waitIntervalAfterFailure(int currentNumOfAttempts, @Nullable Throwable throwable) {
            long interval = (Long)RetryImpl.this.intervalFunction.apply(this.numOfAttempts.get());
            RetryImpl.this.publishRetryEvent(() -> new RetryOnRetryEvent(RetryImpl.this.getName(), currentNumOfAttempts, throwable, interval));
            Try.run(() -> sleepFunction.accept(interval)).getOrElseThrow(ex -> this.lastRuntimeException.get());
        }
    }
}

