/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.spark.dataframe;

import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.Type;
import org.neo4j.spark.Neo4jConfig;
import org.neo4j.spark.Neo4jConfig$;
import org.neo4j.spark.cypher.CypherHelpers$;
import org.neo4j.spark.dataframe.CypherTypes$;
import org.neo4j.spark.dataframe.Neo4jDataFrame;
import org.neo4j.spark.dataframe.Neo4jDataFrame$;
import org.neo4j.spark.dataframe.Neo4jDataFrame$$anonfun$execute$1$;
import org.neo4j.spark.rdd.Neo4jRowRDD;
import org.neo4j.spark.rdd.Neo4jRowRDD$;
import org.neo4j.spark.utils.Neo4jUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public final class Neo4jDataFrame$ {
    public static final Neo4jDataFrame$ MODULE$;

    static {
        new Neo4jDataFrame$();
    }

    public void mergeEdgeList(SparkContext sc, Dataset<Row> dataFrame, Tuple2<String, Seq<String>> source, Tuple2<String, Seq<String>> relationship, Tuple2<String, Seq<String>> target, scala.collection.immutable.Map<String, String> renamedColumns, int partitions, int unwindBatchSize) {
        this.createNodes(sc, dataFrame, source, renamedColumns, partitions, unwindBatchSize, true);
        this.createNodes(sc, dataFrame, target, renamedColumns, partitions, unwindBatchSize, true);
        String sourceKey = CypherHelpers$.MODULE$.StringHelper((String)renamedColumns.getOrElse(((IterableLike)source._2()).head(), (Function0)new Serializable(source){
            public static final long serialVersionUID = 0L;
            private final Tuple2 source$1;

            public final String apply() {
                return (String)((IterableLike)this.source$1._2()).head();
            }
            {
                this.source$1 = source$1;
            }
        })).quote();
        String targetKey = CypherHelpers$.MODULE$.StringHelper((String)renamedColumns.getOrElse(((IterableLike)target._2()).head(), (Function0)new Serializable(target){
            public static final long serialVersionUID = 0L;
            private final Tuple2 target$1;

            public final String apply() {
                return (String)((IterableLike)this.target$1._2()).head();
            }
            {
                this.target$1 = target$1;
            }
        })).quote();
        String relStatement = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n        |UNWIND $rows as row\n        |MATCH (source:", " {", ": row.source.", "})\n        |MATCH (target:", " {", ": row.target.", "})\n        |MERGE (source)-[rel:", "]->(target) ON CREATE SET rel += row.relationship\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CypherHelpers$.MODULE$.StringHelper((String)source._1()).quote(), sourceKey, sourceKey, CypherHelpers$.MODULE$.StringHelper((String)target._1()).quote(), targetKey, targetKey, CypherHelpers$.MODULE$.StringHelper((String)relationship._1()).quote()})))).stripMargin();
        this.execute(sc, dataFrame, partitions, unwindBatchSize, relStatement, (Function1<Row, Object>)new Serializable(source, relationship, target, renamedColumns){
            public static final long serialVersionUID = 0L;
            private final Tuple2 source$1;
            private final Tuple2 relationship$1;
            private final Tuple2 target$1;
            public final scala.collection.immutable.Map renamedColumns$1;

            public final java.util.Map<String, java.util.Map<String, Object>> apply(Row r) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)this.source$1._2()).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.mergeEdgeList.1 $outer;
                    private final Row r$1;

                    public final Tuple2<String, Object> apply(String c) {
                        return new Tuple2(this.$outer.renamedColumns$1.getOrElse((Object)c, (Function0)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final String c$1;

                            public final String apply() {
                                return this.c$1;
                            }
                            {
                                this.c$1 = c$1;
                            }
                        }), Neo4jDataFrame$.MODULE$.toJava(this.r$1.getAs(c)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"target"), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)this.target$1._2()).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.mergeEdgeList.1 $outer;
                    private final Row r$1;

                    public final Tuple2<String, Object> apply(String c) {
                        return new Tuple2(this.$outer.renamedColumns$1.getOrElse((Object)c, (Function0)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final String c$2;

                            public final String apply() {
                                return this.c$2;
                            }
                            {
                                this.c$2 = c$2;
                            }
                        }), Neo4jDataFrame$.MODULE$.toJava(this.r$1.getAs(c)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"relationship"), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)this.relationship$1._2()).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final Row r$1;

                    public final Tuple2<String, Object> apply(String c) {
                        return new Tuple2((Object)c, Neo4jDataFrame$.MODULE$.toJava(this.r$1.getAs(c)));
                    }
                    {
                        this.r$1 = r$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())}))).asJava();
            }
            {
                this.source$1 = source$1;
                this.relationship$1 = relationship$1;
                this.target$1 = target$1;
                this.renamedColumns$1 = renamedColumns$1;
            }
        });
    }

    public scala.collection.immutable.Map<String, String> mergeEdgeList$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    public int mergeEdgeList$default$7() {
        return 1;
    }

    public int mergeEdgeList$default$8() {
        return 10000;
    }

    private void execute(SparkContext sc, Dataset<Row> dataFrame, int partitions, int unwindBatchSize, String statement, Function1<Row, Object> mapFun) {
        Neo4jConfig config = Neo4jConfig$.MODULE$.apply(sc.getConf());
        dataFrame.repartition(partitions).foreachPartition((Function1)new Serializable(unwindBatchSize, statement, mapFun, config){
            public static final long serialVersionUID = 0L;
            private final int unwindBatchSize$1;
            public final String statement$1;
            public final Function1 mapFun$1;
            private final Neo4jConfig config$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Iterator<Row> rows) {
                Driver driver = this.config$1.driver();
                Session session = driver.session(this.config$1.sessionConfig(this.config$1.sessionConfig$default$1()));
                try {
                    rows.grouped(this.unwindBatchSize$1).foreach((Function1)new Serializable(this, session){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.execute.1 $outer;
                        private final Session session$1;

                        public final ResultSummary apply(Seq<Row> chunk) {
                            Object params = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)chunk.map(this.$outer.mapFun$1, Seq$.MODULE$.canBuildFrom())).asJava();
                            return this.session$1.writeTransaction(new TransactionWork<ResultSummary>(this, params){
                                private final /* synthetic */ anonfun$execute$1$$anonfun$apply$6 $outer;
                                private final Object params$1;

                                public ResultSummary execute(Transaction tx) {
                                    return tx.run(this.$outer.org$neo4j$spark$dataframe$Neo4jDataFrame$$anonfun$$anonfun$$$outer().statement$1, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rows"), this.params$1)}))).asJava()).consume();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.params$1 = params$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.execute.1 org$neo4j$spark$dataframe$Neo4jDataFrame$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.session$1 = session$1;
                        }
                    });
                    Neo4jUtils$.MODULE$.close(driver, session);
                    return;
                }
                catch (Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    Neo4jUtils$.MODULE$.close((Driver)var2_2, (Session)var3_3);
                    throw throwable;
                }
            }
            {
                this.unwindBatchSize$1 = unwindBatchSize$1;
                this.statement$1 = statement$1;
                this.mapFun$1 = mapFun$1;
                this.config$1 = config$1;
            }
        });
    }

    public void createNodes(SparkContext sc, Dataset<Row> dataFrame, Tuple2<String, Seq<String>> nodes, scala.collection.immutable.Map<String, String> renamedColumns, int partitions, int unwindBatchSize, boolean merge) {
        String nodeLabel = (String)renamedColumns.getOrElse(((IterableLike)nodes._2()).head(), (Function0)new Serializable(nodes){
            public static final long serialVersionUID = 0L;
            private final Tuple2 nodes$1;

            public final String apply() {
                return (String)((IterableLike)this.nodes$1._2()).head();
            }
            {
                this.nodes$1 = nodes$1;
            }
        });
        String createStatement = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"|\n       |UNWIND $rows as row\n       |", " (node:", " {", " : row.node_properties.", "})\n       |SET node += row.node_properties\n       |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{merge ? "MERGE" : "CREATE", CypherHelpers$.MODULE$.StringHelper((String)nodes._1()).quote(), CypherHelpers$.MODULE$.StringHelper(nodeLabel).quote(), CypherHelpers$.MODULE$.StringHelper(nodeLabel).quote()})))).stripMargin();
        this.execute(sc, dataFrame, partitions, unwindBatchSize, createStatement, (Function1<Row, Object>)new Serializable(nodes, renamedColumns){
            public static final long serialVersionUID = 0L;
            private final Tuple2 nodes$1;
            public final scala.collection.immutable.Map renamedColumns$2;

            public final java.util.Map<String, java.util.Map<String, Object>> apply(Row r) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"node_properties"), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)this.nodes$1._2()).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.createNodes.1 $outer;
                    private final Row r$2;

                    public final Tuple2<String, Object> apply(String c) {
                        return new Tuple2(this.$outer.renamedColumns$2.getOrElse((Object)c, (Function0)new Serializable(this, c){
                            public static final long serialVersionUID = 0L;
                            private final String c$3;

                            public final String apply() {
                                return this.c$3;
                            }
                            {
                                this.c$3 = c$3;
                            }
                        }), Neo4jDataFrame$.MODULE$.toJava(this.r$2.getAs(c)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.r$2 = r$2;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava())}))).asJava();
            }
            {
                this.nodes$1 = nodes$1;
                this.renamedColumns$2 = renamedColumns$2;
            }
        });
    }

    public scala.collection.immutable.Map<String, String> createNodes$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public int createNodes$default$5() {
        return 1;
    }

    public int createNodes$default$6() {
        return 10000;
    }

    public boolean createNodes$default$7() {
        return false;
    }

    public Dataset<Row> withDataType(SQLContext sqlContext, String query, Seq<Tuple2<String, Object>> parameters, Seq<Tuple2<String, DataType>> schema) {
        Neo4jRowRDD rowRdd = Neo4jRowRDD$.MODULE$.apply(sqlContext.sparkContext(), query, parameters);
        return sqlContext.createDataFrame((RDD)rowRdd, CypherTypes$.MODULE$.schemaFromDataType(schema));
    }

    public Dataset<Row> apply(SQLContext sqlContext, String query, Seq<Tuple2<String, Object>> parameters, Seq<Tuple2<String, String>> schema) {
        Neo4jRowRDD rowRdd = Neo4jRowRDD$.MODULE$.apply(sqlContext.sparkContext(), query, parameters);
        return sqlContext.createDataFrame((RDD)rowRdd, CypherTypes$.MODULE$.schemaFromNamedType(schema));
    }

    public Object toJava(Object x) {
        Object object;
        block4: {
            while (true) {
                Object object2;
                if ((object2 = x) instanceof MapLike) {
                    MapLike mapLike = (MapLike)object2;
                    object = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)mapLike.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                            Tuple2<Object, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                Object d = tuple2._1();
                                Object v = tuple2._2();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Neo4jDataFrame$.MODULE$.toJava(d)), Neo4jDataFrame$.MODULE$.toJava(v));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom())).asJava();
                    break block4;
                }
                if (object2 instanceof SetLike) {
                    SetLike setLike = (SetLike)object2;
                    object = JavaConverters$.MODULE$.setAsJavaSetConverter((Set)setLike.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object item) {
                            return Neo4jDataFrame$.MODULE$.toJava(item);
                        }
                    }, Set$.MODULE$.canBuildFrom())).asJava();
                    break block4;
                }
                if (object2 instanceof Iterable) {
                    Iterable iterable = (Iterable)object2;
                    object = JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)iterable.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(Object item) {
                            return Neo4jDataFrame$.MODULE$.toJava(item);
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).asJava();
                    break block4;
                }
                if (!(object2 instanceof Iterator)) break;
                Iterator iterator = (Iterator)object2;
                x = iterator.toIterable();
            }
            object = x;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Dataset<Row> apply(SQLContext sqlContext, String query, java.util.Map<String, Object> parameters) {
        Tuple2<Object, StructType> tuple2;
        String limitedQuery = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " LIMIT 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query}));
        Neo4jConfig config = Neo4jConfig$.MODULE$.apply(sqlContext.sparkContext().getConf());
        Driver driver = config.driver();
        Session session = driver.session(config.sessionConfig(config.sessionConfig$default$1()));
        try {
            TransactionWork<Tuple2<Object, StructType>> runTransaction = new TransactionWork<Tuple2<Object, StructType>>(parameters, limitedQuery){
                private final java.util.Map parameters$1;
                private final String limitedQuery$1;

                public Tuple2<Object, StructType> execute(Transaction tx) {
                    Result result = tx.run(this.limitedQuery$1, this.parameters$1);
                    if (result.hasNext()) {
                        Record peek = result.next();
                        Buffer fields = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(peek.keys()).asScala()).map((Function1)new Serializable(this, peek){
                            public static final long serialVersionUID = 0L;
                            private final Record peek$1;

                            public final Tuple2<String, Type> apply(String k) {
                                return new Tuple2((Object)k, (Object)this.peek$1.get(k).type());
                            }
                            {
                                this.peek$1 = peek$1;
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final StructField apply(Tuple2<String, Type> keyType) {
                                return CypherTypes$.MODULE$.field(keyType);
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)peek.size()), (Object)StructType$.MODULE$.apply((Seq)fields));
                    }
                    throw new RuntimeException("Can't determine schema from empty result");
                }
                {
                    this.parameters$1 = parameters$1;
                    this.limitedQuery$1 = limitedQuery$1;
                }
            };
            tuple2 = session.readTransaction(runTransaction);
            Neo4jUtils$.MODULE$.close(driver, session);
        }
        catch (Throwable throwable) {
            void var7_7;
            void var6_6;
            Neo4jUtils$.MODULE$.close((Driver)var6_6, (Session)var7_7);
            throw throwable;
        }
        Tuple2<Object, StructType> tuple22 = tuple2;
        if (tuple22 != null) {
            Tuple2 tuple23;
            int peekSize = tuple22._1$mcI$sp();
            StructType schema = (StructType)tuple22._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)peekSize), (Object)schema);
            int peekSize2 = tuple24._1$mcI$sp();
            StructType schema2 = (StructType)tuple24._2();
            Neo4jDataFrame.Neo4jResultRdd rowRdd = new Neo4jDataFrame.Neo4jResultRdd(sqlContext.sparkContext(), peekSize2, Neo4jConfig$.MODULE$.apply(sqlContext.sparkContext().getConf()), query, parameters);
            return sqlContext.createDataFrame((RDD)rowRdd, schema2);
        }
        throw new MatchError(tuple22);
    }

    private Neo4jDataFrame$() {
        MODULE$ = this;
    }
}

