/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.spark.utils;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.spark.Neo4jConfig;
import org.neo4j.spark.utils.Neo4jUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple4;

public final class Neo4jUtils$ {
    public static final Neo4jUtils$ MODULE$;
    private final Logger logger;
    private final RetryConfig retryConfig;

    static {
        new Neo4jUtils$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void close(Driver driver, Session session) {
        try {
            if (session != null && session.isOpen()) {
                this.closeSafety(session);
            }
            return;
        }
        finally {
            if (driver != null) {
                this.closeSafety(driver);
            }
        }
    }

    private void closeSafety(AutoCloseable closable) {
        try {
            closable.close();
        }
        catch (Throwable throwable) {
            this.logger().error("Exception while trying to close an AutoCloseable, because of the following exception", throwable);
        }
    }

    private RetryConfig retryConfig() {
        return this.retryConfig;
    }

    public <T> Tuple4<Driver, Session, Transaction, Result> executeTxWithRetries(Neo4jConfig neo4jConfig, String query, Map<String, Object> params, boolean write) {
        Driver driver = neo4jConfig.driver();
        Session session = driver.session(neo4jConfig.sessionConfig(write));
        return Retry.decorateCallable(Retry.of("neo4jTransactionRetryPool", this.retryConfig()), new Callable<Tuple4<Driver, Session, Transaction, Result>>(query, params, driver, session){
            private final String query$1;
            private final Map params$1;
            private final Driver driver$1;
            private final Session session$1;

            public Tuple4<Driver, Session, Transaction, Result> call() {
                Transaction transaction = this.session$1.beginTransaction();
                Result result = transaction.run(this.query$1, this.params$1);
                return new Tuple4((Object)this.driver$1, (Object)this.session$1, (Object)transaction, (Object)result);
            }
            {
                this.query$1 = query$1;
                this.params$1 = params$1;
                this.driver$1 = driver$1;
                this.session$1 = session$1;
            }
        }).call();
    }

    public Object convert(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object2;
            object = new Timestamp(DateTimeUtils$.MODULE$.fromUTCTime(zonedDateTime.toInstant().toEpochMilli(), zonedDateTime.getZone().getId()));
        } else if (object2 instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object2;
            object = new Timestamp(DateTimeUtils$.MODULE$.fromUTCTime(localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli(), "UTC"));
        } else if (object2 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object2;
            object = Date.valueOf(localDate);
        } else if (object2 instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object2;
            object = new Timestamp(offsetTime.atDate(LocalDate.ofEpochDay(0L)).toInstant().toEpochMilli());
        } else {
            object = value;
        }
        return object;
    }

    private Neo4jUtils$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(Neo4jUtils.class);
        this.retryConfig = RetryConfig.custom().retryExceptions(SessionExpiredException.class, ServiceUnavailableException.class).retryOnException(new Predicate<Throwable>(){

            public boolean test(Throwable exception) {
                TransientException transientException;
                String code;
                Throwable throwable = exception;
                boolean bl = throwable instanceof TransientException ? !"Neo.TransientError.Transaction.Terminated".equals(code = (transientException = (TransientException)throwable).code()) && !"Neo.TransientError.Transaction.LockClientStopped".equals(code) : false;
                return bl;
            }
        }).maxAttempts(3).build();
    }
}

