/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import scala_maven.Classpath;
import scala_maven.ScalaCompilerSupport;
import scala_maven.TychoUtilities;
import util.FileUtils;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ScalaCompileMojo
extends ScalaCompilerSupport {
    @Parameter(property="maven.main.skip")
    private boolean skipMain;
    @Parameter(property="outputDir", defaultValue="${project.build.outputDirectory}")
    private File outputDir;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../scala")
    private File sourceDir;
    @Parameter(property="analysisCacheFile", defaultValue="${project.build.directory}/analysis/compile")
    private File analysisCacheFile;
    @Deprecated
    @Parameter(property="classpath")
    private Classpath classpath;

    @Override
    protected List<File> getSourceDirectories() throws Exception {
        String scalaSourceDir;
        LinkedList<String> sources = this.project.getCompileSourceRoots();
        if (!sources.contains(scalaSourceDir = FileUtils.pathOf(this.sourceDir, this.useCanonicalPath))) {
            sources = new LinkedList<String>(sources);
            sources.add(scalaSourceDir);
        }
        return this.normalize((List<String>)sources);
    }

    @Override
    protected Set<File> getClasspathElements() throws Exception {
        Set<File> back = FileUtils.fromStrings(this.project.getCompileClasspathElements());
        back.remove(new File(this.project.getBuild().getOutputDirectory()));
        this.addAdditionalDependencies(back);
        if (this.classpath != null && this.classpath.getAdd() != null) {
            this.getLog().warn((CharSequence)"using 'classpath' is deprecated, use 'additionalDependencies' instead");
            for (File f : this.classpath.getAdd()) {
                back.add(f);
            }
        }
        back.addAll(FileUtils.fromStrings(TychoUtilities.addOsgiClasspathElements(this.project)));
        return back;
    }

    @Override
    @Deprecated
    protected List<Dependency> getDependencies() {
        return this.project.getCompileDependencies();
    }

    @Override
    protected File getOutputDir() {
        return this.outputDir.getAbsoluteFile();
    }

    @Override
    protected File getAnalysisCacheFile() {
        return this.analysisCacheFile.getAbsoluteFile();
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMain) {
            this.getLog().info((CharSequence)"Not compiling main sources");
            return;
        }
        super.execute();
    }
}

