/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import scala_maven.ScalaMojoSupport;
import util.FileUtils;

public abstract class ScalaSourceMojoSupport
extends ScalaMojoSupport {
    @Parameter(defaultValue="true")
    protected boolean sendJavaToScalac = true;
    @Parameter
    protected Set<String> includes = new TreeSet<String>();
    @Parameter
    private Set<String> excludes = new TreeSet<String>();
    @Parameter(property="additionalDependencies")
    private Dependency[] additionalDependencies;
    private boolean _filterPrinted = false;

    protected abstract List<File> getSourceDirectories() throws Exception;

    List<File> findSourceWithFilters() throws Exception {
        return this.findSourceWithFilters(this.getSourceDirectories());
    }

    private void initFilters() throws Exception {
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.scala");
            if (this.sendJavaToScalac && this.isJavaSupportedByCompiler()) {
                this.includes.add("**/*.java");
            }
        }
        if (!this._filterPrinted && this.getLog().isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("includes = [");
            for (String include : this.includes) {
                builder.append(include).append(",");
            }
            builder.append("]");
            this.getLog().debug((CharSequence)builder.toString());
            builder = new StringBuilder("excludes = [");
            for (String exclude : this.excludes) {
                builder.append(exclude).append(",");
            }
            builder.append("]");
            this.getLog().debug((CharSequence)builder.toString());
            this._filterPrinted = true;
        }
    }

    List<File> findSourceWithFilters(List<File> sourceRootDirs) throws Exception {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        this.initFilters();
        for (File dir : sourceRootDirs) {
            String[] tmpFiles;
            for (String tmpLocalFile : tmpFiles = ScalaSourceMojoSupport.findFiles(dir, this.includes.toArray(new String[0]), this.excludes.toArray(new String[0]))) {
                File tmpAbsFile = FileUtils.fileOf(new File(dir, tmpLocalFile), this.useCanonicalPath);
                sourceFiles.add(tmpAbsFile);
            }
        }
        Collections.sort(sourceFiles);
        return sourceFiles;
    }

    private static String[] findFiles(File dir, String[] includes, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    List<File> normalize(List<String> compileSourceRootsList) throws Exception {
        ArrayList<File> newCompileSourceRootsList = new ArrayList<File>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                File srcDirFile = FileUtils.fileOf(new File(srcDir), this.useCanonicalPath);
                if (newCompileSourceRootsList.contains(srcDirFile) || !srcDirFile.exists()) continue;
                newCompileSourceRootsList.add(srcDirFile);
            }
        }
        return newCompileSourceRootsList;
    }

    protected void addAdditionalDependencies(Set<File> back) throws Exception {
        if (this.additionalDependencies != null) {
            for (Dependency dependency : this.additionalDependencies) {
                this.addToClasspath(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getClassifier(), back, false);
            }
        }
    }
}

