/*
 * Decompiled with CFR 0.152.
 */
package net_alchim31_maven_yuicompressor;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.codehaus.plexus.util.IOUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class BasicRhinoShell
extends ScriptableObject {
    private boolean quitting;

    public String getClassName() {
        return "global";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exec(String[] args, ErrorReporter reporter) {
        Context cx = Context.enter();
        cx.setErrorReporter(reporter);
        try {
            Object[] array;
            BasicRhinoShell BasicRhinoShell2 = new BasicRhinoShell();
            cx.initStandardObjects((ScriptableObject)BasicRhinoShell2);
            String[] names = new String[]{"print", "quit", "version", "load", "help", "readFile", "warn"};
            BasicRhinoShell2.defineFunctionProperties(names, BasicRhinoShell.class, 2);
            args = BasicRhinoShell.processOptions(cx, args);
            if (args.length == 0) {
                array = new Object[]{};
            } else {
                int length = args.length - 1;
                array = new Object[length];
                System.arraycopy(args, 1, array, 0, length);
            }
            Scriptable argsObj = cx.newArray((Scriptable)BasicRhinoShell2, array);
            BasicRhinoShell2.defineProperty("arguments", argsObj, 2);
            BasicRhinoShell2.processSource(cx, args.length == 0 ? null : args[0]);
        }
        finally {
            Context.exit();
        }
    }

    public static String[] processOptions(Context cx, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                String[] result = new String[args.length - i];
                for (int j = i; j < args.length; ++j) {
                    result[j - i] = args[j];
                }
                return result;
            }
            if (arg.equals("-version")) {
                double d;
                if (++i == args.length) {
                    BasicRhinoShell.usage(arg);
                }
                if ((d = Context.toNumber((Object)args[i])) != d) {
                    BasicRhinoShell.usage(arg);
                }
                cx.setLanguageVersion((int)d);
                continue;
            }
            BasicRhinoShell.usage(arg);
        }
        return new String[0];
    }

    private static void usage(String s) {
        BasicRhinoShell.p("Didn't understand \"" + s + "\".");
        BasicRhinoShell.p("Valid arguments are:");
        BasicRhinoShell.p("-version 100|110|120|130|140|150|160|170");
        System.exit(1);
    }

    public void help() {
        BasicRhinoShell.p("");
        BasicRhinoShell.p("Command                Description");
        BasicRhinoShell.p("=======                ===========");
        BasicRhinoShell.p("help()                 Display usage and help messages. ");
        BasicRhinoShell.p("defineClass(className) Define an extension using the Java class");
        BasicRhinoShell.p("                       named with the string argument. ");
        BasicRhinoShell.p("                       Uses ScriptableObject.defineClass(). ");
        BasicRhinoShell.p("load(['foo.js', ...])  Load JavaScript source files named by ");
        BasicRhinoShell.p("                       string arguments. ");
        BasicRhinoShell.p("loadClass(className)   Load a class named by a string argument.");
        BasicRhinoShell.p("                       The class must be a script compiled to a");
        BasicRhinoShell.p("                       class file. ");
        BasicRhinoShell.p("print([expr ...])      Evaluate and print expressions. ");
        BasicRhinoShell.p("quit()                 Quit the BasicRhinoShell. ");
        BasicRhinoShell.p("version([number])      Get or set the JavaScript version number.");
        BasicRhinoShell.p("");
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                System.out.print(" ");
            }
            String s = Context.toString((Object)args[i]);
            System.out.print(s);
        }
        System.out.println();
    }

    public void quit() {
        this.quitting = true;
    }

    public static void warn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        String message = Context.toString((Object)args[0]);
        int line = (int)Context.toNumber((Object)args[1]);
        String source = Context.toString((Object)args[2]);
        int column = (int)Context.toNumber((Object)args[3]);
        cx.getErrorReporter().warning(message, null, line, source, column);
    }

    public String readFile(String path) {
        try {
            return IOUtil.toString((InputStream)new FileInputStream(path));
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new RuntimeException("wrap: " + exc.getMessage(), exc);
        }
    }

    public static double version(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double result = cx.getLanguageVersion();
        if (args.length > 0) {
            double d = Context.toNumber((Object)args[0]);
            cx.setLanguageVersion((int)d);
        }
        return result;
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        BasicRhinoShell BasicRhinoShell2 = (BasicRhinoShell)BasicRhinoShell.getTopLevelScope((Scriptable)thisObj);
        for (Object element : args) {
            BasicRhinoShell2.processSource(cx, Context.toString((Object)element));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSource(Context cx, String filename) {
        if (filename == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String sourceName = "<stdin>";
            int lineno = 1;
            boolean hitEOF = false;
            do {
                int startline = lineno;
                System.err.print("js> ");
                System.err.flush();
                try {
                    String source = "";
                    do {
                        String newline;
                        if ((newline = in.readLine()) == null) {
                            hitEOF = true;
                            break;
                        }
                        source = source + newline + "\n";
                        ++lineno;
                    } while (!cx.stringIsCompilableUnit(source));
                    Object result = cx.evaluateString((Scriptable)this, source, sourceName, startline, null);
                    if (result == Context.getUndefinedValue()) continue;
                    System.err.println(Context.toString((Object)result));
                }
                catch (WrappedException we) {
                    System.err.println(we.getWrappedException().toString());
                    we.printStackTrace();
                }
                catch (EvaluatorException ee) {
                    System.err.println("js: " + ee.getMessage());
                }
                catch (JavaScriptException jse) {
                    System.err.println("js: " + jse.getMessage());
                }
                catch (IOException ioe) {
                    System.err.println(ioe.toString());
                }
            } while (!this.quitting && !hitEOF);
            System.err.println();
        } else {
            FileReader in = null;
            try {
                in = new FileReader(filename);
            }
            catch (FileNotFoundException ex) {
                Context.reportError((String)("Couldn't open file \"" + filename + "\"."));
                return;
            }
            try {
                cx.evaluateReader((Scriptable)this, (Reader)in, filename, 1, null);
            }
            catch (WrappedException we) {
                System.err.println(we.getWrappedException().toString());
                we.printStackTrace();
            }
            catch (EvaluatorException ee) {
                System.err.println("js: " + ee.getMessage());
            }
            catch (JavaScriptException jse) {
                System.err.println("js: " + jse.getMessage());
            }
            catch (IOException ioe) {
                System.err.println(ioe.toString());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ioe) {
                    System.err.println(ioe.toString());
                }
            }
        }
    }

    private static void p(String s) {
        System.out.println(s);
    }
}

