/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.misc;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import org.apache.commons.lang3.StringUtils;

public class ISSNS
extends MockUnitBase
implements MockUnitString {
    private static final String ISSN_PREFIX = "ISSN";

    public static ISSNS issns() {
        return MockNeat.threadLocal().issns();
    }

    protected ISSNS() {
    }

    public ISSNS(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return () -> {
            Object[] array = this.mockNeat.ints().range(0, 10).array(7).val();
            int sum = 0;
            int i = 0;
            int j = 8;
            while (i < array.length) {
                sum += j * array[i];
                ++i;
                --j;
            }
            int remainder = sum % 11;
            if (remainder != 0) {
                remainder = 11 - remainder;
            }
            return "ISSN " + StringUtils.join((Object[])array, (String)"", (int)0, (int)4) + "-" + StringUtils.join((Object[])array, (String)"", (int)4, (int)7) + (remainder == 10 ? "X" : remainder + "");
        };
    }
}

