/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.utils.MockUnitUtils;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public class Constructor<T>
implements MockUnit<T> {
    private final Class<T> cls;
    private Object[] params = new Object[0];

    public static <T> Constructor<T> constructor(Class<T> cls) {
        return MockNeat.threadLocal().constructor(cls);
    }

    public Constructor(Class<T> cls) {
        this.cls = cls;
    }

    public Constructor<T> params(Object ... params) {
        this.params = params;
        return this;
    }

    @Override
    public Supplier<T> supplier() {
        ValidationUtils.notNull(this.cls, "cls");
        ValidationUtils.notNull(this.params, "params");
        Object[] args = new Object[this.params.length];
        return () -> {
            IntStream.range(0, this.params.length).forEach(i -> {
                args[i] = MockUnitUtils.mockOrObject(this.params[i]);
            });
            try {
                return ConstructorUtils.invokeConstructor(this.cls, (Object[])args);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                String fmt = AlephFormatter.str((String)"Cannot infer #{c.name}.#{params}. Are you sure the constructor exists and it's public ?").args(new Object[]{"c", this.cls}).args(new Object[]{"params", MockUnitUtils.listTypes(this.params)}).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
    }
}

