/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockConstValue;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitValue;
import net.andreinc.mockneat.abstraction.MockValue;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class Reflect<T>
extends MockUnitBase
implements MockUnit<T> {
    private static final Pattern JAVA_FIELD_REGEX = Pattern.compile("^[a-zA-Z_$][a-zA-Z_$0-9]*$");
    private final Map<String, MockValue<?>> fields = new LinkedHashMap();
    private boolean useDefaults;
    private final Map<Class<?>, MockValue<?>> defaults = new HashMap();
    private final Class<T> cls;

    public static <T> Reflect<T> reflect(Class<T> cls) {
        return MockNeat.threadLocal().reflect(cls);
    }

    protected Reflect(Class<T> cls) {
        this(MockNeat.threadLocal(), cls);
    }

    public Reflect(MockNeat mockNeat, Class<T> cls) {
        super(mockNeat);
        this.cls = cls;
        this.initDefaults();
    }

    private void initDefaults() {
        this.type(Boolean.TYPE, this.mockNeat.bools());
        this.type(Boolean.class, this.mockNeat.bools());
        this.type(Character.TYPE, this.mockNeat.chars().letters());
        this.type(Character.class, this.mockNeat.chars().letters());
        this.type(Short.TYPE, this.mockNeat.ints().bound(100).map(Integer::shortValue));
        this.type(Short.class, this.mockNeat.ints().bound(100).map(Integer::shortValue));
        this.type(Integer.TYPE, this.mockNeat.ints().bound(100));
        this.type(Integer.class, this.mockNeat.ints().bound(100));
        this.type(Long.TYPE, this.mockNeat.longs().bound(100L));
        this.type(Long.class, this.mockNeat.longs().bound(100L));
        this.type(Double.TYPE, this.mockNeat.doubles().bound(10.0));
        this.type(Double.class, this.mockNeat.doubles().bound(10.0));
        this.type(Float.TYPE, this.mockNeat.floats().bound(10.0f));
        this.type(Float.class, this.mockNeat.floats().bound(10.0f));
        this.type(String.class, this.mockNeat.strings().size(32));
    }

    @Override
    public Supplier<T> supplier() {
        ValidationUtils.notNull(this.cls, "cls");
        this.validateFields();
        return () -> {
            T instance = this.instance();
            this.setValues(instance);
            return instance;
        };
    }

    public <T1> Reflect<T> field(String fieldName, MockUnit<T1> mockUnit) {
        ValidationUtils.notEmpty(fieldName, "fieldName");
        ValidationUtils.notNull(mockUnit, "mockUnit");
        this.fields.put(fieldName, MockUnitValue.unit(mockUnit));
        return this;
    }

    public Reflect<T> field(String fieldName, Object value) {
        ValidationUtils.notEmpty(fieldName, "fieldName");
        this.fields.put(fieldName, MockConstValue.constant(value));
        return this;
    }

    public Reflect<T> useDefaults(boolean status) {
        this.useDefaults = status;
        return this;
    }

    public Reflect<T> type(Class<?> cls, Object value) {
        ValidationUtils.notNull(cls, "cls");
        this.defaults.put(cls, MockConstValue.constant(value));
        return this;
    }

    public <T1> Reflect<T> type(Class<T1> cls, MockUnit<T1> mockUnit) {
        ValidationUtils.notNull(cls, "cls");
        ValidationUtils.notNull(mockUnit, "mockUnit");
        this.defaults.put(cls, MockUnitValue.unit(mockUnit));
        return this;
    }

    private void validateFields() {
        ValidationUtils.notNull(this.fields, "fields");
        this.fields.forEach((k, v) -> {
            ValidationUtils.notEmpty(k, "fieldName");
            ValidationUtils.isTrue(JAVA_FIELD_REGEX.matcher((CharSequence)k).matches(), "Field '#{field}' doesn't match the Java Naming Conventions for fields.", "field", k);
            Field field = FieldUtils.getDeclaredField(this.cls, (String)k, (boolean)true);
            if (field == null) {
                String fmt = AlephFormatter.str((String)"Cannot access field: '#{field}'.").args(new Object[]{"field", k}).fmt();
                throw new IllegalArgumentException(fmt);
            }
            boolean isFinal = (field.getModifiers() & 0x10) == 16;
            ValidationUtils.isTrue(!isFinal, "Field '#{field}' is marked as FINAL. It cannot be modified. Please remove it from the fields list.", "field", k);
        });
    }

    private T instance() {
        try {
            return this.cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            String fmt = AlephFormatter.str((String)"Cannot create an instance of '#{cls.name}'. Please verify if the class has a public 'No Arguments' constructor: #{cls.name}.").arg("cls", this.cls).fmt();
            throw new IllegalArgumentException(fmt, e);
        }
    }

    private void setValues(T object) {
        FieldUtils.getAllFieldsList(this.cls).forEach(field -> {
            if (field.isSynthetic()) {
                return;
            }
            if (Modifier.isStatic(field.getModifiers())) {
                return;
            }
            String name = field.getName();
            Class<?> fieldCls = field.getType();
            Object val = null;
            if (this.fields.containsKey(name)) {
                val = this.fields.get(name).get();
            } else if (this.defaults.containsKey(fieldCls) && this.useDefaults) {
                val = this.defaults.get(fieldCls).get();
            }
            try {
                FieldUtils.writeField((Object)object, (String)name, val, (boolean)true);
            }
            catch (IllegalAccessException e) {
                String fmt = AlephFormatter.str((String)"Cannot set field (or static field) #{cls}.#{field} with value '#{val}'. Is the supplied value correct ?").arg("cls", fieldCls).arg("field", (Object)name).arg("val", val).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        });
    }
}

