/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitInt;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.types.enums.StringType;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.RandomStringUtils;

public class Strings
extends MockUnitBase
implements MockUnitString {
    private final Random random;
    private int size = 64;
    private MockUnitInt sizeUnit;

    public static Strings strings() {
        return MockNeat.threadLocal().strings();
    }

    protected Strings() {
        this.random = this.mockNeat.getRandom();
    }

    public Strings(MockNeat mockNeat) {
        super(mockNeat);
        this.random = mockNeat.getRandom();
    }

    public Strings size(int size) {
        ValidationUtils.isTrue(size > 0, "The size needs to be bigger than 0 (>).", new Object[0]);
        this.size = size;
        return this;
    }

    public Strings size(MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "Input parameter: '#{input}' should not be NULL.", "sizeUnit");
        this.sizeUnit = sizeUnit;
        return this;
    }

    protected int getSize() {
        return this.sizeUnit != null ? (Integer)this.sizeUnit.val() : this.size;
    }

    public MockUnitString type(StringType type) {
        ValidationUtils.notNull(type, "Input parameter: '#{input}' should not be NULL.", "type");
        switch (type) {
            case HEX: {
                return this::hex;
            }
            case NUMBERS: {
                return this::numbers;
            }
            case LETTERS: {
                return this::letters;
            }
            case ALPHA_NUMERIC: {
                return this::alphaNumeric;
            }
            case SPECIAL_CHARACTERS: {
                return this::specialChars;
            }
        }
        throw new IllegalArgumentException("Invalid StringType");
    }

    public MockUnitString types(StringType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            StringType type = this.mockNeat.from(types).val();
            return this.type(type).supplier();
        };
    }

    private Supplier<String> numbers() {
        return () -> RandomStringUtils.random((int)this.getSize(), (int)0, (int)0, (boolean)false, (boolean)true, null, (Random)this.random);
    }

    private Supplier<String> letters() {
        return () -> RandomStringUtils.random((int)this.getSize(), (int)0, (int)0, (boolean)true, (boolean)false, null, (Random)this.random);
    }

    private Supplier<String> alphaNumeric() {
        return () -> RandomStringUtils.random((int)this.getSize(), (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.random);
    }

    private Supplier<String> hex() {
        return () -> this.mockNeat.fromStrings(Alphabets.HEXA_STR).stream().val().limit(this.getSize()).collect(Collectors.joining());
    }

    private Supplier<String> specialChars() {
        return () -> this.mockNeat.fromStrings(Alphabets.SPECIAL_CHARACTERS_STR).stream().val().limit(this.getSize()).collect(Collectors.joining());
    }

    @Override
    public Supplier<String> supplier() {
        return () -> RandomStringUtils.random((int)this.getSize(), (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.random);
    }
}

