/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.time;

import java.time.Month;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitMonth;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Months
extends MockUnitBase
implements MockUnitMonth {
    public static Months months() {
        return MockNeat.threadLocal().months();
    }

    public Months(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<Month> supplier() {
        return this.mockNeat.from(Month.class)::val;
    }

    public MockUnitMonth rangeClosed(Month lower, Month upper) {
        ValidationUtils.notNull(lower, "lower");
        ValidationUtils.notNull(upper, "upper");
        ValidationUtils.isTrue(lower.getValue() < upper.getValue(), "'lower' Month < 'upper' Month", new Object[0]);
        Supplier<Month> supp = () -> {
            int idx = (Integer)this.mockNeat.ints().range(lower.getValue() - 1, upper.getValue()).val();
            return Month.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitMonth range(Month lower, Month upper) {
        ValidationUtils.notNull(lower, "lower");
        ValidationUtils.notNull(upper, "upper");
        ValidationUtils.isTrue(lower.getValue() < upper.getValue(), "'lower' Month < 'upper' Month", new Object[0]);
        Supplier<Month> supp = () -> {
            int idx = (Integer)this.mockNeat.ints().range(lower.getValue() - 1, upper.getValue() - 1).val();
            return Month.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitMonth before(Month before) {
        ValidationUtils.notNull(before, "before");
        ValidationUtils.isTrue(before.getValue() - 1 > 0, "Cannot use 'January' as 'before'. 'January' is considered to be the first month of the year.", new Object[0]);
        return this.range(Month.values()[0], before);
    }

    public MockUnitMonth after(Month after) {
        ValidationUtils.notNull(after, "after");
        ValidationUtils.isTrue(after.getValue() < Month.values().length - 1, "Cannot use 'December' as 'after'. 'December' is considered to be the last month of the year.", new Object[0]);
        Supplier<Month> supp = () -> {
            int idx = (Integer)this.mockNeat.ints().range(after.getValue(), Month.values().length).val();
            return Month.values()[idx];
        };
        return () -> supp;
    }
}

