/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.anotheria.moskito.webcontrol.IOUtils;
import net.anotheria.moskito.webcontrol.configuration.IntervalConfiguration;
import net.anotheria.moskito.webcontrol.configuration.ServersConfig;
import net.anotheria.moskito.webcontrol.configuration.StatsSource;
import net.anotheria.moskito.webcontrol.configuration.ViewConfiguration;
import net.anotheria.moskito.webcontrol.configuration.ViewField;
import net.anotheria.moskito.webcontrol.feed.HttpGetter;
import net.anotheria.moskito.webcontrol.guards.Guard;
import net.anotheria.moskito.webcontrol.repository.ColumnType;
import net.anotheria.moskito.webcontrol.repository.TotalFormulaType;
import net.anotheria.moskito.webcontrol.ui.beans.PatternWithName;
import net.anotheria.util.StringUtils;
import org.apache.log4j.Logger;
import org.configureme.ConfigurationManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public enum ConfigurationRepository {
    INSTANCE;

    private ConcurrentMap<String, ViewConfiguration> views = new ConcurrentHashMap();
    private List<StatsSource> sources = new CopyOnWriteArrayList();
    private List<IntervalConfiguration> intervals = new ArrayList();
    private List<String> allCategories;
    private List<ViewField> avaibleColumns = new ArrayList();
    public static final String TOTALS_SOURCE_NAME = "Totals";
    private static final Logger log;

    private ConfigurationRepository() {
        this.allCategories = new ArrayList();
        ConfigurationManager.INSTANCE.configure((Object)ServersConfig.INSTANCE);
    }

    public void addInterval(String name, String containerName) {
        this.intervals.add(new IntervalConfiguration(name, containerName));
    }

    public List<String> getIntervalsNames() {
        ArrayList<String> res = new ArrayList<String>();
        for (IntervalConfiguration config : this.intervals) {
            res.add(config.getName());
        }
        return res;
    }

    public String getContainerName(String name) {
        for (IntervalConfiguration config : this.intervals) {
            if (!name.equals(config.getName())) continue;
            return config.getContainerName();
        }
        return null;
    }

    public void addView(ViewConfiguration toAdd) {
        this.views.put(toAdd.getName(), toAdd);
    }

    public List<ViewConfiguration> getAllViews() {
        ArrayList<ViewConfiguration> ret = new ArrayList<ViewConfiguration>();
        ret.addAll(this.views.values());
        return ret;
    }

    public ViewConfiguration getView(String viewName) {
        ViewConfiguration ret = (ViewConfiguration)this.views.get(viewName);
        if (ret == null) {
            throw new IllegalArgumentException("Unknown view: " + viewName);
        }
        return ret;
    }

    public void removeView(ViewConfiguration toRemove) {
        this.views.remove(toRemove.getName());
    }

    public List<String> getViewNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(new TreeSet(this.views.keySet()));
        Collections.sort(ret);
        return ret;
    }

    public List<StatsSource> getSources() {
        ArrayList<StatsSource> ret = new ArrayList<StatsSource>();
        ret.addAll(this.sources);
        return ret;
    }

    public void addSource(StatsSource toAdd) {
        if (!this.sources.contains(toAdd)) {
            this.sources.add(toAdd);
        }
    }

    public List<ViewField> getAvailableColumns() {
        ArrayList<ViewField> ret = new ArrayList<ViewField>();
        ret.addAll(this.avaibleColumns);
        return ret;
    }

    public List<String> getAvailableCategories() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.allCategories);
        return ret;
    }

    public void addAvaiableColumn(ViewField column) {
        this.avaibleColumns.add(column);
    }

    public void loadViewsConfiguration() throws IOException, JSONException {
        InputStream intervalsIS = Thread.currentThread().getContextClassLoader().getResourceAsStream("moskitowc-intervals.json");
        String content = IOUtils.getInputStreamAsString((InputStream)intervalsIS);
        JSONArray intrvls = new JSONObject(content).getJSONArray("intervals");
        for (int i = 0; i < intrvls.length(); ++i) {
            JSONObject interval = intrvls.getJSONObject(i);
            this.addInterval(interval.getString("name"), interval.getString("containerName"));
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("moskitowc-views.json");
        content = IOUtils.getInputStreamAsString((InputStream)is);
        JSONObject views = new JSONObject(content);
        ServersConfig serversConfig = ServersConfig.INSTANCE;
        String producerPath = views.getString("baseURL");
        for (String host : serversConfig.getHosts()) {
            StatsSource source = new StatsSource(host, serversConfig.makeURL(host, producerPath), serversConfig.getUsername(), serversConfig.getPassword());
            INSTANCE.addSource(source);
            log.info((Object)("Loaded source: " + source));
        }
        this.updateViews(views);
    }

    public void updateViews(JSONObject views) throws JSONException {
        INSTANCE.clearViews();
        JSONArray viewList = views.getJSONArray("views");
        for (int i = 0; i < viewList.length(); ++i) {
            JSONObject view = viewList.getJSONObject(i);
            ViewConfiguration viewConfig = new ViewConfiguration(view.getString("name"));
            JSONArray columns = view.getJSONArray("columns");
            for (int k = 0; k < columns.length(); ++k) {
                JSONObject column = columns.getJSONObject(k);
                viewConfig.addField(ConfigurationRepository.prepareField((JSONObject)column));
            }
            INSTANCE.addView(viewConfig);
        }
    }

    private void clearViews() {
        this.views.clear();
    }

    public static ViewField prepareField(JSONObject column) throws JSONException {
        String format;
        String guard;
        String total;
        String columnName = column.getString("attribute");
        String name = column.getString("name");
        String type = column.getString("type");
        String klass = (String)column.opt("class");
        if (StringUtils.isEmpty((String)klass)) {
            klass = "unknown";
        }
        Boolean visible = column.getBoolean("visible");
        String path = (String)column.opt("path");
        ViewField field = new ViewField(name, columnName, ColumnType.convert((String)type), klass, visible, path);
        JSONArray inputs = (JSONArray)column.opt("inputs");
        if (inputs != null) {
            ArrayList<String> inputsList = new ArrayList<String>();
            for (int j = 0; j < inputs.length(); ++j) {
                inputsList.add(inputs.getString(j));
            }
            field.setInputs(inputsList);
        }
        if (StringUtils.isEmpty((String)(total = (String)column.opt("total")))) {
            total = "EMPTY";
        }
        if (!StringUtils.isEmpty((String)(guard = (String)column.opt("guard")))) {
            try {
                Class<?> guardClass = Class.forName(guard);
                Guard instance = (Guard)guardClass.newInstance();
                String guardRules = (String)column.opt("guardRules");
                if (!StringUtils.isEmpty((String)guardRules)) {
                    instance.setRules(guardRules);
                }
                field.setGuard(instance);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)(format = (String)column.opt("format")))) {
            field.setFormat(format.trim());
        }
        field.setTotal(TotalFormulaType.convert((String)total));
        return field;
    }

    public void loadAllAvailableColumns() throws JSONException, IOException, XPathExpressionException, CloneNotSupportedException {
        String interval = null;
        List intervals = INSTANCE.getIntervalsNames();
        if (intervals.size() > 0) {
            interval = intervals.size() > 0 ? (String)intervals.get(0) : "default";
        }
        StatsSource source = null;
        List sourceList = INSTANCE.getSources();
        if (sourceList.size() <= 0) {
            throw new RuntimeException("there is no any server config");
        }
        source = (StatsSource)sourceList.get(0);
        HttpGetter getter = new HttpGetter();
        StatsSource sourceConf = source.build("&pInterval=" + interval);
        Document doc = getter.retreive(sourceConf);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("moskitowc-views.json");
        String content = IOUtils.getInputStreamAsString((InputStream)is);
        JSONObject views = new JSONObject(content);
        JSONObject baseColumn = views.getJSONObject("baseColumn");
        ViewField baseField = ConfigurationRepository.prepareField((JSONObject)baseColumn);
        HashMap<String, ViewField> map = new HashMap<String, ViewField>();
        ArrayList<PatternWithName> result = new ArrayList<PatternWithName>();
        result.add(new PatternWithName("", baseField.getPath()));
        ConfigurationRepository.buildFullPath(result, (Document)doc);
        for (PatternWithName p : result) {
            ViewField column = (ViewField)baseField.clone();
            column.setAttributeName(p.getFieldName());
            column.setFieldName(p.getFieldName());
            column.setPath(p.getPattern());
            map.put(column.getAttributeName(), column);
        }
        System.out.println("map size = " + map.entrySet().size());
        System.out.println("result size = " + this.avaibleColumns.size());
        for (ViewField vf : map.values()) {
            this.findAndSetCategory(vf, doc);
            this.addAvaiableColumn(vf);
        }
    }

    private void findAndSetCategory(ViewField field, Document doc) throws XPathExpressionException {
        String patternXPATH = "../../category/text()";
        String p = field.getPath().substring(0, field.getPath().indexOf("text()")) + patternXPATH;
        XPath xpath = XPathFactory.newInstance().newXPath();
        String category = (String)xpath.compile(p).evaluate(doc, XPathConstants.STRING);
        if (!this.allCategories.contains(category)) {
            this.allCategories.add(category);
        }
        field.setCategory(category);
    }

    public static boolean isWildCard(String pattern) {
        Pattern p = Pattern.compile("\\[@([^=]+)='([^*\\]]*\\*[^\\]]*)'\\]+");
        Matcher m = p.matcher(pattern);
        return m.find();
    }

    public static void buildFullPath(List<PatternWithName> result, Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        ArrayList<PatternWithName> res = new ArrayList<PatternWithName>();
        for (int j = 0; j < result.size(); ++j) {
            PatternWithName pattern = result.get(j);
            if (!ConfigurationRepository.isWildCard((String)pattern.getPattern())) continue;
            result.remove(pattern);
            Pattern p = Pattern.compile("\\[@([^=]+)='([^*\\]]*\\*[^\\]]*)'\\]+");
            Matcher m = p.matcher(pattern.getPattern());
            while (m.find()) {
                String fullMatch = m.group(0);
                String attributeName = m.group(1);
                String value = m.group(2);
                String start = pattern.getPattern().substring(0, pattern.getPattern().indexOf(fullMatch));
                NodeList list = (NodeList)xpath.compile(start).evaluate(doc, XPathConstants.NODESET);
                for (int i = 0; i < list.getLength(); ++i) {
                    String attributeValue = list.item(i).getAttributes().getNamedItem(attributeName).getNodeValue();
                    if (!ConfigurationRepository.checkAttributeValue((String)value, (String)attributeValue)) continue;
                    String s = value.replaceAll("\\*", "\\\\*");
                    String replMatch = fullMatch.replaceAll(s, attributeValue);
                    int idxOf = pattern.getPattern().indexOf(fullMatch);
                    String nextMatch = pattern.getPattern().substring(0, idxOf) + replMatch + pattern.getPattern().substring(idxOf + fullMatch.length(), pattern.getPattern().length());
                    res.add(new PatternWithName((pattern.getFieldName().equals("") ? "" : pattern.getFieldName() + "_") + attributeValue, nextMatch));
                }
            }
        }
        if (res.size() > 0) {
            for (PatternWithName p : res) {
                result.add(p);
            }
            ConfigurationRepository.buildFullPath(result, (Document)doc);
        }
    }

    private static boolean checkAttributeValue(String value, String attributeValue) {
        String pattern = value.replaceAll("\\*", "(.*)");
        Pattern p = Pattern.compile("^" + pattern + "$");
        Matcher m = p.matcher(attributeValue);
        return m.find();
    }

    static {
        log = Logger.getLogger(ConfigurationRepository.class);
    }
}

