/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.configuration;

import net.anotheria.util.StringUtils;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.ConfigureMe;

@ConfigureMe(name="moskitowc-servers", allfields=true)
public enum ServersConfig {
    INSTANCE;

    private String[] hosts;
    private String appPath;
    private String username;
    private String password;
    private boolean https = false;

    private ServersConfig() {
        ConfigurationManager.INSTANCE.configure((Object)this);
    }

    public String getAppPath() {
        return this.appPath;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public String[] getHosts() {
        return this.hosts;
    }

    public void setHosts(String[] hosts) {
        this.hosts = hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isHttps() {
        return this.https;
    }

    public boolean hasCredentials() {
        return !StringUtils.isEmpty((String)this.username) && !StringUtils.isEmpty((String)this.password);
    }

    public void setHttps(boolean https) {
        this.https = https;
    }

    public String makeURL(String host, String producerPath) {
        String scheme = this.isHttps() ? "https://" : "http://";
        String credentials = this.hasCredentials() ? this.username + ":" + this.password + "@" : "";
        return scheme + credentials + host + this.normalizePath(this.appPath) + this.normalizePath(producerPath);
    }

    private String normalizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }
}

