/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.feed;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.anotheria.moskito.webcontrol.configuration.StatsSource;
import net.anotheria.moskito.webcontrol.feed.FeedGetter;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HttpGetter
implements FeedGetter {
    private static Logger log = Logger.getLogger(HttpGetter.class);
    private final int CONNECTION_TIMEOUT = 3000;

    public Document retreive(StatsSource source) {
        System.out.println(source);
        try {
            URL url = new URL(source.getUrl());
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(3000);
            this.authenticateConnection(source, connection);
            return this.buildDocument(connection);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed URL in source configuration : " + source.getUrl()));
        }
        catch (IOException e) {
            log.error((Object)("Error retreiving content for source : " + source.getUrl()));
        }
        catch (SAXException e) {
            log.error((Object)("Error parsing XML for source configuration : " + source.getUrl()), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)("Error parsing XML for source configuration : " + source.getUrl()), (Throwable)e);
        }
        return null;
    }

    private void authenticateConnection(StatsSource source, URLConnection connection) {
        if (source.needAuth()) {
            StringBuilder credentials = new StringBuilder(source.getUsername() + ":" + source.getPassword());
            String encoding = Base64.encodeBase64String((byte[])credentials.toString().getBytes());
            connection.setRequestProperty("Authorization", "Basic " + encoding);
        }
    }

    private Document buildDocument(URLConnection connection) throws ParserConfigurationException, IOException, SAXException {
        if (connection.getContentType() == null) {
            throw new IOException();
        }
        if (connection.getContentType().startsWith("text/xml")) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            return dbf.newDocumentBuilder().parse((InputStream)connection.getContent());
        }
        return null;
    }
}

