/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.moskito.webcontrol.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.moskito.webcontrol.repository.Snapshot;
import net.anotheria.moskito.webcontrol.repository.SnapshotSource;

public class Container {
    private String name;
    private ConcurrentMap<String, Snapshot> snapshots;

    public Container(String aName) {
        this.name = aName;
        this.snapshots = new ConcurrentHashMap();
    }

    public List<Snapshot> getSnapshots() {
        ArrayList<Snapshot> list = new ArrayList<Snapshot>(this.snapshots.size());
        list.addAll(this.snapshots.values());
        return list;
    }

    public void addSnapshot(Snapshot s) {
        this.snapshots.put(s.getSource().toString(), s);
    }

    public Snapshot getSnapshot(SnapshotSource source) {
        return (Snapshot)this.snapshots.get(source.toString());
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "name=" + this.name + ", " + this.snapshots;
    }

    public boolean equals(Object o) {
        return o instanceof Container && this.name.equals(((Container)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

